/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.tests.data.bean.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractDataViewTest {
    private Collection<Item> items;
    private ListDataProvider<Item> dataProvider;
    private DataProvider<Item, ?> wrapperDataProvider;
    private AbstractDataView<Item> dataView;
    private Component component;

    @Before
    public void init() {
        this.items = new ArrayList<Item>(Arrays.asList(new Item(1L, "first", "description1"), new Item(2L, "middle", "description2"), new Item(3L, "last", "description3")));
        this.dataProvider = DataProvider.ofCollection(this.items);
        this.component = new TestComponent();
        this.dataView = new DataViewImpl((SerializableSupplier & Serializable)() -> this.dataProvider, this.component);
    }

    @Test
    public void getItems_noFiltersSet_allItemsObtained() {
        Stream allItems = this.dataView.getItems();
        Assert.assertArrayEquals((String)"Unexpected data set", (Object[])this.items.toArray(), (Object[])allItems.toArray());
    }

    @Test
    public void getItems_filtersSet_filteredItemsObtained() {
        this.dataProvider.setFilter((SerializablePredicate & Serializable)item -> item.getValue().equals("first"));
        Assert.assertArrayEquals((String)"Unexpected data set after filtering", (Object[])new String[]{"first"}, (Object[])this.dataView.getItems().map(Item::getValue).toArray());
    }

    @Test
    public void getItems_sortingSet_sortedItemsObtained() {
        this.dataProvider.setSortOrder(Item::getId, SortDirection.DESCENDING);
        Assert.assertArrayEquals((String)"Unexpected items sorting", (Object[])new Long[]{3L, 2L, 1L}, (Object[])this.dataView.getItems().map(Item::getId).toArray());
    }

    @Test
    public void addItemCountChangeListener_fireEvent_listenerNotified() {
        AtomicInteger fired = new AtomicInteger(0);
        this.dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> fired.compareAndSet(0, event.getItemCount()));
        ComponentUtil.fireEvent((Component)this.component, (ComponentEvent)new ItemCountChangeEvent(this.component, 10, false));
        Assert.assertEquals((long)10L, (long)fired.get());
    }

    @Test
    public void refreshAll_listenersNotified() {
        AtomicReference refreshAllEvent = new AtomicReference();
        this.dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            Assert.assertNull(refreshAllEvent.get());
            refreshAllEvent.set(event);
        });
        this.dataView.refreshAll();
        Assert.assertNotNull(refreshAllEvent.get());
        Assert.assertEquals(this.dataProvider, (Object)((DataChangeEvent)refreshAllEvent.get()).getSource());
    }

    @Test
    public void verifyDataProviderType_wrappedDataProviderIsSupported() {
        this.wrapperDataProvider = new DataCommunicator.EmptyDataProvider();
        DataViewImpl dataView = new DataViewImpl((SerializableSupplier & Serializable)() -> this.wrapperDataProvider, this.component){

            @Override
            public Class<?> getSupportedDataProviderType() {
                return InMemoryDataProvider.class;
            }
        };
        this.wrapperDataProvider = this.getWrapperDataProvider();
        dataView.verifyDataProviderType(this.wrapperDataProvider);
    }

    @Test
    public void verifyDataProviderType_withConfigurableFilter_wrappedDataProviderIsSupported() {
        this.wrapperDataProvider = new DataCommunicator.EmptyDataProvider();
        DataViewImpl dataView = new DataViewImpl((SerializableSupplier & Serializable)() -> this.wrapperDataProvider, this.component){

            @Override
            public Class<?> getSupportedDataProviderType() {
                return InMemoryDataProvider.class;
            }
        };
        this.wrapperDataProvider = this.dataProvider.withConfigurableFilter();
        dataView.verifyDataProviderType(this.wrapperDataProvider);
    }

    @Test
    public void verifyDataProviderType_wrappedDataProviderIsNotSupported() {
        this.wrapperDataProvider = new DataCommunicator.EmptyDataProvider();
        DataViewImpl dataView = new DataViewImpl((SerializableSupplier & Serializable)() -> this.wrapperDataProvider, this.component){

            @Override
            public Class<?> getSupportedDataProviderType() {
                return BackEndDataProvider.class;
            }
        };
        this.wrapperDataProvider = this.getWrapperDataProvider();
        Assert.assertThrows(IllegalStateException.class, () -> dataView.verifyDataProviderType(this.wrapperDataProvider));
    }

    @Test
    public void verifyDataProviderType_withConfigurableFilter_wrappedDataProviderIsNotSupported() {
        this.wrapperDataProvider = new DataCommunicator.EmptyDataProvider();
        DataViewImpl dataView = new DataViewImpl((SerializableSupplier & Serializable)() -> this.wrapperDataProvider, this.component){

            @Override
            public Class<?> getSupportedDataProviderType() {
                return BackEndDataProvider.class;
            }
        };
        this.wrapperDataProvider = this.dataProvider.withConfigurableFilter();
        Assert.assertThrows(IllegalStateException.class, () -> dataView.verifyDataProviderType(this.wrapperDataProvider));
    }

    @Test
    public void verifyDataProviderType_wrapperIsBackEndDataProvider_wrapperDataProviderIsSupported() {
        this.wrapperDataProvider = new DataCommunicator.EmptyDataProvider();
        DataViewImpl dataView = new DataViewImpl((SerializableSupplier & Serializable)() -> this.wrapperDataProvider, this.component){

            @Override
            public Class<?> getSupportedDataProviderType() {
                return BackEndDataProvider.class;
            }
        };
        this.wrapperDataProvider = new BackEndDataProviderWrapper((DataProvider<Item, SerializablePredicate<Item>>)this.dataProvider);
        dataView.verifyDataProviderType(this.wrapperDataProvider);
    }

    private DataProvider<Item, Object> getWrapperDataProvider() {
        return new DataProviderWrapper<Item, Object, SerializablePredicate<Item>>(this.dataProvider){

            protected SerializablePredicate<Item> getFilter(Query query) {
                return null;
            }

            public Stream fetch(Query query) {
                return null;
            }
        };
    }

    @Tag(value="test-component")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }

    private static class DataViewImpl
    extends AbstractDataView<Item> {
        public DataViewImpl(SerializableSupplier<DataProvider<Item, ?>> dataProviderSupplier, Component component) {
            super(dataProviderSupplier, component);
        }

        protected Class<?> getSupportedDataProviderType() {
            return DataProvider.class;
        }

        public Item getItem(int index) {
            return null;
        }

        public Optional<Integer> getItemIndex(Item item) {
            return Optional.of(0);
        }
    }

    private static class BackEndDataProviderWrapper
    extends DataProviderWrapper<Item, Object, SerializablePredicate<Item>>
    implements BackEndDataProvider<Item, Object> {
        protected BackEndDataProviderWrapper(DataProvider<Item, SerializablePredicate<Item>> dataProvider) {
            super(dataProvider);
        }

        public Stream fetch(Query query) {
            return null;
        }

        public void setSortOrders(List<QuerySortOrder> sortOrders) {
        }

        public int size(Query<Item, Object> query) {
            return 0;
        }

        protected SerializablePredicate<Item> getFilter(Query<Item, Object> query) {
            return null;
        }

        public void refreshItem(Item item) {
        }

        public void refreshAll() {
        }

        public Registration addDataProviderListener(DataProviderListener<Item> listener) {
            return null;
        }
    }

    static class CustomIdentityItemDataProvider
    extends ListDataProvider<Item> {
        public CustomIdentityItemDataProvider(Collection<Item> items) {
            super(items);
        }

        public Object getId(Item item) {
            return item.getId();
        }
    }
}

