/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateTree;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractComponentDataGenerator<T>
implements DataGenerator<T> {
    private final Map<String, Component> renderedComponents = new HashMap<String, Component>();

    @Override
    public void refreshData(T item) {
        String itemKey = this.getItemKey(item);
        Component oldComponent = this.getRenderedComponent(itemKey);
        if (oldComponent != null) {
            int newId;
            Component recreatedComponent = this.updateComponent(oldComponent, item);
            int oldId = oldComponent.getElement().getNode().getId();
            if (oldId != (newId = recreatedComponent.getElement().getNode().getId()) && !oldComponent.equals(recreatedComponent)) {
                this.getContainer().removeChild(new Element[]{oldComponent.getElement()});
                this.registerRenderedComponent(itemKey, recreatedComponent);
            }
        }
    }

    @Override
    public void destroyData(T item) {
        String itemKey = this.getItemKey(item);
        Component renderedComponent = this.renderedComponents.remove(itemKey);
        if (renderedComponent != null) {
            renderedComponent.getElement().removeFromParent();
        }
    }

    @Override
    public void destroyAllData() {
        this.renderedComponents.values().forEach(component -> component.getElement().removeFromParent());
        this.renderedComponents.clear();
    }

    protected abstract Element getContainer();

    protected abstract Component createComponent(T var1);

    protected Component updateComponent(Component currentComponent, T item) {
        return this.createComponent(item);
    }

    protected abstract String getItemKey(T var1);

    protected void registerRenderedComponent(String itemKey, Component component) {
        Element element = component.getElement();
        this.getContainer().appendChild(new Element[]{element});
        NodeOwner owner = this.getContainer().getNode().getOwner();
        UI containerUi = null;
        if (owner instanceof StateTree) {
            containerUi = ((StateTree)owner).getUI();
        }
        Optional componentUi = component.getUI();
        if (containerUi != null && componentUi.isPresent() && containerUi != componentUi.get()) {
            throw new IllegalStateException("The component '" + String.valueOf(component.getClass()) + "' is already attached to a UI instance which differs from the conainer's UI instance. It means that the component instance is reused instead being produced every time on 'createComponent' call. Check whether the component instance is a singleton or has inappropriate Spring scope.");
        }
        this.renderedComponents.put(itemKey, component);
    }

    protected Component getRenderedComponent(String itemKey) {
        return this.renderedComponents.get(itemKey);
    }
}

