/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder.testcomponents;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Tag(value="test-select-field")
public class TestSelectComponent<T>
extends AbstractSinglePropertyField<TestSelectComponent<T>, Set<T>>
implements MultiSelect<TestSelectComponent<T>, T>,
HasValidation {
    private final KeyMapper<T> keyMapper = new KeyMapper((ValueProvider & Serializable)i -> i);
    private String errorMessage = "";
    private boolean invalid;

    public TestSelectComponent() {
        super("value", Collections.emptySet(), JsonArray.class, TestSelectComponent::presentationToModel, TestSelectComponent::modelToPresentation);
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        HashSet<T> value = new HashSet<T>((Collection)this.getValue());
        value.addAll(addedItems);
        value.removeAll(removedItems);
        this.setValue(value);
    }

    public Set<T> getSelectedItems() {
        return (Set)this.getValue();
    }

    public Registration addSelectionListener(MultiSelectionListener<TestSelectComponent<T>, T> listener) {
        return this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listener.selectionChange(new MultiSelectionEvent((Component)this, (HasValue)this, (Set)event.getOldValue(), event.isFromClient())));
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            errorMessage = "";
        }
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    private static <T> Set<T> presentationToModel(TestSelectComponent<T> group, JsonArray presentation) {
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < presentation.length(); ++i) {
            set.add(group.keyMapper.get(presentation.getString(i)));
        }
        return set;
    }

    private static <T> JsonArray modelToPresentation(TestSelectComponent<T> group, Set<T> model) {
        JsonArray array = Json.createArray();
        if (model.isEmpty()) {
            return array;
        }
        model.stream().map(arg_0 -> group.keyMapper.key(arg_0)).forEach(key -> array.set(array.length(), key));
        return array;
    }
}

