/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalArrayUpdater;
import com.vaadin.flow.data.provider.hierarchy.HierarchyMapper;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.Range;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Deprecated(since="24.9", forRemoval=true)
public class HierarchicalCommunicationController<T>
implements Serializable {
    private final DataKeyMapper<T> keyMapper;
    private final DataGenerator<T> dataGenerator;
    private final SerializableFunction<Integer, HierarchicalArrayUpdater.HierarchicalUpdate> startUpdate;
    private final HierarchyMapper<T, ?> mapper;
    private final SerializableBiFunction<String, Range, Stream<T>> fetchItems;
    private final String parentKey;
    private int assumedSize;
    private Range requestedRange = Range.between((int)0, (int)0);
    private int activeStart = 0;
    private List<String> activeKeyOrder = Collections.emptyList();
    private boolean resendEntireRange = true;
    private boolean assumeEmptyClient = true;
    private int nextUpdateId = 0;
    private final HashMap<Integer, Set<String>> passivatedByUpdate = new HashMap();
    private final HashSet<Integer> confirmedUpdates = new HashSet();
    private boolean hasUniqueKeyProviderSupplier;

    public HierarchicalCommunicationController(String parentKey, DataKeyMapper<T> keyMapper, HierarchyMapper<T, ?> mapper, DataGenerator<T> dataGenerator, SerializableFunction<Integer, HierarchicalArrayUpdater.HierarchicalUpdate> startUpdate, SerializableBiFunction<String, Range, Stream<T>> fetchItems) {
        this.parentKey = parentKey;
        this.keyMapper = keyMapper;
        this.mapper = mapper;
        this.dataGenerator = dataGenerator;
        this.startUpdate = startUpdate;
        this.fetchItems = fetchItems;
    }

    public void flush() {
        Range effectiveRequested;
        T parentItem;
        if (this.parentKey != null && (parentItem = this.keyMapper.get(this.parentKey)) != null && !this.mapper.isExpanded(parentItem)) {
            return;
        }
        HashSet<String> oldActive = new HashSet<String>(this.activeKeyOrder);
        this.assumedSize = this.mapper.countChildItems(this.keyMapper.get(this.parentKey));
        Range previousActive = Range.withLength((int)this.activeStart, (int)this.activeKeyOrder.size());
        this.resendEntireRange |= !previousActive.intersects(effectiveRequested = this.requestedRange.restrictTo(Range.withLength((int)0, (int)this.assumedSize))) && (!previousActive.isEmpty() || !effectiveRequested.isEmpty());
        List<String> newActiveKeyOrder = this.collectKeysToFlush(previousActive, effectiveRequested);
        this.activeKeyOrder = newActiveKeyOrder;
        this.activeStart = effectiveRequested.getStart();
        HierarchicalArrayUpdater.HierarchicalUpdate update = (HierarchicalArrayUpdater.HierarchicalUpdate)this.startUpdate.apply((Object)this.assumedSize);
        boolean updated = this.collectChangesToSend(previousActive, effectiveRequested, update);
        this.resendEntireRange = false;
        this.assumeEmptyClient = false;
        this.passivateInactiveKeys(oldActive, newActiveKeyOrder, update, updated);
        this.unregisterPassivatedKeys();
    }

    public void confirmUpdate(int updateId) {
        this.confirmedUpdates.add(updateId);
    }

    public void setRequestRange(int start, int length) {
        this.requestedRange = Range.withLength((int)start, (int)length);
    }

    public void setResendEntireRange(boolean resend) {
        this.resendEntireRange = resend;
    }

    private boolean collectChangesToSend(Range previousActive, Range effectiveRequested, HierarchicalArrayUpdater.HierarchicalUpdate update) {
        boolean updated = false;
        if (this.assumeEmptyClient || this.resendEntireRange) {
            if (!this.assumeEmptyClient) {
                this.clear(previousActive.getStart(), previousActive.length(), update);
            }
            this.set(effectiveRequested, update);
            updated = true;
        } else if (!previousActive.equals((Object)effectiveRequested)) {
            HierarchicalCommunicationController.withMissing(previousActive, effectiveRequested, range -> this.clear(range.getStart(), range.length(), update));
            HierarchicalCommunicationController.withMissing(effectiveRequested, previousActive, range -> this.set((Range)range, update));
            updated = true;
        }
        return updated;
    }

    private void set(Range effectiveRequested, HierarchicalArrayUpdater.HierarchicalUpdate update) {
        if (effectiveRequested.isEmpty() || this.activeKeyOrder.isEmpty() || effectiveRequested.getStart() >= this.assumedSize) {
            return;
        }
        if (this.parentKey == null) {
            update.set(effectiveRequested.getStart(), this.getJsonItems(effectiveRequested));
        } else {
            update.set(effectiveRequested.getStart(), this.getJsonItems(effectiveRequested), this.parentKey);
        }
    }

    private void clear(int start, int length, HierarchicalArrayUpdater.HierarchicalUpdate update) {
        if (length == 0) {
            return;
        }
        if (this.parentKey == null) {
            update.clear(start, length);
        } else {
            update.clear(start, length, this.parentKey);
        }
    }

    private List<String> collectKeysToFlush(Range previousActive, Range effectiveRequested) {
        List<String> newActiveKeyOrder;
        if (this.resendEntireRange) {
            newActiveKeyOrder = this.activate(effectiveRequested);
        } else {
            Range[] partitionWith = effectiveRequested.partitionWith(previousActive);
            newActiveKeyOrder = new ArrayList<String>();
            newActiveKeyOrder.addAll(this.activate(partitionWith[0]));
            Range overlap = partitionWith[1].offsetBy(-this.activeStart);
            newActiveKeyOrder.addAll(this.activeKeyOrder.subList(overlap.getStart(), overlap.getEnd()));
            newActiveKeyOrder.addAll(this.activate(partitionWith[2]));
        }
        return newActiveKeyOrder;
    }

    private List<String> activate(Range range) {
        if (range.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> activeKeys = new ArrayList<String>(range.length());
        try (Stream stream = (Stream)this.fetchItems.apply((Object)this.parentKey, (Object)range);){
            stream.forEach(bean -> {
                boolean mapperHasKey = this.keyMapper.has(bean);
                String key = this.keyMapper.key(bean);
                if (mapperHasKey) {
                    this.keyMapper.refresh(bean);
                    this.passivatedByUpdate.values().forEach(set -> set.remove(key));
                }
                activeKeys.add(key);
            });
        }
        return activeKeys;
    }

    private void passivateInactiveKeys(Set<String> oldActive, List<String> newActiveKeyOrder, HierarchicalArrayUpdater.HierarchicalUpdate update, boolean updated) {
        if (updated) {
            int updateId = this.nextUpdateId++;
            if (this.parentKey == null) {
                update.commit(updateId);
            } else {
                update.commit(updateId, this.parentKey, this.assumedSize);
            }
            newActiveKeyOrder.forEach(oldActive::remove);
            if (!oldActive.isEmpty()) {
                this.passivatedByUpdate.put(updateId, oldActive);
            }
        }
    }

    public void unregisterPassivatedKeys() {
        if (!this.confirmedUpdates.isEmpty()) {
            this.confirmedUpdates.forEach(this::doUnregister);
            this.confirmedUpdates.clear();
        }
    }

    private void doUnregister(Integer updateId) {
        Set<String> passivated = this.passivatedByUpdate.remove(updateId);
        if (passivated != null) {
            passivated.forEach(key -> {
                T item = this.keyMapper.get((String)key);
                if (item != null && (this.hasUniqueKeyProviderSupplier || !this.mapper.isExpanded(item))) {
                    this.dataGenerator.destroyData(item);
                    this.keyMapper.remove(item);
                }
            });
        }
    }

    private List<JsonValue> getJsonItems(Range range) {
        return range.stream().mapToObj(index -> this.activeKeyOrder.get(index - this.activeStart)).map(this.keyMapper::get).map(this::generateJson).collect(Collectors.toList());
    }

    public JsonValue generateJson(T item) {
        JsonObject json = Json.createObject();
        json.put("key", this.keyMapper.key(item));
        this.dataGenerator.generateData(item, json);
        return json;
    }

    public void setHasUniqueKeyProviderSupplier(boolean hasUniqueKeyProviderSupplier) {
        this.hasUniqueKeyProviderSupplier = hasUniqueKeyProviderSupplier;
    }

    private static final void withMissing(Range expected, Range actual, Consumer<Range> action) {
        Range[] partition = expected.partitionWith(actual);
        HierarchicalCommunicationController.applyIfNotEmpty(partition[0], action);
        HierarchicalCommunicationController.applyIfNotEmpty(partition[2], action);
    }

    private static final void applyIfNotEmpty(Range range, Consumer<Range> action) {
        if (!range.isEmpty()) {
            action.accept(range);
        }
    }
}

