/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalArrayUpdater;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalCommunicationController;
import com.vaadin.flow.data.provider.hierarchy.HierarchyMapper;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class HierarchicalCommunicationControllerTest {
    private static final String ROOT = "ROOT";
    private static final String PARENT_KEY = "parent-key";
    @Mock
    private DataKeyMapper<String> keyMapper;
    @Mock
    private HierarchyMapper<String, ?> mapper;
    @Mock
    private DataGenerator<String> dataGenerator;
    private boolean updateStarted;
    private boolean commitCalled;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.updateStarted = false;
        this.commitCalled = false;
    }

    @Test
    public void flush_parentCollapsedBeforeFlush_flushSkipped() {
        Mockito.when((Object)((String)this.keyMapper.get(PARENT_KEY))).thenReturn((Object)ROOT);
        Mockito.when((Object)this.mapper.isExpanded((Object)ROOT)).thenReturn((Object)false);
        HierarchicalCommunicationController<String> controller = this.createController(PARENT_KEY);
        controller.setRequestRange(0, 10);
        controller.flush();
        Assert.assertFalse((String)"Flush should be skipped when parent is collapsed, but update was started", (boolean)this.updateStarted);
        Assert.assertFalse((String)"Commit should not be called when parent is collapsed", (boolean)this.commitCalled);
    }

    @Test
    public void flush_parentStillExpanded_flushProceeds() {
        Mockito.when((Object)((String)this.keyMapper.get(PARENT_KEY))).thenReturn((Object)ROOT);
        Mockito.when((Object)this.mapper.isExpanded((Object)ROOT)).thenReturn((Object)true);
        HierarchicalCommunicationController<String> controller = this.createController(PARENT_KEY);
        controller.setRequestRange(0, 10);
        controller.flush();
        Assert.assertTrue((String)"Flush should proceed when parent is expanded, but update was not started", (boolean)this.updateStarted);
    }

    @Test
    public void flush_rootController_alwaysFlushes() {
        Mockito.when((Object)((String)this.keyMapper.get(null))).thenReturn(null);
        HierarchicalCommunicationController<String> controller = this.createController(null);
        controller.setRequestRange(0, 10);
        controller.flush();
        Assert.assertTrue((String)"Root controller should always flush, but update was not started", (boolean)this.updateStarted);
    }

    @Test
    public void flush_parentItemRemovedFromKeyMapper_flushProceeds() {
        Mockito.when((Object)((String)this.keyMapper.get(PARENT_KEY))).thenReturn(null);
        HierarchicalCommunicationController<String> controller = this.createController(PARENT_KEY);
        controller.setRequestRange(0, 10);
        controller.flush();
        Assert.assertTrue((String)"Flush should proceed when parent item is null in keyMapper, but update was not started", (boolean)this.updateStarted);
    }

    private HierarchicalCommunicationController<String> createController(String parentKey) {
        return new HierarchicalCommunicationController(parentKey, this.keyMapper, this.mapper, this.dataGenerator, (SerializableFunction & Serializable)size -> {
            this.updateStarted = true;
            return new TestUpdate();
        }, (SerializableBiFunction & Serializable)(pkey, range) -> Stream.empty());
    }

    private class TestUpdate
    implements HierarchicalArrayUpdater.HierarchicalUpdate {
        private TestUpdate() {
        }

        public void clear(int start, int length) {
        }

        public void set(int start, List<JsonValue> items) {
        }

        public void commit(int updateId) {
            HierarchicalCommunicationControllerTest.this.commitCalled = true;
        }

        public void enqueue(String name, Serializable ... arguments) {
        }

        public void set(int start, List<JsonValue> items, String parentKey) {
        }

        public void clear(int start, int length, String parentKey) {
        }

        public void commit(int updateId, String parentKey, int levelSize) {
            HierarchicalCommunicationControllerTest.this.commitCalled = true;
        }

        public void commit() {
            HierarchicalCommunicationControllerTest.this.commitCalled = true;
        }
    }
}

