/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.AbstractListDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractListDataViewListenerTest {
    @Test
    public void addItemCountChangeListener_itemsCountChanged_listenersAreNotified() {
        String[] items = new String[]{"item1", "item2", "item3", "item4"};
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView dataView = (AbstractListDataView)component.setItems(new ArrayList<String>(Arrays.asList(items)));
        AtomicInteger invocationCounter = new AtomicInteger(0);
        dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> invocationCounter.incrementAndGet());
        MockUI ui = new MockUI();
        ui.add(new Component[]{(Component)component});
        dataView.setFilter("one"::equals);
        dataView.setFilter(null);
        dataView.addItemAfter((Object)"item5", (Object)"item4");
        dataView.addItemBefore((Object)"item0", (Object)"item1");
        dataView.addItem((Object)"last");
        dataView.removeItem((Object)"item0");
        this.fakeClientCall(ui);
        Assert.assertEquals((String)"Unexpected number of item count change listener invocations occurred", (long)1L, (long)invocationCounter.get());
    }

    @Test
    public void addItemCountChangeListener_itemsCountNotChanged_listenersAreNotNotified() {
        Object[] items = new String[]{"item1", "item2", "item3", "item4"};
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView dataView = (AbstractListDataView)component.setItems(items);
        AtomicBoolean invocationChecker = new AtomicBoolean(false);
        MockUI ui = new MockUI();
        ui.add(new Component[]{(Component)component});
        this.fakeClientCall(ui);
        dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> invocationChecker.getAndSet(true));
        dataView.setSortComparator(String::compareTo);
        this.fakeClientCall(ui);
        Assert.assertFalse((String)"Unexpected item count listener invocation", (boolean)invocationChecker.get());
    }

    @Test
    public void addItemCountChangeListener_itemsCountChanged_newItemCountSuppliedInEvent() {
        Object[] items = new String[]{"item1", "item2", "item3", "item4"};
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView dataView = (AbstractListDataView)component.setItems(items);
        AtomicBoolean invocationChecker = new AtomicBoolean(false);
        MockUI ui = new MockUI();
        ui.add(new Component[]{(Component)component});
        this.fakeClientCall(ui);
        dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> {
            Assert.assertEquals((String)"Unexpected item count", (long)1L, (long)event.getItemCount());
            Assert.assertFalse((boolean)event.isItemCountEstimated());
            invocationChecker.set(true);
        });
        dataView.setFilter("item1"::equals);
        this.fakeClientCall(ui);
        Assert.assertTrue((String)"Item count change never called", (boolean)invocationChecker.get());
    }

    @Test
    public void setItems_setNewItemsToComponent_filteringAndSortingRemoved() {
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getVerifiedComponent();
        AbstractListDataView listDataView = (AbstractListDataView)component.setItems((Object[])new String[]{"item1", "item2", "item3"});
        SerializablePredicate & Serializable filter = "item2"::equals;
        listDataView.setFilter((SerializablePredicate)filter);
        Assert.assertEquals((String)"Unexpected filtered item count", (long)1L, (long)listDataView.getItemCount());
        listDataView = (AbstractListDataView)component.setItems((Object[])new String[]{"item1", "item2", "item3"});
        Assert.assertEquals((String)"Non-filtered item count expected", (long)3L, (long)listDataView.getItemCount());
    }

    protected abstract HasListDataView<String, ? extends AbstractListDataView<String>> getComponent();

    private void fakeClientCall(UI ui) {
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    private HasListDataView<String, ? extends AbstractListDataView<String>> getVerifiedComponent() {
        HasListDataView<String, ? extends AbstractListDataView<String>> component = this.getComponent();
        if (component instanceof Component) {
            return component;
        }
        throw new IllegalArgumentException(String.format("Component subclass is expected, but was given a '%s'", component.getClass().getSimpleName()));
    }

    private static class MockUI
    extends UI {
        public MockUI() {
            this(MockUI.findOrcreateSession());
        }

        public MockUI(VaadinSession session) {
            this.getInternals().setSession(session);
            MockUI.setCurrent((UI)this);
        }

        protected void init(VaadinRequest request) {
        }

        private static VaadinSession findOrcreateSession() {
            VaadinSession session = VaadinSession.getCurrent();
            if (session == null) {
                session = new AlwaysLockedVaadinSession(null);
                VaadinSession.setCurrent((VaadinSession)session);
            }
            return session;
        }
    }

    private static class MockVaadinSession
    extends VaadinSession {
        private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
        private ReentrantLock lock = new ReentrantLock();

        public MockVaadinSession(VaadinService service) {
            super(service);
        }

        public void close() {
            super.close();
        }

        public Lock getLockInstance() {
            return this.lock;
        }

        public void lock() {
            super.lock();
            referenceKeeper.set(this);
        }

        public void unlock() {
            super.unlock();
            referenceKeeper.remove();
        }
    }

    private static class AlwaysLockedVaadinSession
    extends MockVaadinSession {
        public AlwaysLockedVaadinSession(VaadinService service) {
            super(service);
            this.lock();
        }
    }
}

