/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderTestBase;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.testcomponents.TestHasValidatorDatePicker;
import com.vaadin.flow.tests.data.bean.Person;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BinderValidationStatusChangeListenerTest
extends BinderTestBase<Binder<Person>, Person> {
    private static final String BIRTH_DATE_PROPERTY = "birthDate";
    private final Map<HasValue<?, ?>, String> componentErrors = new HashMap();

    @Before
    public void setUp() {
        this.binder = new Binder<Person>(Person.class){

            protected void handleError(HasValue<?, ?> field, ValidationResult result) {
                BinderValidationStatusChangeListenerTest.this.componentErrors.put(field, result.getErrorMessage());
            }

            protected void clearError(HasValue<?, ?> field) {
                super.clearError(field);
                BinderValidationStatusChangeListenerTest.this.componentErrors.remove(field);
            }
        };
        this.item = new Person();
    }

    @Test
    public void fieldWithHasValidatorDefaults_bindIsCalled_addValidationStatusListenerIsCalled() {
        TestHasValidatorDatePicker.DatePickerHasValidatorDefaults field = (TestHasValidatorDatePicker.DatePickerHasValidatorDefaults)((Object)Mockito.spy(TestHasValidatorDatePicker.DatePickerHasValidatorDefaults.class));
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        ((TestHasValidatorDatePicker.DatePickerHasValidatorDefaults)((Object)Mockito.verify((Object)((Object)field), (VerificationMode)Mockito.times((int)1)))).addValidationStatusChangeListener((ValidationStatusChangeListener)Mockito.any());
    }

    @Test
    public void binderWithFieldsValidationStatusChangeListenerDisabled_bindIsCalled_noValidationStatusListenerIsCalled() {
        this.binder.setFieldsValidationStatusChangeListenerEnabled(false);
        TestHasValidatorDatePicker.DatePickerHasValidatorDefaults field = (TestHasValidatorDatePicker.DatePickerHasValidatorDefaults)((Object)Mockito.spy(TestHasValidatorDatePicker.DatePickerHasValidatorDefaults.class));
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        ((TestHasValidatorDatePicker.DatePickerHasValidatorDefaults)((Object)Mockito.verify((Object)((Object)field), (VerificationMode)Mockito.never()))).addValidationStatusChangeListener((ValidationStatusChangeListener)Mockito.any());
    }

    @Test
    public void fieldWithHasValidatorOnlyGetDefaultValidatorOverridden_bindIsCalled_addValidationStatusListenerIsCalled() {
        TestHasValidatorDatePicker.DataPickerHasValidatorGetDefaultValidatorOverridden field = (TestHasValidatorDatePicker.DataPickerHasValidatorGetDefaultValidatorOverridden)((Object)Mockito.spy(TestHasValidatorDatePicker.DataPickerHasValidatorGetDefaultValidatorOverridden.class));
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        ((TestHasValidatorDatePicker.DataPickerHasValidatorGetDefaultValidatorOverridden)((Object)Mockito.verify((Object)((Object)field), (VerificationMode)Mockito.times((int)1)))).addValidationStatusChangeListener((ValidationStatusChangeListener)Mockito.any());
    }

    @Test
    public void fieldWithHasValidatorOnlyAddListenerOverridden_bindIsCalled_addValidationStatusListenerIsCalled() {
        TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden field = (TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden)((Object)Mockito.spy(TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden.class));
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        ((TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden)((Object)Mockito.verify((Object)((Object)field), (VerificationMode)Mockito.times((int)1)))).addValidationStatusChangeListener((ValidationStatusChangeListener<LocalDate>)((ValidationStatusChangeListener)Mockito.any()));
    }

    @Test
    public void fieldWithHasValidatorFullyOverridden_bindIsCalled_addValidationStatusChangeListenerIsCalled() {
        TestHasValidatorDatePicker.DataPickerHasValidatorOverridden field = (TestHasValidatorDatePicker.DataPickerHasValidatorOverridden)((Object)Mockito.spy(TestHasValidatorDatePicker.DataPickerHasValidatorOverridden.class));
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        ((TestHasValidatorDatePicker.DataPickerHasValidatorOverridden)((Object)Mockito.verify((Object)((Object)field), (VerificationMode)Mockito.times((int)1)))).addValidationStatusChangeListener((ValidationStatusChangeListener<LocalDate>)((ValidationStatusChangeListener)Mockito.any()));
    }

    @Test
    public void fieldWithHasValidatorFullyOverridden_fieldValidationStatusChangesToFalse_binderHandleErrorIsCalled() {
        TestHasValidatorDatePicker.DataPickerHasValidatorOverridden field = new TestHasValidatorDatePicker.DataPickerHasValidatorOverridden();
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        Assert.assertEquals((long)0L, (long)this.componentErrors.size());
        field.fireValidationStatusChangeEvent(false);
        Assert.assertEquals((long)1L, (long)this.componentErrors.size());
        Assert.assertEquals((Object)"Invalid date format", (Object)this.componentErrors.get((Object)field));
    }

    @Test
    public void binderWithFieldsValidationStatusChangeListenerDisabled_fieldValidationStatusChangesToFalse_binderHandleErrorIsNotCalled() {
        this.binder.setFieldsValidationStatusChangeListenerEnabled(false);
        TestHasValidatorDatePicker.DataPickerHasValidatorOverridden field = new TestHasValidatorDatePicker.DataPickerHasValidatorOverridden();
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        Assert.assertEquals((long)0L, (long)this.componentErrors.size());
        field.fireValidationStatusChangeEvent(false);
        Assert.assertEquals((long)0L, (long)this.componentErrors.size());
    }

    @Test
    public void fieldWithHasValidatorFullyOverridden_fieldValidationStatusChangesToTrue_binderClearErrorIsCalled() {
        TestHasValidatorDatePicker.DataPickerHasValidatorOverridden field = new TestHasValidatorDatePicker.DataPickerHasValidatorOverridden();
        this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        Assert.assertEquals((long)0L, (long)this.componentErrors.size());
        field.fireValidationStatusChangeEvent(false);
        Assert.assertEquals((long)1L, (long)this.componentErrors.size());
        Assert.assertEquals((Object)"Invalid date format", (Object)this.componentErrors.get((Object)field));
        field.fireValidationStatusChangeEvent(true);
        Assert.assertEquals((long)0L, (long)this.componentErrors.size());
        Assert.assertNull((Object)this.componentErrors.get((Object)field));
    }

    @Test
    public void fieldWithHasValidatorOnlyAddListenerOverriddenAndCustomValidation_fieldValidationStatusChangesToFalse_binderHandleErrorIsCalled() {
        TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden field = new TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden();
        this.binder.forField((HasValue)field).withValidator(field::customValidation).bind(BIRTH_DATE_PROPERTY);
        field.fireValidationStatusChangeEvent(false);
        Assert.assertEquals((long)1L, (long)this.componentErrors.size());
        Assert.assertEquals((Object)"Invalid date format", (Object)this.componentErrors.get((Object)field));
    }

    @Test
    public void fieldWithHasValidatorOnlyAddListenerOverriddenAndCustomValidation_fieldValidationStatusChangesToTrue_binderClearErrorIsCalled() {
        TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden field = new TestHasValidatorDatePicker.DataPickerHasValidatorAddListenerOverridden();
        this.binder.forField((HasValue)field).withValidator(field::customValidation).bind(BIRTH_DATE_PROPERTY);
        field.fireValidationStatusChangeEvent(false);
        Assert.assertEquals((long)1L, (long)this.componentErrors.size());
        Assert.assertEquals((Object)"Invalid date format", (Object)this.componentErrors.get((Object)field));
        field.fireValidationStatusChangeEvent(true);
        Assert.assertEquals((long)0L, (long)this.componentErrors.size());
        Assert.assertNull((Object)this.componentErrors.get((Object)field));
    }

    @Test
    public void fieldWithHasValidatorFullyOverridden_boundFieldGetsUnbind_validationStatusChangeListenerInBindingIsRemoved() {
        TestHasValidatorDatePicker.DataPickerHasValidatorOverridden field = new TestHasValidatorDatePicker.DataPickerHasValidatorOverridden();
        Binder.Binding binding = this.binder.bind((HasValue)field, BIRTH_DATE_PROPERTY);
        Assert.assertEquals((long)0L, (long)this.componentErrors.size());
        field.fireValidationStatusChangeEvent(false);
        Assert.assertEquals((long)1L, (long)this.componentErrors.size());
        Assert.assertEquals((Object)"Invalid date format", (Object)this.componentErrors.get((Object)field));
        binding.unbind();
        field.fireValidationStatusChangeEvent(true);
        Assert.assertEquals((long)1L, (long)this.componentErrors.size());
        Assert.assertEquals((Object)"Invalid date format", (Object)this.componentErrors.get((Object)field));
    }
}

