/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.hierarchy.AbstractBackEndHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.HierarchyMapper;
import com.vaadin.flow.data.provider.hierarchy.Node;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.Range;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HierarchyMapperWithDataTest {
    private static final int ROOT_COUNT = 5;
    private static final int PARENT_COUNT = 4;
    private static final int LEAF_COUNT = 2;
    private TreeData<Node> data;
    private TreeDataProvider<Node> provider;
    private HierarchyMapper<Node, SerializablePredicate<Node>> mapper;
    private List<Node> testData;
    private List<Node> roots;
    private int mapSize;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    private void setupData() {
        this.mapSize = 5;
        this.data = new TreeData();
        this.testData = HierarchyMapperWithDataTest.generateTestData(5, 4, 2);
        this.roots = this.testData.stream().filter(item -> item.getParent() == null).collect(Collectors.toList());
        this.data.addItems(this.roots, (ValueProvider & Serializable)parent -> this.testData.stream().filter(item -> Objects.equals(item.getParent(), parent)).collect(Collectors.toList()));
    }

    @Before
    public void setup() {
        this.setupData();
        this.provider = new TreeDataProvider(this.data);
        this.mapper = new HierarchyMapper(this.provider);
    }

    @Test
    public void expandRootNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(this.testData.get(0));
        Assert.assertEquals((String)"Should be root count + once parent count", (long)9L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void expandAndCollapseLastRootNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(this.roots.get(this.roots.size() - 1));
        Assert.assertEquals((String)"Should be root count + once parent count", (long)9L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.collapse(this.roots.get(this.roots.size() - 1));
        Assert.assertEquals((String)"Map size should be equal to root node count again", (long)5L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void expandHiddenNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(this.testData.get(1));
        Assert.assertEquals((String)"Map size should not change when expanding a hidden node", (long)5L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.expand(this.roots.get(0));
        Assert.assertEquals((String)"Hidden node should now be expanded as well", (long)11L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.collapse(this.roots.get(0));
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void expandLeafNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(this.testData.get(0));
        this.expand(this.testData.get(1));
        Assert.assertEquals((String)"Root and parent node expanded", (long)11L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.expand(this.testData.get(2));
        Assert.assertEquals((String)"Expanding a leaf node should have no effect", (long)11L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void findParentIndexOfLeaf() {
        this.expand(this.testData.get(0));
        Assert.assertEquals((String)"Could not find the root node of a parent", (Object)0, (Object)this.mapper.getParentIndex((Object)this.testData.get(1)));
        this.expand(this.testData.get(1));
        Assert.assertEquals((String)"Could not find the parent of a leaf", (Object)1, (Object)this.mapper.getParentIndex((Object)this.testData.get(2)));
    }

    @Test
    public void fetchRangeOfRows() {
        this.expand(this.testData.get(0));
        this.expand(this.testData.get(1));
        List<Node> expectedResult = this.testData.stream().filter(n -> this.roots.contains(n) || n.getParent().equals(this.testData.get(0)) || n.getParent().equals(this.testData.get(1))).collect(Collectors.toList());
        Range range = Range.between((int)3, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)2);
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
    }

    @Test
    public void fetchRangeOfRowsWithSorting() {
        this.expand(this.testData.get(0));
        this.expand(this.testData.get(1));
        ArrayList levels = new ArrayList();
        Comparator<Node> comparator = Comparator.comparing(Node::getNumber).reversed();
        levels.add(this.testData.stream().filter(n -> n.getParent() == null).sorted(comparator).collect(Collectors.toList()));
        levels.add(this.testData.stream().filter(n -> n.getParent() == this.testData.get(0)).sorted(comparator).collect(Collectors.toList()));
        levels.add(this.testData.stream().filter(n -> n.getParent() == this.testData.get(1)).sorted(comparator).collect(Collectors.toList()));
        List<Node> expectedResult = ((List)levels.get(0)).stream().flatMap(root -> {
            Stream nextLevel = ((List)levels.get(1)).stream().filter(n -> n.getParent() == root).flatMap(node -> Stream.concat(Stream.of(node), ((List)levels.get(2)).stream().filter(n -> n.getParent() == node)));
            return Stream.concat(Stream.of(root), nextLevel);
        }).collect(Collectors.toList());
        this.mapper.setInMemorySorting(comparator::compare);
        Range range = Range.between((int)8, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)5);
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
    }

    @Test
    public void fetchWithFilter() {
        this.expand(this.testData.get(0));
        Node expandedNode = this.testData.get(4);
        this.expand(expandedNode);
        SerializablePredicate & Serializable filter = (SerializablePredicate & Serializable)n -> n.getNumber() % 2 == 0;
        List<Node> expectedResult = IntStream.of(0, 1, 4, 6, 7, 10, 13, 26, 39, 52).mapToObj(this.testData::get).collect(Collectors.toList());
        this.mapper.setFilter((Object)filter);
        Range range = Range.between((int)0, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
    }

    @Test
    public void getExpandedItems_expandSomeItems_returnsCorrectExpandedItems() {
        TreeNode root = new TreeNode("root", null);
        TreeNode second1 = new TreeNode("second-1", root);
        TreeNode second2 = new TreeNode("second-2", root);
        TreeNode third11 = new TreeNode("third-1-1", second1);
        TreeNode third21 = new TreeNode("third-2-1", second2);
        ThreeLevelStaticHierarchicalDataProvider dataProvider = new ThreeLevelStaticHierarchicalDataProvider(root, new TreeNode[]{second1, second2}, new TreeNode[]{third11, third21});
        HierarchyMapper hierarchyMapper = new HierarchyMapper((HierarchicalDataProvider)dataProvider);
        Collection expandedItems = hierarchyMapper.getExpandedItems();
        Assert.assertNotNull((Object)expandedItems);
        Assert.assertEquals((long)0L, (long)expandedItems.size());
        hierarchyMapper.expand((Object)root);
        hierarchyMapper.expand((Object)second2);
        expandedItems = hierarchyMapper.getExpandedItems();
        Assert.assertNotNull((Object)expandedItems);
        Assert.assertEquals((long)2L, (long)expandedItems.size());
        Assert.assertArrayEquals((Object[])new Object[]{"root", "second-2"}, (Object[])expandedItems.stream().map(TreeNode::getName).sorted().toArray());
    }

    @Test
    public void getExpandedItems_tryToAddItemsToCollection_shouldThrowException() {
        this.exceptionRule.expect(UnsupportedOperationException.class);
        TreeNode root = new TreeNode("root", null);
        TreeNode second1 = new TreeNode("second-1", root);
        TreeNode second2 = new TreeNode("second-2", root);
        TreeNode third11 = new TreeNode("third-1-1", second1);
        TreeNode third21 = new TreeNode("third-2-1", second2);
        ThreeLevelStaticHierarchicalDataProvider dataProvider = new ThreeLevelStaticHierarchicalDataProvider(root, new TreeNode[]{second1, second2}, new TreeNode[]{third11, third21});
        HierarchyMapper hierarchyMapper = new HierarchyMapper((HierarchicalDataProvider)dataProvider);
        hierarchyMapper.expand((Object)root);
        hierarchyMapper.expand((Object)second1);
        Collection expandedItems = hierarchyMapper.getExpandedItems();
        expandedItems.add(new TreeNode("third-1"));
    }

    @Test
    public void fetchHierarchyItems_streamIsClosed() {
        final AtomicBoolean streamIsClosed = new AtomicBoolean();
        this.mapper = new HierarchyMapper((HierarchicalDataProvider)new TreeDataProvider<Node>(this.data){

            public Stream<Node> fetchChildren(HierarchicalQuery<Node, SerializablePredicate<Node>> query) {
                return (Stream)super.fetchChildren(query).onClose(() -> streamIsClosed.set(true));
            }
        });
        Node rootNode = this.testData.get(0);
        this.mapper.expand((Object)rootNode);
        this.mapper.fetchHierarchyItems((Object)rootNode, Range.between((int)0, (int)10)).count();
        Assert.assertTrue((boolean)streamIsClosed.get());
    }

    @Test
    public void fetchChildItems_streamIsClosed() {
        final AtomicBoolean streamIsClosed = new AtomicBoolean();
        this.mapper = new HierarchyMapper((HierarchicalDataProvider)new TreeDataProvider<Node>(this.data){

            public Stream<Node> fetchChildren(HierarchicalQuery<Node, SerializablePredicate<Node>> query) {
                return (Stream)super.fetchChildren(query).onClose(() -> streamIsClosed.set(true));
            }
        });
        Node rootNode = this.testData.get(0);
        this.mapper.expand((Object)rootNode);
        this.mapper.fetchChildItems((Object)rootNode, Range.between((int)0, (int)10));
        Assert.assertTrue((boolean)streamIsClosed.get());
    }

    private void expand(Node node) {
        this.insertRows(this.mapper.expand((Object)node, (Integer)this.mapper.getIndexOf((Object)node).orElse(null)));
    }

    private void collapse(Node node) {
        this.removeRows(this.mapper.collapse((Object)node, (Integer)this.mapper.getIndexOf((Object)node).orElse(null)));
    }

    private void verifyFetchIsCorrect(List<Node> expectedResult, Range range) {
        List collect = this.mapper.fetchHierarchyItems(range).collect(Collectors.toList());
        for (int i = 0; i < range.length(); ++i) {
            Assert.assertEquals((String)"Unexpected fetch results.", (Object)expectedResult.get(i + range.getStart()), collect.get(i));
        }
    }

    static List<Node> generateTestData(int rootCount, int parentCount, int leafCount) {
        int counter = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < rootCount; ++i) {
            Node root = new Node(counter++);
            nodes.add(root);
            for (int j = 0; j < parentCount; ++j) {
                Node parent = new Node(counter++, root);
                nodes.add(parent);
                for (int k = 0; k < leafCount; ++k) {
                    nodes.add(new Node(counter++, parent));
                }
            }
        }
        return nodes;
    }

    private void checkMapSize() {
        Assert.assertEquals((String)"Map size not properly updated", (long)this.mapper.getTreeSize(), (long)this.mapSize);
    }

    public void removeRows(Range range) {
        Assert.assertTrue((String)"Index not in range", (0 <= range.getStart() && range.getStart() < this.mapSize ? 1 : 0) != 0);
        Assert.assertTrue((String)"Removing more items than in map", (range.getEnd() <= this.mapSize ? 1 : 0) != 0);
        this.mapSize -= range.length();
    }

    public void insertRows(Range range) {
        Assert.assertTrue((String)"Index not in range", (0 <= range.getStart() && range.getStart() <= this.mapSize ? 1 : 0) != 0);
        this.mapSize += range.length();
    }

    private static class TreeNode {
        private String name;
        private TreeNode parent;

        public TreeNode(String name) {
            this.name = name;
        }

        public TreeNode(String name, TreeNode parent) {
            this.name = name;
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }
    }

    private static class ThreeLevelStaticHierarchicalDataProvider
    extends AbstractBackEndHierarchicalDataProvider<TreeNode, Void> {
        private TreeNode root;
        private TreeNode[] secondLevelNodes;
        private TreeNode[] thirdLevelNodes;

        public ThreeLevelStaticHierarchicalDataProvider(TreeNode root, TreeNode[] secondLevelNodes, TreeNode[] thirdLevelNodes) {
            this.root = root;
            this.secondLevelNodes = secondLevelNodes;
            this.thirdLevelNodes = thirdLevelNodes;
        }

        public int getChildCount(HierarchicalQuery<TreeNode, Void> query) {
            if (query.getParent() == null) {
                return this.secondLevelNodes.length;
            }
            if (Arrays.stream(this.secondLevelNodes).anyMatch(node -> node == query.getParent())) {
                return 0;
            }
            return (int)Arrays.stream(this.thirdLevelNodes).filter(node -> node.getParent() == query.getParent()).count();
        }

        public boolean hasChildren(TreeNode item) {
            return item.getParent() == null || Arrays.stream(this.secondLevelNodes).anyMatch(node -> node == item);
        }

        protected Stream<TreeNode> fetchChildrenFromBackEnd(HierarchicalQuery<TreeNode, Void> query) {
            if (query.getParent() == null) {
                return Arrays.stream(new TreeNode[]{this.root});
            }
            if (query.getParent() == this.root) {
                return Arrays.stream(this.secondLevelNodes);
            }
            return Arrays.stream(this.thirdLevelNodes).filter(node -> node.getParent() == query.getParent());
        }
    }
}

