/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.converter.LongToBigDecimalConverter;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class LongToBigDecimalConverterTest {
    LongToBigDecimalConverter converter = new LongToBigDecimalConverter();

    @Test
    public void testNullConversionToModel() {
        Assert.assertEquals((Object)Result.ok(null), (Object)this.converter.convertToModel(null, null));
    }

    @Test
    public void testNullConversionToPresentation() {
        Assert.assertNull((Object)this.converter.convertToPresentation(null, null));
    }

    @Test
    public void testConvertToModel() {
        Result result = this.converter.convertToModel(Long.valueOf(42L), null);
        Assert.assertEquals((Object)Result.ok((Object)BigDecimal.valueOf(42L)), (Object)result);
    }

    @Test
    public void testConvertToPresentation() {
        Long value = this.converter.convertToPresentation(BigDecimal.valueOf(42L), null);
        Assert.assertEquals((Object)42L, (Object)value);
    }

    @Test
    public void testConvertToModelWithLargeValue() {
        Result result = this.converter.convertToModel(Long.valueOf(0x80000000L), null);
        Assert.assertEquals((Object)Result.ok((Object)BigDecimal.valueOf(0x80000000L)), (Object)result);
    }

    @Test
    public void testConvertToPresentationWithLargeValue() {
        Long value = this.converter.convertToPresentation(BigDecimal.valueOf(0x80000000L), null);
        Assert.assertEquals((Object)0x80000000L, (Object)value);
    }
}

