/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.SimpleResult;
import org.junit.Assert;
import org.junit.Test;

public class SimpleResultTest {
    @Test
    public void twoEqualSimpleResults_objectsAreEqual() {
        SimpleResult one = new SimpleResult((Object)"foo", null);
        SimpleResult two = new SimpleResult((Object)"foo", null);
        Assert.assertEquals((Object)one, (Object)two);
    }

    @Test
    public void differentValues_objectsAreUnequal() {
        SimpleResult one = new SimpleResult((Object)"foo", null);
        SimpleResult two = new SimpleResult((Object)"baz", null);
        Assert.assertNotEquals((Object)one, (Object)two);
    }

    @Test
    public void differentMessages_objectsAreUnequal() {
        SimpleResult one = new SimpleResult(null, "bar");
        SimpleResult two = new SimpleResult(null, "baz");
        Assert.assertNotEquals((Object)one, (Object)two);
    }

    @Test
    public void differentClasses_objectsAreUnequal() {
        SimpleResult one = new SimpleResult((Object)"foo", null);
        SimpleResult<String> two = new SimpleResult<String>("foo", null){};
        Assert.assertNotEquals((Object)one, (Object)two);
    }

    @Test
    public void nullIsNotEqualToObject() {
        SimpleResult one = new SimpleResult((Object)"foo", null);
        Assert.assertNotEquals((Object)one, null);
    }

    @Test
    public void twoEqualSimpleResults_hashCodeIsTheSame() {
        SimpleResult one = new SimpleResult((Object)"foo", null);
        SimpleResult two = new SimpleResult((Object)"foo", null);
        Assert.assertEquals((long)one.hashCode(), (long)two.hashCode());
    }
}

