/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.BeanValidationBinder;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderTestBase;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.testcomponents.TestSelectComponent;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.tests.data.bean.BeanToValidate;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeanBinderTest
extends BinderTestBase<Binder<BeanToValidate>, BeanToValidate> {
    private UI ui;

    @Before
    public void setUp() {
        this.ui = new UI();
        this.ui.setLocale(Locale.ENGLISH);
        UI.setCurrent((UI)this.ui);
        this.binder = new BeanValidationBinder(BeanToValidate.class);
        this.item = new BeanToValidate();
        ((BeanToValidate)this.item).setFirstname("Johannes");
        ((BeanToValidate)this.item).setAge(32);
    }

    @After
    public void tearDown() {
        UI.setCurrent(null);
    }

    @Test
    public void bindInstanceFields_parameters_type_erased() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter("")).bind("number");
        otherBinder.bindInstanceFields((Object)testClass);
        BeanBinderTest.testSerialization(otherBinder);
    }

    @Test
    public void bindInstanceFields_automatically_binds_incomplete_forMemberField_bindings() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forMemberField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter(""));
        otherBinder.bindInstanceFields((Object)testClass);
        TestBean bean = new TestBean();
        otherBinder.setBean((Object)bean);
        testClass.number.setValue("50");
        Assert.assertEquals((long)50L, (long)bean.number);
        BeanBinderTest.testSerialization(otherBinder);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_does_not_automatically_bind_incomplete_forField_bindings() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter(""));
        otherBinder.bindInstanceFields((Object)testClass);
        otherBinder.setBean((Object)new TestBean());
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_throw_if_no_fields_bound() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClassWithoutFields testClass = new TestClassWithoutFields();
        otherBinder.bindInstanceFields((Object)testClass);
    }

    @Test
    public void bindInstanceFields_does_not_throw_if_fields_are_bound_manually() {
        PersonForm form = new PersonForm();
        Binder binder = new Binder(Person.class);
        binder.forMemberField((HasValue)form.mydate).withConverter((SerializableFunction & Serializable)str -> LocalDate.now(), (SerializableFunction & Serializable)date -> "Hello").bind("mydate");
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_does_not_throw_if_there_are_incomplete_bindings() {
        PersonForm form = new PersonForm();
        Binder binder = new Binder(Person.class);
        binder.forMemberField((HasValue)form.mydate).withConverter((SerializableFunction & Serializable)str -> LocalDate.now(), (SerializableFunction & Serializable)date -> "Hello");
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void incomplete_forMemberField_bindings() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forMemberField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter(""));
        otherBinder.setBean((Object)new TestBean());
    }

    @Test
    public void fieldBound_bindBean_fieldValueUpdated() {
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test
    public void beanBound_bindField_fieldValueUpdated() {
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.binder.bind((HasValue)this.nameField, "firstname");
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void bindInvalidPropertyName_throws() {
        this.binder.bind((HasValue)this.nameField, "firstnaem");
    }

    @Test(expected=NullPointerException.class)
    public void bindNullPropertyName_throws() {
        this.binder.bind((HasValue)this.nameField, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void bindNonReadableProperty_throws() {
        this.binder.bind((HasValue)this.nameField, "writeOnlyProperty");
    }

    @Test
    public void beanBound_setValidFieldValue_propertyValueChanged() {
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.nameField.setValue("Henri");
        Assert.assertEquals((Object)"Henri", (Object)((BeanToValidate)this.item).getFirstname());
    }

    @Test
    public void readOnlyPropertyBound_setFieldValue_ignored() {
        this.binder.bind((HasValue)this.nameField, "readOnlyProperty");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        String propertyValue = ((BeanToValidate)this.item).getReadOnlyProperty();
        this.nameField.setValue("Foo");
        Assert.assertEquals((Object)propertyValue, (Object)((BeanToValidate)this.item).getReadOnlyProperty());
    }

    @Test
    public void bindReadOnlyPropertyShouldMarkFieldAsReadonly() {
        this.binder.bind((HasValue)this.nameField, "readOnlyProperty");
        Assert.assertTrue((String)"Name field should be readonly", (boolean)this.nameField.isReadOnly());
    }

    @Test
    public void setReadonlyShouldIgnoreBindingsForReadOnlyProperties() {
        this.binder.bind((HasValue)this.nameField, "readOnlyProperty");
        this.binder.setReadOnly(true);
        Assert.assertTrue((String)"Name field should be ignored and be readonly", (boolean)this.nameField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertTrue((String)"Name field should be ignored and be readonly", (boolean)this.nameField.isReadOnly());
        this.nameField.setReadOnly(false);
        this.binder.setReadOnly(true);
        Assert.assertFalse((String)"Name field should be ignored and not be readonly", (boolean)this.nameField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((String)"Name field should be ignored and not be readonly", (boolean)this.nameField.isReadOnly());
    }

    @Test
    public void beanBound_setInvalidFieldValue_validationError() {
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.nameField.setValue("H");
        Assert.assertEquals((Object)"Johannes", (Object)((BeanToValidate)this.item).getFirstname());
        this.assertInvalid(this.nameField, "size must be between 3 and 16");
    }

    @Test
    public void beanNotBound_setInvalidFieldValue_validationError() {
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.nameField.setValue("H");
        this.assertInvalid(this.nameField, "size must be between 3 and 16");
    }

    @Test
    public void explicitValidatorAdded_setInvalidFieldValue_explicitValidatorRunFirst() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> name.startsWith("J"), "name must start with J").bind("firstname");
        this.nameField.setValue("A");
        this.assertInvalid(this.nameField, "name must start with J");
    }

    @Test
    public void explicitValidatorAdded_setInvalidFieldValue_beanValidatorRun() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> name.startsWith("J"), "name must start with J").bind("firstname");
        this.nameField.setValue("J");
        this.assertInvalid(this.nameField, "size must be between 3 and 16");
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithIncompatibleTypeBound_bindBean_throws() {
        this.binder.bind((HasValue)this.ageField, "age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithIncompatibleTypeBound_loadBean_throws() {
        this.binder.bind((HasValue)this.ageField, "age");
        this.binder.readBean((Object)((BeanToValidate)this.item));
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithIncompatibleTypeBound_saveBean_throws() throws Throwable {
        try {
            this.binder.bind((HasValue)this.ageField, "age");
            this.binder.writeBean((Object)((BeanToValidate)this.item));
        }
        catch (RuntimeException e) {
            throw e.getCause();
        }
    }

    @Test
    public void fieldWithConverterBound_bindBean_fieldValueUpdated() {
        this.binder.forField((HasValue)this.ageField).withConverter(Integer::valueOf, String::valueOf).bind("age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        Assert.assertEquals((Object)"32", (Object)this.ageField.getValue());
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithInvalidConverterBound_bindBean_fieldValueUpdated() {
        this.binder.forField((HasValue)this.ageField).withConverter(Float::valueOf, String::valueOf).bind("age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        Assert.assertEquals((Object)"32", (Object)this.ageField.getValue());
    }

    @Test
    public void beanBinderWithBoxedType() {
        this.binder.forField((HasValue)this.ageField).withConverter(Integer::valueOf, String::valueOf).bind("age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.ageField.setValue(String.valueOf(20));
        Assert.assertEquals((long)20L, (long)((BeanToValidate)this.item).getAge());
    }

    @Test
    public void firstName_isNotNullConstraint_nullableFieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        TestTextField field = new TestTextField(){

            public String getEmptyValue() {
                return null;
            }
        };
        binder.bind((HasValue)field, "firstname");
        binder.setBean((Object)bean);
        Assert.assertTrue((String)"@NotNull field with default value null should be required", (boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void firstName_isNotNullConstraint_textFieldIsNotRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        TestTextField field = new TestTextField();
        binder.bind((HasValue)field, "firstname");
        binder.setBean((Object)bean);
        Assert.assertFalse((String)"@NotNull field with default value \"\" should not be required", (boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void age_minSizeConstraint_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        TestTextField field = new TestTextField();
        binder.bind((HasValue)field, "age");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void lastName_minSizeConstraint_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        TestTextField field = new TestTextField();
        binder.bind((HasValue)field, "lastname");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void subfield_name_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        bean.setSubfield(new RequiredConstraints.SubConstraint());
        TestTextField field = new TestTextField();
        binder.bind((HasValue)field, "subfield.name");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void subsubfield_name_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        RequiredConstraints.SubConstraint subfield = new RequiredConstraints.SubConstraint();
        subfield.setSubsub(new RequiredConstraints.SubSubConstraint());
        bean.setSubfield(subfield);
        TestTextField field = new TestTextField();
        binder.bind((HasValue)field, "subfield.subsub.value");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void subfield_name_valueCanBeValidated() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        TestTextField field = new TestTextField();
        binder.bind((HasValue)field, "subfield.name");
        RequiredConstraints bean = new RequiredConstraints();
        bean.setSubfield(new RequiredConstraints.SubConstraint());
        binder.setBean((Object)bean);
        Assert.assertFalse((boolean)binder.validate().isOk());
        field.setValue("overfive");
        Assert.assertTrue((boolean)binder.validate().isOk());
    }

    @Test
    public void subSubfield_name_valueCanBeValidated() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        TestTextField field = new TestTextField();
        binder.bind((HasValue)field, "subfield.subsub.value");
        RequiredConstraints bean = new RequiredConstraints();
        RequiredConstraints.SubConstraint subfield = new RequiredConstraints.SubConstraint();
        bean.setSubfield(subfield);
        subfield.setSubsub(new RequiredConstraints.SubSubConstraint());
        binder.setBean((Object)bean);
        Assert.assertFalse((boolean)binder.validate().isOk());
        field.setValue("overtencharacters");
        Assert.assertTrue((boolean)binder.validate().isOk());
    }

    private void assertInvalid(TestTextField field, String message) {
        BinderValidationStatus status = this.binder.validate();
        List errors = status.getFieldValidationErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertSame((Object)((Object)field), (Object)((BindingValidationStatus)errors.get(0)).getField());
        Assert.assertEquals((Object)message, ((BindingValidationStatus)errors.get(0)).getMessage().get());
        this.assertInvalidField(message, field);
    }

    private static class TestBean
    implements Serializable {
        private Set<TestEnum> enums;
        private int number;

        private TestBean() {
        }

        public Set<TestEnum> getEnums() {
            return this.enums;
        }

        public void setEnums(Set<TestEnum> enums) {
            this.enums = enums;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    private class TestClass {
        private TestSelectComponent<TestEnum> enums;
        private TestTextField number = new TestTextField();

        private TestClass() {
        }
    }

    private class TestClassWithoutFields {
        private TestClassWithoutFields() {
        }
    }

    public static class PersonForm {
        private TestTextField mydate = new TestTextField();
    }

    public static class Person {
        LocalDate mydate;

        public LocalDate getMydate() {
            return this.mydate;
        }

        public void setMydate(LocalDate mydate) {
            this.mydate = mydate;
        }
    }

    public static class RequiredConstraints
    implements Serializable {
        @NotNull
        @Max(value=10L)
        private @NotNull @Max(value=10L) String firstname;
        @Size(min=3, max=16)
        @Digits(integer=3, fraction=2)
        private @Size(min=3, max=16) @Digits(integer=3, fraction=2) String age;
        @NotEmpty
        private String lastname;
        private SubConstraint subfield;

        public String getFirstname() {
            return this.firstname;
        }

        public void setFirstname(String firstname) {
            this.firstname = firstname;
        }

        public String getAge() {
            return this.age;
        }

        public void setAge(String age) {
            this.age = age;
        }

        public String getLastname() {
            return this.lastname;
        }

        public void setLastname(String lastname) {
            this.lastname = lastname;
        }

        public SubConstraint getSubfield() {
            return this.subfield;
        }

        public void setSubfield(SubConstraint subfield) {
            this.subfield = subfield;
        }

        public static class SubConstraint
        implements Serializable {
            @NotNull
            @NotEmpty
            @Size(min=5)
            private @NotNull @NotEmpty @Size(min=5) String name;
            private SubSubConstraint subsub;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public SubSubConstraint getSubsub() {
                return this.subsub;
            }

            public void setSubsub(SubSubConstraint subsub) {
                this.subsub = subsub;
            }
        }

        public static class SubSubConstraint
        implements Serializable {
            @Size(min=10)
            private @Size(min=10) String value;

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    private static final class TestEnum
    extends Enum<TestEnum> {
        private static final /* synthetic */ TestEnum[] $VALUES;

        public static TestEnum[] values() {
            return (TestEnum[])$VALUES.clone();
        }

        public static TestEnum valueOf(String name) {
            return Enum.valueOf(TestEnum.class, name);
        }

        private static /* synthetic */ TestEnum[] $values() {
            return new TestEnum[0];
        }

        static {
            $VALUES = TestEnum.$values();
        }
    }
}

