/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.binder.testcomponents.TestDatePicker;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinRequest;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValueContextTest
extends UI {
    private static final Locale UI_LOCALE = Locale.GERMAN;
    private static final Locale COMPONENT_LOCALE = Locale.FRENCH;
    private TestTextField textField;
    private Binder<PasswordBean> binder;
    private TestTextField passwordField;
    private TestTextField confirmPasswordField;

    @Test
    public void locale_from_component() {
        this.setLocale(COMPONENT_LOCALE);
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Locale locale = fromComponent.getLocale().orElse(null);
        Objects.requireNonNull(locale);
        Assert.assertEquals((String)"Unexpected locale from component", (Object)COMPONENT_LOCALE, (Object)locale);
    }

    @Test
    public void locale_from_ui() {
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Locale locale = fromComponent.getLocale().orElse(null);
        Objects.requireNonNull(locale);
        Assert.assertEquals((String)"Unexpected locale from component", (Object)UI_LOCALE, (Object)locale);
    }

    @Test
    public void default_locale() {
        this.setLocale(Locale.getDefault());
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Locale locale = fromComponent.getLocale().orElse(null);
        Objects.requireNonNull(locale);
        Assert.assertEquals((String)"Unexpected locale from component", (Object)Locale.getDefault(), (Object)locale);
    }

    @Test
    public void testHasValue1() {
        this.setLocale(Locale.getDefault());
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Assert.assertEquals((Object)((Object)this.textField), fromComponent.getHasValue().get());
    }

    @Test
    public void testHasValue2() {
        this.setLocale(Locale.getDefault());
        ValueContext fromComponent = new ValueContext((Component)new TestDatePicker(), (HasValue)this.textField);
        Assert.assertEquals((Object)((Object)this.textField), fromComponent.getHasValue().get());
    }

    @Test
    public void testHasValue3() {
        this.setLocale(Locale.getDefault());
        ValueContext fromComponent = new ValueContext((Component)new TestDatePicker(), (HasValue)this.textField, Locale.CANADA);
        Assert.assertEquals((Object)((Object)this.textField), fromComponent.getHasValue().get());
        Assert.assertEquals((Object)Locale.CANADA, fromComponent.getLocale().get());
    }

    @Test
    public void getLocale_localeComesFromComponentUI() {
        UI.setCurrent(null);
        UI ui = new UI();
        ui.setLocale(Locale.GERMAN);
        Text text = new Text("");
        ui.add(new Component[]{text});
        ValueContext context = new ValueContext((Component)text);
        Assert.assertEquals((Object)Locale.GERMAN, context.getLocale().get());
    }

    @Test
    public void testWithBinder() {
        PasswordBean passwordBean = new PasswordBean();
        this.binder.setBean((Object)passwordBean);
        this.passwordField.setValue("abc123");
        this.confirmPasswordField.setValue("def456");
        BinderValidationStatus status = this.binder.validate();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals(((BindingValidationStatus)status.getFieldValidationErrors().iterator().next()).getMessage().get(), (Object)"Passwords must match");
        this.confirmPasswordField.setValue("abc123");
        status = this.binder.validate();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
    }

    @Before
    public void setUp() {
        this.setLocale(UI_LOCALE);
        UI.setCurrent((UI)this);
        this.textField = new TestTextField();
        this.add(new Component[]{this.textField});
        this.binder = new Binder(PasswordBean.class);
        this.passwordField = new TestTextField();
        this.confirmPasswordField = new TestTextField();
        this.binder.forField((HasValue)this.passwordField).bind("password");
        this.binder.forField((HasValue)this.confirmPasswordField).withValidator((Validator & Serializable)(confirmValue, valueContext) -> {
            Binder ctxBinder = (Binder)valueContext.getBinder().get();
            Assert.assertSame((Object)ctxBinder, this.binder);
            TestTextField passwordField = (TestTextField)((Binder.Binding)ctxBinder.getBinding("password").get()).getField();
            return !Objects.equals(confirmValue, passwordField.getValue()) ? ValidationResult.error((String)"Passwords must match") : ValidationResult.ok();
        }).bind("confirmPassword");
    }

    @After
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    public void init(VaadinRequest request) {
    }

    public static class PasswordBean {
        private String password;
        private String confirmPassword;

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getConfirmPassword() {
            return this.confirmPassword;
        }

        public void setConfirmPassword(String confirmPassword) {
            this.confirmPassword = confirmPassword;
        }
    }
}

