/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderTestBase;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.BinderValidationStatusHandler;
import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.BindingValidationStatusHandler;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.testcomponents.TestLabel;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.tests.data.bean.Person;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderValidationStatusTest
extends BinderTestBase<Binder<Person>, Person> {
    private final Map<HasValue<?, ?>, String> componentErrors = new HashMap();
    protected static final BindingValidationStatusHandler NOOP = (BindingValidationStatusHandler & Serializable)event -> {};

    @Before
    public void setUp() {
        this.binder = new Binder<Person>(){

            protected void handleError(HasValue<?, ?> field, ValidationResult result) {
                BinderValidationStatusTest.this.componentErrors.put(field, result.getErrorMessage());
            }

            protected void clearError(HasValue<?, ?> field) {
                super.clearError(field);
                BinderValidationStatusTest.this.componentErrors.remove(field);
            }
        };
        this.item = new Person();
        ((Person)this.item).setFirstName("Johannes");
        ((Person)this.item).setAge(32);
    }

    @Test
    public void bindingWithStatusHandler_handlerGetsEvents() {
        AtomicReference statusCapture = new AtomicReference();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> {
            Assert.assertNull(statusCapture.get());
            statusCapture.set(evt);
        });
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setValue("");
        this.binder.validate();
        Assert.assertNotNull(statusCapture.get());
        BindingValidationStatus evt2 = (BindingValidationStatus)statusCapture.get();
        Assert.assertEquals((Object)BindingValidationStatus.Status.ERROR, (Object)evt2.getStatus());
        Assert.assertEquals((Object)"Value cannot be empty", evt2.getMessage().get());
        Assert.assertEquals((Object)((Object)this.nameField), (Object)evt2.getField());
        statusCapture.set(null);
        this.nameField.setValue("foo");
        statusCapture.set(null);
        this.binder.validate();
        evt2 = (BindingValidationStatus)statusCapture.get();
        Assert.assertNotNull((Object)evt2);
        Assert.assertEquals((Object)BindingValidationStatus.Status.OK, (Object)evt2.getStatus());
        Assert.assertFalse((boolean)evt2.getMessage().isPresent());
        Assert.assertEquals((Object)((Object)this.nameField), (Object)evt2.getField());
    }

    @Test
    public void bindingWithStatusLabel_labelIsUpdatedAccordingStatus() {
        TestLabel label = new TestLabel();
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withStatusLabel((HasText)label).bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setValue("");
        binding.validate();
        this.assertVisible(label, true);
        Assert.assertEquals((Object)"Value cannot be empty", (Object)label.getText());
        this.nameField.setValue("foo");
        binding.validate();
        this.assertVisible(label, false);
        Assert.assertEquals((Object)"", (Object)label.getText());
    }

    @Test
    public void bindingWithStatusLabel_defaultStatusHandlerIsReplaced() {
        TestLabel label = new TestLabel();
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withStatusLabel((HasText)label).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
        this.nameField.setValue("");
        binding.validate();
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusHandler_addAfterBound() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail());
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusLabel_addAfterBound() {
        TestLabel label = new TestLabel();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withStatusLabel((HasText)label);
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusLabel_setAfterHandler() {
        TestLabel label = new TestLabel();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withValidationStatusHandler(NOOP);
        binding.withStatusLabel((HasText)label);
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusHandler_setAfterLabel() {
        TestLabel label = new TestLabel();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withStatusLabel((HasText)label);
        binding.withValidationStatusHandler(NOOP);
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusHandler_setAfterOtherHandler() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withValidationStatusHandler(NOOP);
        binding.withValidationStatusHandler(NOOP);
    }

    @Test
    public void binderWithStatusHandler_fieldValidationNoBeanValidation_handlerGetsStatusUpdates() {
        AtomicReference statusCapture = new AtomicReference();
        this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter(this.stringToInteger).withValidator(this.notNegative).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getAge, Person::setAge);
        this.binder.setValidationStatusHandler(statusCapture::set);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
        this.nameField.setValue("");
        this.ageField.setValue("5");
        BinderValidationStatus status2 = this.binder.validate();
        BinderValidationStatus status = (BinderValidationStatus)statusCapture.get();
        Assert.assertSame((Object)status2, (Object)status);
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
        List bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertNotNull((Object)bindingStatuses);
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        BindingValidationStatus r = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertTrue((boolean)r.isError());
        Assert.assertEquals((Object)"Value cannot be empty", r.getMessage().get());
        Assert.assertEquals((Object)((Object)this.nameField), (Object)r.getField());
        r = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertFalse((boolean)r.isError());
        Assert.assertFalse((boolean)r.getMessage().isPresent());
        Assert.assertEquals((Object)((Object)this.ageField), (Object)r.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        this.nameField.setValue("foo");
        this.ageField.setValue("");
        statusCapture.set(null);
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        r = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertFalse((boolean)r.isError());
        Assert.assertFalse((boolean)r.getMessage().isPresent());
        Assert.assertEquals((Object)((Object)this.nameField), (Object)r.getField());
        r = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertTrue((boolean)r.isError());
        Assert.assertEquals((Object)"Value must be a number", r.getMessage().get());
        Assert.assertEquals((Object)((Object)this.ageField), (Object)r.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        statusCapture.set(null);
        this.ageField.setValue("0");
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
    }

    @Test
    public void binderWithStatusHandler_fieldAndBeanLevelValidation_handlerGetsStatusUpdates() {
        AtomicReference statusCapture = new AtomicReference();
        this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter(this.stringToInteger).withValidator(this.notNegative).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getAge, Person::setAge);
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> !bean.getFirstName().isEmpty() && bean.getAge() > 0, "Need first name and age");
        this.binder.setValidationStatusHandler(statusCapture::set);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
        this.nameField.setValue("");
        this.ageField.setValue("5");
        BinderValidationStatus status2 = this.binder.validate();
        BinderValidationStatus status = (BinderValidationStatus)statusCapture.get();
        Assert.assertSame((Object)status2, (Object)status);
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
        List bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertNotNull((Object)bindingStatuses);
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        BindingValidationStatus r = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertTrue((boolean)r.isError());
        Assert.assertEquals((Object)"Value cannot be empty", r.getMessage().get());
        Assert.assertEquals((Object)((Object)this.nameField), (Object)r.getField());
        r = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertFalse((boolean)r.isError());
        Assert.assertFalse((boolean)r.getMessage().isPresent());
        Assert.assertEquals((Object)((Object)this.ageField), (Object)r.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        this.nameField.setValue("foo");
        this.ageField.setValue("");
        statusCapture.set(null);
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        r = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertFalse((boolean)r.isError());
        Assert.assertFalse((boolean)r.getMessage().isPresent());
        Assert.assertEquals((Object)((Object)this.nameField), (Object)r.getField());
        r = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertTrue((boolean)r.isError());
        Assert.assertEquals((Object)"Value must be a number", r.getMessage().get());
        Assert.assertEquals((Object)((Object)this.ageField), (Object)r.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        statusCapture.set(null);
        this.ageField.setValue("0");
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        Assert.assertEquals((long)1L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)1L, (long)status.getBeanValidationErrors().size());
        Assert.assertEquals((Object)"Need first name and age", (Object)((ValidationResult)status.getBeanValidationErrors().get(0)).getErrorMessage());
    }

    @Test
    public void binderWithStatusHandler_defaultStatusHandlerIsReplaced() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> {}).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
        this.nameField.setValue("");
        binding.validate();
        Assert.assertNull((Object)this.componentErrors.get((Object)this.nameField));
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusHandler_addAfterBound() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail());
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusLabel_addAfterBound() {
        TestLabel label = new TestLabel();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withStatusLabel((HasText)label);
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusLabel_setAfterHandler() {
        TestLabel label = new TestLabel();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)event -> {});
        this.binder.setStatusLabel((HasText)label);
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusHandler_setAfterLabel() {
        TestLabel label = new TestLabel();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setStatusLabel((HasText)label);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)event -> {});
    }

    @Test(expected=NullPointerException.class)
    public void binderWithNullStatusHandler_throws() {
        this.binder.setValidationStatusHandler(null);
    }

    @Test
    public void binderWithStatusHandler_replaceHandler() {
        AtomicReference capture = new AtomicReference();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)results -> Assert.fail());
        this.binder.setValidationStatusHandler(capture::set);
        this.nameField.setValue("foo");
        this.binder.validate();
        List results2 = ((BinderValidationStatus)capture.get()).getFieldValidationStatuses();
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((long)1L, (long)results2.size());
        Assert.assertFalse((boolean)((BindingValidationStatus)results2.get(0)).isError());
        this.assertValidField(this.nameField);
    }

    private void assertVisible(TestLabel label, boolean visible) {
        if (visible) {
            Assert.assertNull((Object)label.getStyle().get("display"));
        } else {
            Assert.assertEquals((Object)"none", (Object)label.getStyle().get("display"));
        }
    }

    @Test
    public void binderValidationStatus_nullBindingStatuses() {
        try {
            new BinderValidationStatus(new Binder(), null, Collections.emptyList());
            Assert.fail((String)"Binder should throw an NPE");
        }
        catch (NullPointerException npe) {
            Assert.assertNotNull((Object)npe.getMessage());
        }
    }
}

