/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.ValidatorTestBase;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public class ValidatorTest
extends ValidatorTestBase {
    @Test
    public void alwaysPass() {
        Validator alwaysPass = Validator.alwaysPass();
        ValidationResult result = alwaysPass.apply((Object)"foo", new ValueContext());
        Assert.assertFalse((boolean)result.isError());
    }

    @Test
    public void from() {
        Validator validator = Validator.from(Objects::nonNull, (String)"Cannot be null");
        ValidationResult result = validator.apply(null, new ValueContext());
        Assert.assertTrue((boolean)result.isError());
        result = validator.apply((Object)"", new ValueContext());
        Assert.assertFalse((boolean)result.isError());
    }

    @Test
    public void withValidator_customErrorMessageProvider() {
        String finnishError = "K\u00e4ytt\u00e4j\u00e4n tulee olla t\u00e4ysi-ik\u00e4inen";
        String englishError = "The user must be an adult";
        String notTranslatableError = "NOT TRANSLATABLE";
        Validator ageValidator = Validator.from((SerializablePredicate & Serializable)age -> age >= 18, (ErrorMessageProvider & Serializable)ctx -> {
            Locale locale = ctx.getLocale().orElse(Locale.ENGLISH);
            if (locale.getLanguage().equals("fi")) {
                return finnishError;
            }
            if (locale.getLanguage().equals("en")) {
                return englishError;
            }
            return notTranslatableError;
        });
        this.setLocale(Locale.ENGLISH);
        this.assertFails(17, englishError, ageValidator);
        this.setLocale(new Locale("fi", "FI"));
        this.assertFails(17, finnishError, ageValidator);
        this.setLocale(Locale.GERMAN);
        this.assertFails(17, notTranslatableError, ageValidator);
    }
}

