/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.LazyDataView;
import java.util.stream.Stream;

public abstract class AbstractLazyDataView<T>
extends AbstractDataView<T>
implements LazyDataView<T> {
    private final DataCommunicator<T> dataCommunicator;

    public AbstractLazyDataView(DataCommunicator<T> dataCommunicator, Component component) {
        super(dataCommunicator::getDataProvider, component);
        this.dataCommunicator = dataCommunicator;
    }

    protected DataCommunicator<T> getDataCommunicator() {
        this.verifyDataProviderType(this.dataCommunicator.getDataProvider().getClass());
        return this.dataCommunicator;
    }

    @Override
    public T getItem(int index) {
        return this.getDataCommunicator().getItem(index);
    }

    @Override
    public Stream<T> getItems() {
        DataCommunicator<T> verifiedDataCommunicator = this.getDataCommunicator();
        if (verifiedDataCommunicator.isDefinedSize()) {
            return verifiedDataCommunicator.getDataProvider().fetch(verifiedDataCommunicator.buildQuery(0, verifiedDataCommunicator.getItemCount()));
        }
        return verifiedDataCommunicator.getDataProvider().fetch(verifiedDataCommunicator.buildQuery(0, Integer.MAX_VALUE));
    }

    @Override
    protected Class<?> getSupportedDataProviderType() {
        return BackEndDataProvider.class;
    }

    @Override
    public void setItemCountEstimate(int itemCountEstimate) {
        this.getDataCommunicator().setItemCountEstimate(itemCountEstimate);
    }

    @Override
    public int getItemCountEstimate() {
        return this.getDataCommunicator().getItemCountEstimate();
    }

    @Override
    public void setItemCountEstimateIncrease(int itemCountEstimateIncrease) {
        this.getDataCommunicator().setItemCountEstimateIncrease(itemCountEstimateIncrease);
    }

    @Override
    public int getItemCountEstimateIncrease() {
        return this.getDataCommunicator().getItemCountEstimateIncrease();
    }

    @Override
    public void setItemCountFromDataProvider() {
        this.getDataCommunicator().setDefinedSize(true);
    }

    @Override
    public void setItemCountUnknown() {
        this.getDataCommunicator().setDefinedSize(false);
    }
}

