/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.BeanValidationBinder;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderTestBase;
import com.vaadin.flow.tests.data.bean.BeanToValidate;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnbindTest
extends BinderTestBase<Binder<BeanToValidate>, BeanToValidate> {
    @Before
    public void setUp() {
        this.binder = new BeanValidationBinder(BeanToValidate.class);
        this.item = new BeanToValidate();
        ((BeanToValidate)this.item).setFirstname("Johannes");
        ((BeanToValidate)this.item).setAge(32);
    }

    @Test
    public void binding_unbind_shouldBeRemovedFromBindings() {
        Binder.Binding firstnameBinding = this.binder.bind((HasValue)this.nameField, "firstname");
        Assert.assertEquals((long)1L, (long)this.binder.getBindings().size());
        firstnameBinding.unbind();
        Assert.assertTrue((boolean)this.binder.getBindings().isEmpty());
        Assert.assertNull((Object)firstnameBinding.getField());
    }

    @Test
    public void binding_unbindDuringReadBean_shouldBeRemovedFromBindings() {
        Binder.Binding firstnameBinding = this.binder.bind((HasValue)this.nameField, "firstname");
        Binder.Binding ageBinding = this.binder.bind((HasValue)this.ageField, "age");
        Assert.assertEquals((long)2L, (long)this.binder.getBindings().size());
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (((String)event.getValue()).length() > 0) {
                ageBinding.unbind();
            }
        });
        this.binder.readBean((Object)((BeanToValidate)this.item));
        Assert.assertEquals((long)1L, (long)this.binder.getBindings().size());
        Assert.assertNull((Object)ageBinding.getField());
    }

    @Test
    public void binding_unbindTwice_shouldBeRemovedFromBindings() {
        Binder.Binding firstnameBinding = this.binder.bind((HasValue)this.nameField, "firstname");
        Assert.assertEquals((long)1L, (long)this.binder.getBindings().size());
        firstnameBinding.unbind();
        firstnameBinding.unbind();
        Assert.assertTrue((boolean)this.binder.getBindings().isEmpty());
        Assert.assertNull((Object)firstnameBinding.getField());
    }
}

