/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class BinderTestBase<BINDER extends Binder<ITEM>, ITEM>
implements Serializable {
    protected static final String NEGATIVE_ERROR_MESSAGE = "Value must be non-negative";
    protected static final String NOT_NUMBER_ERROR_MESSAGE = "Value must be a number";
    protected static final String EMPTY_ERROR_MESSAGE = "Value cannot be empty";
    protected BINDER binder;
    protected ITEM item;
    protected TestTextField nameField;
    protected TestTextField ageField;
    protected Validator<String> notEmpty = Validator.from((SerializablePredicate & Serializable)val -> !val.isEmpty(), (String)"Value cannot be empty");
    protected Converter<String, Integer> stringToInteger = Converter.from(Integer::valueOf, String::valueOf, (SerializableFunction & Serializable)e -> "Value must be a number");
    protected Validator<Integer> notNegative = Validator.from((SerializablePredicate & Serializable)x -> x >= 0, (String)"Value must be non-negative");

    public static void testSerialization(Object toSerialize) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());){
            objectOutputStream.writeObject(toSerialize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void assertInvalidField(String expectedErrorMessage, HasValidation field) {
        Assert.assertEquals((String)"The field should contain same error message as binder", (Object)expectedErrorMessage, (Object)field.getErrorMessage());
        Assert.assertTrue((String)"The field should be invalid", (boolean)field.isInvalid());
    }

    void assertValidField(HasValidation field) {
        Assert.assertFalse((String)"The field should be valid", (boolean)field.isInvalid());
    }

    @Before
    public void setUpBase() {
        UI ui = new UI(){

            public Locale getLocale() {
                return Locale.US;
            }
        };
        this.nameField = new TestTextField();
        this.ageField = new TestTextField();
        ui.add(new Component[]{this.nameField, this.ageField});
    }

    @After
    public void testBinderSerialization() {
        BinderTestBase.testSerialization(this.binder);
    }
}

