/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderTestBase;
import com.vaadin.flow.data.binder.BinderValidationErrorHandler;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.BindingException;
import com.vaadin.flow.data.binder.BindingExceptionHandler;
import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.BindingValidationStatusHandler;
import com.vaadin.flow.data.binder.DefaultBindingExceptionHandler;
import com.vaadin.flow.data.binder.ErrorLevel;
import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.StatusChangeListener;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToBigDecimalConverter;
import com.vaadin.flow.data.converter.StringToDoubleConverter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.validator.IntegerRangeValidator;
import com.vaadin.flow.data.validator.NotEmptyValidator;
import com.vaadin.flow.data.validator.StringLengthValidator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.tests.data.bean.Person;
import com.vaadin.flow.tests.data.bean.Sex;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BinderTest
extends BinderTestBase<Binder<Person>, Person> {
    private Map<HasValue<?, ?>, String> componentErrors = new HashMap();
    @Rule
    public transient ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setUp() {
        this.binder = new Binder<Person>(){

            protected void handleError(HasValue<?, ?> field, ValidationResult result) {
                super.handleError(field, result);
                BinderTest.this.componentErrors.put(field, result.getErrorMessage());
            }

            protected void clearError(HasValue<?, ?> field) {
                super.clearError(field);
                BinderTest.this.componentErrors.remove(field);
            }
        };
        this.item = new Person();
        ((Person)this.item).setFirstName("Johannes");
        ((Person)this.item).setAge(32);
    }

    @After
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    @Test
    public void bindNullBean_noBeanPresent() {
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNotNull((Object)this.binder.getBean());
        this.binder.setBean(null);
        Assert.assertNull((Object)this.binder.getBean());
    }

    @Test
    public void bindNullBean_FieldsAreCleared() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"No age field value", (Object)"32", (Object)this.ageField.getValue());
        this.binder.setBean(null);
        Assert.assertEquals((String)"Name field not empty", (Object)"", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"Age field not empty", (Object)"", (Object)this.ageField.getValue());
    }

    @Test
    public void removeInvalidBinding_validateDoesNotThrow() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        Binder.Binding ageBinding = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> true, "");
        this.binder.setBean((Object)((Person)this.item));
        this.ageField.setValue("foo");
        this.binder.removeBinding(ageBinding);
        this.binder.validate();
    }

    @Test
    public void clearForReadBean_boundFieldsAreCleared() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"No age field value", (Object)"32", (Object)this.ageField.getValue());
        this.binder.readBean(null);
        Assert.assertEquals((String)"Name field not empty", (Object)"", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"Age field not empty", (Object)"", (Object)this.ageField.getValue());
    }

    @Test
    public void clearReadOnlyField_shouldClearField() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setReadOnly(true);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        this.binder.setBean(null);
        Assert.assertEquals((String)"ReadOnly field not empty", (Object)"", (Object)this.nameField.getValue());
    }

    @Test
    public void clearBean_setsHasChangesToFalse() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setReadOnly(true);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"No name field value", (Object)"Johannes", (Object)this.nameField.getValue());
        this.nameField.setValue("James");
        Assert.assertTrue((String)"Binder did not have value changes", (boolean)this.binder.hasChanges());
        this.binder.readBean(null);
        Assert.assertFalse((String)"Binder has changes after clearing all fields", (boolean)this.binder.hasChanges());
    }

    @Test
    public void clearReadOnlyBinder_shouldClearFields() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setReadOnly(true);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.setBean(null);
        Assert.assertEquals((String)"ReadOnly name field not empty", (Object)"", (Object)this.nameField.getValue());
        Assert.assertEquals((String)"ReadOnly age field not empty", (Object)"", (Object)this.ageField.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void bindNullField_throws() {
        this.binder.forField(null);
    }

    @Test(expected=NullPointerException.class)
    public void bindNullGetter_throws() {
        this.binder.bind((HasValue)this.nameField, null, Person::setFirstName);
    }

    @Test
    public void fieldBound_bindItem_fieldValueUpdated() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test
    public void fieldBoundWithShortcut_bindBean_fieldValueUpdated() {
        this.bindName();
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test
    public void beanBound_updateFieldValue_beanValueUpdated() {
        this.binder.setBean((Object)((Person)this.item));
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)"Artur", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void bound_getBean_returnsBoundBean() {
        Assert.assertNull((Object)this.binder.getBean());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertSame((Object)this.item, (Object)this.binder.getBean());
    }

    @Test
    public void unbound_getBean_returnsNothing() {
        this.binder.setBean((Object)((Person)this.item));
        this.binder.removeBean();
        Assert.assertNull((Object)this.binder.getBean());
    }

    @Test
    public void bound_changeFieldValue_beanValueUpdated() {
        this.bindName();
        this.nameField.setValue("Henri");
        Assert.assertEquals((Object)"Henri", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void unbound_changeFieldValue_beanValueNotUpdated() {
        this.bindName();
        this.nameField.setValue("Henri");
        this.binder.removeBean();
        this.nameField.setValue("Aleksi");
        Assert.assertEquals((Object)"Henri", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void bindNullSetter_valueChangesIgnored() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)((Person)this.item).getFirstName(), (Object)"Johannes");
    }

    @Test
    public void bindReadOnly_valueChangesIgnored_fieldIsReadOnly() {
        this.binder.bindReadOnly((HasValue)this.nameField, Person::getFirstName);
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)((Person)this.item).getFirstName(), (Object)"Johannes");
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
    }

    @Test
    public void bindReadOnly_proeprtyBinding_valueChangesIgnored_fieldIsReadOnly() {
        this.binder = new Binder(Person.class);
        this.binder.bindReadOnly((HasValue)this.nameField, "firstName");
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)((Person)this.item).getFirstName(), (Object)"Johannes");
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
    }

    @Test
    public void bindBindingReadOnly_valueChangesIgnored_fieldIsReadOnly() {
        this.binder.forField((HasValue)this.nameField).bindReadOnly(Person::getFirstName);
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)((Person)this.item).getFirstName(), (Object)"Johannes");
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
    }

    @Test
    public void bindBindingReadOnly_proeprtyBinding_valueChangesIgnored_fieldIsReadOnly() {
        this.binder = new Binder(Person.class);
        this.binder.forField((HasValue)this.nameField).bindReadOnly("firstName");
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("Artur");
        Assert.assertEquals((Object)((Person)this.item).getFirstName(), (Object)"Johannes");
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
    }

    @Test
    public void bound_bindToAnotherBean_stopsUpdatingOriginal() {
        this.bindName();
        this.nameField.setValue("Leif");
        Person p2 = new Person();
        p2.setFirstName("Marlon");
        this.binder.setBean((Object)p2);
        Assert.assertEquals((Object)"Marlon", (Object)this.nameField.getValue());
        Assert.assertEquals((Object)"Leif", (Object)((Person)this.item).getFirstName());
        Assert.assertSame((Object)p2, (Object)this.binder.getBean());
        this.nameField.setValue("Ilia");
        Assert.assertEquals((Object)"Ilia", (Object)p2.getFirstName());
        Assert.assertEquals((Object)"Leif", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void save_unbound_noChanges() throws ValidationException {
        Binder binder = new Binder();
        Person person = new Person();
        int age = 10;
        person.setAge(age);
        binder.writeBean((Object)person);
        Assert.assertEquals((long)age, (long)person.getAge());
    }

    @Test
    public void save_bound_beanIsUpdated() throws ValidationException {
        Binder binder = new Binder();
        binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        String fieldValue = "bar";
        this.nameField.setValue(fieldValue);
        person.setFirstName("foo");
        binder.writeBean((Object)person);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
    }

    @Test
    public void save_bound_beanAsDraft() {
        this.do_test_save_bound_beanAsDraft(false);
    }

    @Test
    public void save_bound_beanAsDraft_setBean() {
        this.do_test_save_bound_beanAsDraft(true);
    }

    private void do_test_save_bound_beanAsDraft(boolean setBean) {
        Binder binder = new Binder();
        binder.forField((HasValue)this.nameField).withValidator((Validator & Serializable)(value, context) -> {
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        if (setBean) {
            binder.setBean((Object)person);
        }
        String fieldValue = "John";
        this.nameField.setValue(fieldValue);
        int age = 10;
        this.ageField.setValue("10");
        person.setFirstName("Mark");
        binder.writeBeanAsDraft((Object)person);
        Assert.assertNotEquals((Object)fieldValue, (Object)person.getFirstName());
        Assert.assertEquals((long)age, (long)person.getAge());
        binder.writeBeanAsDraft((Object)person, true);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
    }

    @Test
    public void save_bound_bean_disable_validation_binding() throws ValidationException {
        Binder binder = new Binder();
        Binder.Binding nameBinding = binder.forField((HasValue)this.nameField).withValidator((Validator & Serializable)(value, context) -> {
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        String fieldValue = "John";
        this.nameField.setValue(fieldValue);
        int age = 10;
        this.ageField.setValue("10");
        person.setFirstName("Mark");
        nameBinding.setValidatorsDisabled(true);
        binder.writeBean((Object)person);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
        Assert.assertEquals((long)age, (long)person.getAge());
    }

    @Test
    public void save_bound_bean_disable_validation_binder() throws ValidationException {
        Binder binder = new Binder();
        binder.forField((HasValue)this.nameField).withValidator((Validator & Serializable)(value, context) -> {
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Person person = new Person();
        String fieldValue = "John";
        this.nameField.setValue(fieldValue);
        int age = 10;
        this.ageField.setValue("10");
        person.setFirstName("Mark");
        binder.setValidatorsDisabled(true);
        binder.writeBean((Object)person);
        Assert.assertEquals((Object)fieldValue, (Object)person.getFirstName());
        Assert.assertEquals((long)age, (long)person.getAge());
    }

    @Test
    public void load_bound_fieldValueIsUpdated() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        String name = "bar";
        person.setFirstName(name);
        this.binder.readBean((Object)person);
        Assert.assertEquals((Object)name, (Object)this.nameField.getValue());
    }

    @Test
    public void load_unbound_noChanges() {
        this.nameField.setValue("");
        Person person = new Person();
        String name = "bar";
        person.setFirstName(name);
        this.binder.readBean((Object)person);
        Assert.assertEquals((Object)"", (Object)this.nameField.getValue());
    }

    protected void bindName() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
    }

    @Test
    public void binding_with_null_representation() {
        String nullRepresentation = "Some arbitrary text";
        String realName = "John";
        Person namelessPerson = new Person(null, "Doe", "", 25, Sex.UNKNOWN, null);
        this.binder.forField((HasValue)this.nameField).withNullRepresentation((Object)nullRepresentation).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)namelessPerson);
        Assert.assertEquals((String)"Null value from bean was not converted to explicit null representation", (Object)nullRepresentation, (Object)this.nameField.getValue());
        this.nameField.setValue(realName);
        Assert.assertEquals((String)"Bean was not correctly updated from a change in the field", (Object)realName, (Object)namelessPerson.getFirstName());
        this.nameField.setValue(nullRepresentation);
        Assert.assertEquals((String)"Two-way null representation did not change value back to null", null, (Object)namelessPerson.getFirstName());
    }

    @Test
    public void binding_with_default_null_representation() {
        TestTextField nullTextField = new TestTextField(){

            public String getEmptyValue() {
                return "null";
            }
        };
        Person namelessPerson = new Person(null, "Doe", "", 25, Sex.UNKNOWN, null);
        this.binder.bind((HasValue)nullTextField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)namelessPerson);
        Assert.assertTrue((boolean)nullTextField.isEmpty());
        Assert.assertEquals((Object)"null", (Object)namelessPerson.getFirstName());
        nullTextField.setValue("");
        Assert.assertFalse((boolean)nullTextField.isEmpty());
        Assert.assertEquals((String)"First name of person was not properly updated", (Object)"", (Object)namelessPerson.getFirstName());
        nullTextField.setValue("null");
        Assert.assertTrue((boolean)nullTextField.isEmpty());
        Assert.assertEquals((String)"Default one-way null representation failed.", (Object)"null", (Object)namelessPerson.getFirstName());
    }

    @Test
    public void binding_with_null_representation_value_not_null() {
        String nullRepresentation = "Some arbitrary text";
        this.binder.forField((HasValue)this.nameField).withNullRepresentation((Object)nullRepresentation).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertFalse((String)"First name in item should not be null", (boolean)Objects.isNull(((Person)this.item).getFirstName()));
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Field value was not set correctly", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test
    public void withConverter_disablesDefaulNullRepresentation() {
        Integer customNullConverter = 0;
        this.binder.forField((HasValue)this.ageField).withNullRepresentation((Object)"foo").withConverter((Converter)new StringToIntegerConverter("")).withConverter((SerializableFunction & Serializable)age -> age, (SerializableFunction & Serializable)age -> age == null ? customNullConverter : age).bind(Person::getSalary, Person::setSalary);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)customNullConverter.toString(), (Object)this.ageField.getValue());
        Integer salary = 11;
        this.ageField.setValue(salary.toString());
        Assert.assertEquals((long)11L, (long)salary.intValue());
    }

    @Test
    public void withConverter_writeBackValue() {
        TestTextField rentField = new TestTextField();
        rentField.setValue("");
        this.binder.forField((HasValue)rentField).withConverter((Converter)new EuroConverter("")).withNullRepresentation((Object)BigDecimal.valueOf(0.0)).bind(Person::getRent, Person::setRent);
        this.binder.setBean((Object)((Person)this.item));
        rentField.setValue("10");
        Assert.assertEquals((Object)"\u20ac 10.00", (Object)rentField.getValue());
    }

    @Test
    public void withConverter_writeBackValueDisabled() {
        TestTextField rentField = new TestTextField();
        rentField.setValue("");
        Binder.Binding binding = this.binder.forField((HasValue)rentField).withConverter((Converter)new EuroConverter("")).withNullRepresentation((Object)BigDecimal.valueOf(0.0)).bind(Person::getRent, Person::setRent);
        this.binder.setBean((Object)((Person)this.item));
        binding.setConvertBackToPresentation(false);
        rentField.setValue("10");
        Assert.assertNotEquals((Object)"\u20ac 10.00", (Object)rentField.getValue());
    }

    @Test
    public void beanBinder_nullRepresentationIsNotDisabled() {
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)this.nameField).bind("firstName");
        Person person = new Person();
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"", (Object)this.nameField.getValue());
    }

    @Test
    public void beanBinder_withConverter_nullRepresentationIsNotDisabled() {
        String customNullPointerRepresentation = "foo";
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)this.nameField).withConverter((SerializableFunction & Serializable)value -> value, (SerializableFunction & Serializable)value -> value == null ? customNullPointerRepresentation : value).bind("firstName");
        Person person = new Person();
        binder.setBean((Object)person);
        Assert.assertEquals((Object)customNullPointerRepresentation, (Object)this.nameField.getValue());
    }

    @Test
    public void withValidator_doesNotDisablesDefaulNullRepresentation() {
        String nullRepresentation = "foo";
        this.binder.forField((HasValue)this.nameField).withNullRepresentation((Object)nullRepresentation).withValidator(new NotEmptyValidator("")).bind(Person::getFirstName, Person::setFirstName);
        ((Person)this.item).setFirstName(null);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)nullRepresentation, (Object)this.nameField.getValue());
        String newValue = "bar";
        this.nameField.setValue(newValue);
        Assert.assertEquals((Object)newValue, (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void setRequired_withErrorMessage_fieldGetsRequiredIndicatorAndValidator() {
        TestTextField textField = new TestTextField();
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Binder.BindingBuilder bindingBuilder = this.binder.forField((HasValue)textField);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        bindingBuilder.asRequired("foobar");
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Binder.Binding binding = bindingBuilder.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        MatcherAssert.assertThat((Object)textField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        textField.setValue((String)textField.getEmptyValue());
        Assert.assertEquals((Object)"foobar", (Object)this.componentErrors.get((Object)textField));
        textField.setValue("value");
        Assert.assertFalse((boolean)textField.isInvalid());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        binding.setAsRequiredEnabled(false);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        textField.setValue("");
        Assert.assertFalse((boolean)textField.isInvalid());
    }

    @Test(expected=IllegalStateException.class)
    public void settingAsRequiredEnabledFalseWhenNoAsRequired() {
        TestTextField textField = new TestTextField();
        Binder.BindingBuilder bindingBuilder = this.binder.forField((HasValue)textField);
        Binder.Binding binding = bindingBuilder.bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        binding.setAsRequiredEnabled(false);
    }

    @Test
    public void readNullBeanRemovesError() {
        TestTextField textField = new TestTextField();
        this.binder.forField((HasValue)textField).asRequired("foobar").bind(Person::getFirstName, Person::setFirstName);
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Assert.assertNull((Object)this.componentErrors.get((Object)textField));
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertNull((Object)this.componentErrors.get((Object)textField));
        textField.setValue((String)textField.getEmptyValue());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Assert.assertNotNull((Object)this.componentErrors.get((Object)textField));
        this.binder.readBean(null);
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        Assert.assertNull((Object)this.componentErrors.get((Object)textField));
    }

    @Test
    public void setRequired_withErrorMessageProvider_fieldGetsRequiredIndicatorAndValidator() {
        TestTextField textField = new TestTextField();
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Binder.BindingBuilder binding = this.binder.forField((HasValue)textField);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        AtomicInteger invokes = new AtomicInteger();
        binding.asRequired((ErrorMessageProvider & Serializable)context -> {
            invokes.incrementAndGet();
            return "foobar";
        });
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        MatcherAssert.assertThat((Object)textField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        Assert.assertEquals((long)0L, (long)invokes.get());
        textField.setValue((String)textField.getEmptyValue());
        Assert.assertEquals((Object)"foobar", (Object)this.componentErrors.get((Object)textField));
        Assert.assertEquals((long)1L, (long)invokes.get());
        textField.setValue("value");
        Assert.assertFalse((boolean)textField.isInvalid());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
    }

    @Test
    public void setRequired_withCustomValidator_fieldGetsRequiredIndicatorAndValidator() {
        TestTextField textField = new TestTextField();
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Binder.BindingBuilder binding = this.binder.forField((HasValue)textField);
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        AtomicInteger invokes = new AtomicInteger();
        Validator & Serializable customRequiredValidator = (Validator & Serializable)(value, context) -> {
            invokes.incrementAndGet();
            if (StringUtils.isBlank((CharSequence)value)) {
                return ValidationResult.error((String)"Input is required.");
            }
            return ValidationResult.ok();
        };
        binding.asRequired((Validator)customRequiredValidator);
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        MatcherAssert.assertThat((Object)textField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        Assert.assertEquals((long)1L, (long)invokes.get());
        textField.setValue("        ");
        String errorMessage = textField.getErrorMessage();
        Assert.assertNotNull((Object)errorMessage);
        Assert.assertEquals((Object)"Input is required.", (Object)this.componentErrors.get((Object)textField));
        Assert.assertEquals((long)2L, (long)invokes.get());
        textField.setValue("value");
        Assert.assertFalse((boolean)textField.isInvalid());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
    }

    @Test
    public void setRequired_withCustomValidator_modelConverterBeforeValidator() {
        TestTextField textField = new TestTextField();
        Assert.assertFalse((boolean)textField.isRequiredIndicatorVisible());
        Converter<String, String> stringBasicPreProcessingConverter = new Converter<String, String>(){

            public Result<String> convertToModel(String value, ValueContext context) {
                if (StringUtils.isBlank((CharSequence)value)) {
                    return Result.ok(null);
                }
                return Result.ok((Object)StringUtils.trim((String)value));
            }

            public String convertToPresentation(String value, ValueContext context) {
                if (value == null) {
                    return "";
                }
                return value;
            }
        };
        AtomicInteger invokes = new AtomicInteger();
        Validator & Serializable customRequiredValidator = (Validator & Serializable)(value, context) -> {
            invokes.incrementAndGet();
            if (value == null) {
                return ValidationResult.error((String)"Input required.");
            }
            return ValidationResult.ok();
        };
        this.binder.forField((HasValue)textField).withConverter((Converter)stringBasicPreProcessingConverter).asRequired((Validator)customRequiredValidator).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        MatcherAssert.assertThat((Object)textField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        Assert.assertEquals((long)1L, (long)invokes.get());
        textField.setValue(" ");
        Assert.assertNotNull((Object)textField.getErrorMessage());
        Assert.assertEquals((Object)"Input required.", (Object)this.componentErrors.get((Object)textField));
        Assert.assertEquals((long)2L, (long)invokes.get());
        textField.setValue("value");
        Assert.assertFalse((boolean)textField.isInvalid());
        Assert.assertTrue((boolean)textField.isRequiredIndicatorVisible());
    }

    @Test
    public void validationStatusHandler_onlyRunForChangedField() {
        TestTextField firstNameField = new TestTextField();
        TestTextField lastNameField = new TestTextField();
        AtomicInteger invokes = new AtomicInteger();
        this.binder.forField((HasValue)firstNameField).withValidator(new NotEmptyValidator("")).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)validationStatus -> invokes.addAndGet(1)).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)lastNameField).withValidator(new NotEmptyValidator("")).bind(Person::getLastName, Person::setLastName);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((long)2L, (long)invokes.get());
        lastNameField.setValue("");
        Assert.assertEquals((long)2L, (long)invokes.get());
        firstNameField.setValue("");
        Assert.assertEquals((long)3L, (long)invokes.get());
        this.binder.removeBean();
        Person person = new Person();
        person.setFirstName("a");
        person.setLastName("a");
        this.binder.readBean((Object)person);
        Assert.assertEquals((long)5L, (long)invokes.get());
        lastNameField.setValue("");
        Assert.assertEquals((long)5L, (long)invokes.get());
        firstNameField.setValue("");
        Assert.assertEquals((long)6L, (long)invokes.get());
    }

    @Test(expected=IllegalStateException.class)
    public void noArgsConstructor_stringBind_throws() {
        this.binder.bind((HasValue)new TestTextField(), "firstName");
    }

    @Test
    public void setReadOnly_unboundBinder() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField);
        this.binder.setReadOnly(true);
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
    }

    @Test
    public void setReadOnly_boundBinder() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)new Person());
        this.binder.setReadOnly(true);
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
        Assert.assertTrue((boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
    }

    @Test
    public void setReadOnly_binderLoadedByReadBean() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.readBean((Object)new Person());
        this.binder.setReadOnly(true);
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
        Assert.assertTrue((boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((boolean)this.nameField.isReadOnly());
        Assert.assertFalse((boolean)this.ageField.isReadOnly());
    }

    @Test
    public void setReadonlyShouldIgnoreBindingsWithNullSetter() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setReadOnly(true);
        Assert.assertTrue((String)"Name field should be ignored but should be readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertTrue((String)"Age field should be readonly", (boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertTrue((String)"Name field should be ignored and should remain readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertFalse((String)"Age field should not be readonly", (boolean)this.ageField.isReadOnly());
        this.nameField.setReadOnly(false);
        this.binder.setReadOnly(false);
        Assert.assertFalse((String)"Name field should be ignored and remain not readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertFalse((String)"Age field should not be readonly", (boolean)this.ageField.isReadOnly());
        this.binder.setReadOnly(true);
        Assert.assertFalse((String)"Name field should be ignored and remain not readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertTrue((String)"Age field should be readonly", (boolean)this.ageField.isReadOnly());
    }

    @Test
    public void isValidTest_bound_binder() {
        this.binder.forField((HasValue)this.nameField).withValidator(Validator.from((SerializablePredicate & Serializable)name -> !name.equals("fail field validation"), (String)"")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> !person.getFirstName().equals("fail bean validation"), (String)""));
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertTrue((boolean)this.binder.isValid());
        this.nameField.setValue("fail field validation");
        Assert.assertFalse((boolean)this.binder.isValid());
        this.nameField.setValue("");
        Assert.assertTrue((boolean)this.binder.isValid());
        this.nameField.setValue("fail bean validation");
        Assert.assertFalse((boolean)this.binder.isValid());
    }

    @Test
    public void isValidTest_unbound_binder() {
        this.binder.forField((HasValue)this.nameField).withValidator(Validator.from((SerializablePredicate & Serializable)name -> !name.equals("fail field validation"), (String)"")).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertTrue((boolean)this.binder.isValid());
        this.nameField.setValue("fail field validation");
        Assert.assertFalse((boolean)this.binder.isValid());
        this.nameField.setValue("");
        Assert.assertTrue((boolean)this.binder.isValid());
    }

    @Test(expected=IllegalStateException.class)
    public void isValidTest_unbound_binder_throws_with_bean_level_validation() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> !person.getFirstName().equals("fail bean validation"), (String)""));
        this.binder.isValid();
    }

    @Test
    public void getFields_returnsFields() {
        Assert.assertEquals((long)0L, (long)this.binder.getFields().count());
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.assertStreamEquals(Stream.of(this.nameField), this.binder.getFields());
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.assertStreamEquals(Stream.of(this.nameField, this.ageField), this.binder.getFields());
    }

    private void assertStreamEquals(Stream<?> s1, Stream<?> s2) {
        Assert.assertArrayEquals((Object[])s1.toArray(), (Object[])s2.toArray());
    }

    @Test
    public void multiple_calls_to_same_binding_builder() {
        String stringLength = "String length failure";
        String conversion = "Conversion failed";
        String ageLimit = "Age not in valid range";
        this.binder = new Binder(Person.class);
        Binder.BindingBuilder builder = this.binder.forField((HasValue)this.ageField);
        builder.withValidator((Validator)new StringLengthValidator(stringLength, Integer.valueOf(0), Integer.valueOf(3)));
        builder.withConverter((Converter)new StringToIntegerConverter(conversion));
        builder.withValidator((Validator)new IntegerRangeValidator(ageLimit, Integer.valueOf(3), Integer.valueOf(150)));
        Binder.Binding bind = builder.bind("age");
        this.binder.setBean((Object)((Person)this.item));
        this.ageField.setValue("123123");
        BindingValidationStatus validation = bind.validate();
        Assert.assertTrue((boolean)validation.isError());
        Assert.assertEquals((Object)stringLength, validation.getMessage().get());
        this.ageField.setValue("age");
        validation = bind.validate();
        Assert.assertTrue((boolean)validation.isError());
        Assert.assertEquals((Object)conversion, validation.getMessage().get());
        this.ageField.setValue("256");
        validation = bind.validate();
        Assert.assertTrue((boolean)validation.isError());
        Assert.assertEquals((Object)ageLimit, validation.getMessage().get());
        this.ageField.setValue("30");
        validation = bind.validate();
        Assert.assertFalse((boolean)validation.isError());
        Assert.assertEquals((long)30L, (long)((Person)this.item).getAge());
    }

    @Test
    public void remove_field_binding() {
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind(Person::getAge, Person::setAge);
        Assert.assertTrue((String)"Field not initially empty", (boolean)this.ageField.isEmpty());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Binding did not work", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
        this.binder.setBean(null);
        Assert.assertTrue((String)"Field not cleared", (boolean)this.ageField.isEmpty());
        this.binder.removeBinding((HasValue)this.ageField);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNotEquals((String)"Binding was not removed", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
    }

    @Test
    public void remove_propertyname_binding() {
        Binder binder = new Binder(Person.class);
        binder.bind((HasValue)this.nameField, "firstName");
        Assert.assertTrue((String)"Field not initially empty", (boolean)this.nameField.isEmpty());
        binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Binding did not work", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        binder.setBean(null);
        Assert.assertTrue((String)"Field not cleared", (boolean)this.nameField.isEmpty());
        binder.removeBinding("firstName");
        binder.setBean((Object)((Person)this.item));
        Assert.assertNotEquals((String)"Binding was not removed", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test
    public void remove_binding() {
        Binder.Binding binding = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind(Person::getAge, Person::setAge);
        Assert.assertTrue((String)"Field not initially empty", (boolean)this.ageField.isEmpty());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Binding did not work", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
        this.binder.setBean(null);
        Assert.assertTrue((String)"Field not cleared", (boolean)this.ageField.isEmpty());
        this.binder.removeBinding(binding);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNotEquals((String)"Binding was not removed", (Object)String.valueOf(((Person)this.item).getAge()), (Object)this.ageField.getValue());
    }

    @Test
    public void remove_binding_fromFieldValueChangeListener() {
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() == "REMOVE") {
                this.binder.removeBinding((HasValue)this.nameField);
            }
        });
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
        this.nameField.setValue("REMOVE");
        Assert.assertNotEquals((Object)"REMOVE", (Object)((Person)this.item).getFirstName());
    }

    @Test
    public void removed_binding_not_updates_value() {
        Binder.Binding binding = this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        String modifiedAge = String.valueOf(((Person)this.item).getAge() + 10);
        String ageBeforeUnbind = String.valueOf(((Person)this.item).getAge());
        this.binder.removeBinding(binding);
        this.ageField.setValue(modifiedAge);
        Assert.assertEquals((String)"Binding still affects bean even after unbind", (Object)ageBeforeUnbind, (Object)String.valueOf(((Person)this.item).getAge()));
    }

    @Test
    public void execute_binding_status_handler_from_binder_status_handler() {
        MyBindingHandler bindingHandler = new MyBindingHandler();
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)t -> !t.isEmpty(), "No empty values.").withValidationStatusHandler((BindingValidationStatusHandler)bindingHandler).bind(Person::getFirstName, Person::setFirstName);
        String ageError = "CONVERSIONERROR";
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter(ageError)).bind(Person::getAge, Person::setAge);
        this.binder.setValidationStatusHandler(BinderValidationStatus::notifyBindingValidationStatusHandlers);
        String initialName = ((Person)this.item).getFirstName();
        int initialAge = ((Person)this.item).getAge();
        this.binder.setBean((Object)((Person)this.item));
        bindingHandler.expectingError = true;
        this.nameField.setValue("");
        this.ageField.setValue("foo");
        MatcherAssert.assertThat((String)"Error message is not what was expected", (Object)this.ageField.getErrorMessage(), (Matcher)Matchers.containsString((String)ageError));
        this.ageField.setValue(String.valueOf(initialAge));
        Assert.assertFalse((String)"The field should be valid", (boolean)this.ageField.isInvalid());
        bindingHandler.expectingError = false;
        this.nameField.setValue(initialName);
        Assert.assertEquals((String)"Unexpected callCount to binding validation status handler", (long)6L, (long)bindingHandler.callCount);
    }

    @Test
    public void beanvalidation_two_fields_not_equal() {
        TestTextField lastNameField = new TestTextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        ((Person)this.item).setLastName("Valid");
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertFalse((String)"Should not have changes initially", (boolean)this.binder.hasChanges());
        Assert.assertTrue((String)"Should be ok initially", (boolean)this.binder.validate().isOk());
        Assert.assertNotEquals((String)"First name and last name are not same initially", (Object)((Person)this.item).getFirstName(), (Object)((Person)this.item).getLastName());
        this.nameField.setValue("Invalid");
        Assert.assertFalse((String)"First name change not handled", (boolean)this.binder.hasChanges());
        Assert.assertTrue((String)"Changing first name to something else than last name should be ok", (boolean)this.binder.validate().isOk());
        lastNameField.setValue("Invalid");
        Assert.assertTrue((String)"Last name should not be saved yet", (boolean)this.binder.hasChanges());
        Assert.assertFalse((String)"Binder validation should fail with pending illegal value", (boolean)this.binder.validate().isOk());
        Assert.assertNotEquals((String)"Illegal last name should not be stored to bean", (Object)((Person)this.item).getFirstName(), (Object)((Person)this.item).getLastName());
        this.nameField.setValue("Valid");
        Assert.assertFalse((String)"With new first name both changes should be saved", (boolean)this.binder.hasChanges());
        Assert.assertTrue((String)"Everything should be ok for 'Valid Invalid'", (boolean)this.binder.validate().isOk());
        Assert.assertNotEquals((String)"First name and last name should never match.", (Object)((Person)this.item).getFirstName(), (Object)((Person)this.item).getLastName());
    }

    @Test
    public void beanvalidation_initially_broken_bean() {
        TestTextField lastNameField = new TestTextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        ((Person)this.item).setLastName(((Person)this.item).getFirstName());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertFalse((boolean)this.binder.isValid());
        Assert.assertFalse((boolean)this.binder.validate().isOk());
    }

    @Test(expected=IllegalStateException.class)
    public void beanvalidation_isValid_throws_with_readBean() {
        TestTextField lastNameField = new TestTextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertTrue((boolean)this.binder.isValid());
    }

    @Test(expected=IllegalStateException.class)
    public void beanvalidation_validate_throws_with_readBean() {
        TestTextField lastNameField = new TestTextField();
        this.setBeanValidationFirstNameNotEqualsLastName(this.nameField, lastNameField);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertTrue((boolean)this.binder.validate().isOk());
    }

    protected void setBeanValidationFirstNameNotEqualsLastName(TestTextField firstNameField, TestTextField lastNameField) {
        this.binder.bind((HasValue)firstNameField, Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)lastNameField).withValidator((SerializablePredicate & Serializable)t -> !"foo".equals(t), "Last name cannot be 'foo'").bind(Person::getLastName, Person::setLastName);
        this.binder.withValidator((SerializablePredicate & Serializable)p -> !p.getFirstName().equals(p.getLastName()), "First name and last name can't be the same");
    }

    @Test
    public void info_validator_not_considered_error() {
        String infoMessage = "Young";
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).withValidator((SerializablePredicate & Serializable)i -> i > 5, infoMessage, ErrorLevel.INFO).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        this.ageField.setValue("3");
        Assert.assertEquals((Object)infoMessage, (Object)this.ageField.getErrorMessage());
        Assert.assertEquals((long)3L, (long)((Person)this.item).getAge());
    }

    @Test
    public void two_asRequired_fields_without_initial_values() {
        this.binder.forField((HasValue)this.nameField).asRequired("Empty name").bind((ValueProvider & Serializable)p -> "", (Setter & Serializable)(p, s) -> {});
        this.binder.forField((HasValue)this.ageField).asRequired("Empty age").bind((ValueProvider & Serializable)p -> "", (Setter & Serializable)(p, s) -> {});
        this.binder.setBean((Object)((Person)this.item));
        MatcherAssert.assertThat((String)"Initially there should be no errors", (Object)this.nameField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((String)"Initially there should be no errors", (Object)this.ageField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        this.nameField.setValue("Foo");
        MatcherAssert.assertThat((String)"Name with a value should not be an error", (Object)this.nameField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((String)"Age field should not be in error, since it has not been modified.", (Object)this.ageField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
        this.nameField.setValue("");
        Assert.assertNotNull((String)"Empty name should now be in error.", (Object)this.nameField.getErrorMessage());
        MatcherAssert.assertThat((String)"Age field should still be ok.", (Object)this.ageField.getErrorMessage(), (Matcher)Matchers.isEmptyString());
    }

    @Test
    public void refreshValueFromBean() {
        Binder.Binding binding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        this.nameField.setValue("foo");
        Assert.assertNotEquals((String)"Name should be different from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        binding.read((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read again from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test
    public void refreshFields_beforeSettingBean_clearsTheFields() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertEquals((String)"Name field should be empty", (Object)"", (Object)this.nameField.getValue());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        ((Person)this.item).setFirstName("bar");
        this.binder.refreshFields();
        Assert.assertEquals((String)"Name field should be cleared since bean is not set", (Object)"", (Object)this.nameField.getValue());
    }

    @Test
    public void refreshFields_afterSettingBean_readValuesfromBeanAgain() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertEquals((String)"Name field should be empty", (Object)"", (Object)this.nameField.getValue());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertEquals((String)"Name should be read from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
        this.binder.setBean((Object)((Person)this.item));
        ((Person)this.item).setFirstName("bar");
        this.binder.refreshFields();
        Assert.assertEquals((String)"Name should be read again from the item", (Object)((Person)this.item).getFirstName(), (Object)this.nameField.getValue());
    }

    @Test(expected=IllegalStateException.class)
    public void bindWithNullSetterSetReadWrite() {
        Binder.Binding binding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        binding.setReadOnly(false);
    }

    @Test
    public void bindWithNullSetterShouldMarkFieldAsReadonly() {
        Binder.Binding nameBinding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, null);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        Assert.assertTrue((String)"Name field should be readonly", (boolean)this.nameField.isReadOnly());
        Assert.assertFalse((String)"Age field should not be readonly", (boolean)this.ageField.isReadOnly());
        Assert.assertTrue((String)"Binding should be marked readonly", (boolean)nameBinding.isReadOnly());
    }

    @Test
    public void setReadOnly_binding() {
        Binder.Binding binding = this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        Assert.assertFalse((String)"Binding should not be readonly", (boolean)binding.isReadOnly());
        Assert.assertFalse((String)"Name field should not be readonly", (boolean)this.nameField.isReadOnly());
        binding.setReadOnly(true);
        Assert.assertTrue((String)"Binding should be readonly", (boolean)binding.isReadOnly());
        Assert.assertTrue((String)"Name field should be readonly", (boolean)this.nameField.isReadOnly());
    }

    @Test
    public void nonSymetricValue_setBean_writtenToBean() {
        this.binder.bind((HasValue)this.nameField, Person::getLastName, Person::setLastName);
        Assert.assertNull((Object)((Person)this.item).getLastName());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertEquals((Object)"", (Object)((Person)this.item).getLastName());
    }

    @Test
    public void nonSymmetricValue_readBean_beanNotTouched() {
        this.binder.bind((HasValue)this.nameField, Person::getLastName, Person::setLastName);
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> Assert.fail((String)"No value change event should be fired"));
        Assert.assertNull((Object)((Person)this.item).getLastName());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertNull((Object)((Person)this.item).getLastName());
    }

    @Test
    public void symetricValue_setBean_beanNotUpdated() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)new Person(){

            @Override
            public String getFirstName() {
                return "First";
            }

            @Override
            public void setFirstName(String firstName) {
                Assert.fail((String)"Setter should not be called");
            }
        });
    }

    @Test
    public void conversionWithLocaleBasedErrorMessage() {
        TestTextField ageField = new TestTextField();
        String fiError = "VIRHE";
        String otherError = "ERROR";
        StringToIntegerConverter converter = new StringToIntegerConverter((ErrorMessageProvider & Serializable)context -> context.getLocale().map(Locale::getLanguage).orElse("en").equals("fi") ? fiError : otherError);
        this.binder.forField((HasValue)ageField).withConverter((Converter)converter).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        UI testUI = new UI();
        UI.setCurrent((UI)testUI);
        testUI.add(new Component[]{ageField});
        ageField.setValue("not a number");
        Assert.assertEquals((Object)otherError, (Object)ageField.getErrorMessage());
        testUI.setLocale(new Locale("fi", "FI"));
        this.binder.validate();
        Assert.assertEquals((Object)fiError, (Object)ageField.getErrorMessage());
    }

    @Test
    public void valueChangeListenerOrder() {
        AtomicBoolean beanSet = new AtomicBoolean();
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!beanSet.get()) {
                Assert.assertEquals((String)"Value in bean updated earlier than expected", (Object)e.getOldValue(), (Object)((Person)this.item).getFirstName());
            }
        });
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!beanSet.get()) {
                Assert.assertEquals((String)"Value in bean not updated when expected", (Object)e.getValue(), (Object)((Person)this.item).getFirstName());
            }
        });
        beanSet.set(true);
        this.binder.setBean((Object)((Person)this.item));
        beanSet.set(false);
        this.nameField.setValue("Foo");
    }

    @Test
    public void nullRejetingField_nullValue_wrappedExceptionMentionsNullRepresentation() {
        TestTextField field = this.createNullRejectingFieldWithEmptyValue("");
        Binder<AtomicReference<Integer>> binder = this.createIntegerConverterBinder(field);
        this.exceptionRule.expect(IllegalStateException.class);
        this.exceptionRule.expectMessage("null representation");
        this.exceptionRule.expectCause(CoreMatchers.isA(NullPointerException.class));
        binder.readBean(new AtomicReference());
    }

    @Test
    public void nullRejetingField_otherRejectedValue_originalExceptionIsThrown() {
        TestTextField field = this.createNullRejectingFieldWithEmptyValue("");
        Binder<AtomicReference<Integer>> binder = this.createIntegerConverterBinder(field);
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("42");
        binder.readBean(new AtomicReference<Integer>(42));
    }

    @Test
    public void nullAcceptingField_nullValue_originalExceptionIsThrown() {
        TestTextField field = this.createNullRejectingFieldWithEmptyValue(null);
        Binder<AtomicReference<Integer>> binder = this.createIntegerConverterBinder(field);
        this.exceptionRule.expect(NullPointerException.class);
        binder.readBean(new AtomicReference<Object>(null));
    }

    @Test
    public void addStatusListenerFromStatusListener_listenerAdded() {
        AtomicBoolean outerListenerInvoked = new AtomicBoolean();
        AtomicBoolean innerListenerInvoked = new AtomicBoolean();
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)event -> {
            if (!outerListenerInvoked.getAndSet(true)) {
                this.binder.addStatusChangeListener((StatusChangeListener & Serializable)event2 -> innerListenerInvoked.set(true));
            }
        });
        this.binder.setBean((Object)new Person());
        Assert.assertTrue((String)"Outer listener should be invoked", (boolean)outerListenerInvoked.get());
        Assert.assertFalse((String)"Inner listener should not (yet) be invoked", (boolean)innerListenerInvoked.get());
        this.binder.setBean((Object)new Person());
        Assert.assertTrue((String)"Inner listener should be invoked", (boolean)innerListenerInvoked.get());
    }

    @Test
    public void addValueListenerFromStatusListener_listenerAdded() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        AtomicBoolean outerListenerInvoked = new AtomicBoolean();
        AtomicBoolean innerListenerInvoked = new AtomicBoolean();
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)event -> {
            if (!outerListenerInvoked.getAndSet(true)) {
                this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event2 -> innerListenerInvoked.set(true));
            }
        });
        this.binder.setBean((Object)new Person());
        Assert.assertTrue((String)"Outer listener should be invoked", (boolean)outerListenerInvoked.get());
        Assert.assertFalse((String)"Inner listener should not (yet) be invoked", (boolean)innerListenerInvoked.get());
        this.nameField.setValue("foo");
        Assert.assertTrue((String)"Inner listener should be invoked", (boolean)innerListenerInvoked.get());
    }

    @Test
    public void setBean_readOnlyBinding_propertyBinding_valueIsNotUpdated() {
        Binder binder = new Binder(ExampleBean.class);
        binder.forField((HasValue)this.nameField).withNullRepresentation((Object)"").withConverter((Converter)new TestConverter()).bind("vals").setReadOnly(true);
        ExampleBean bean = new ExampleBean();
        SubPropClass val = new SubPropClass();
        bean.setVals(val);
        binder.setBean((Object)bean);
        Assert.assertSame((Object)val, (Object)bean.getVals());
    }

    @Test
    public void setBean_readOnlyBindingMethod_propertyBinding_valueIsNotUpdated() {
        Binder binder = new Binder(ExampleBean.class);
        binder.forField((HasValue)this.nameField).withNullRepresentation((Object)"").withConverter((Converter)new TestConverter()).bindReadOnly("vals");
        ExampleBean bean = new ExampleBean();
        SubPropClass val = new SubPropClass();
        bean.setVals(val);
        binder.setBean((Object)bean);
        Assert.assertSame((Object)val, (Object)bean.getVals());
        Assert.assertTrue((boolean)this.nameField.isReadOnly());
    }

    @Test
    public void setBean_readOnlyBinding_accessorsBiding_valueIsNotUpdated() {
        Binder binder = new Binder(ExampleBean.class);
        binder.forField((HasValue)this.nameField).withNullRepresentation((Object)"").withConverter((Converter)new TestConverter()).bind(ExampleBean::getVals, ExampleBean::setVals).setReadOnly(true);
        ExampleBean bean = new ExampleBean();
        SubPropClass val = new SubPropClass();
        bean.setVals(val);
        binder.setBean((Object)bean);
        Assert.assertSame((Object)val, (Object)bean.getVals());
    }

    @Test
    public void invalidUsage_modifyFieldsInsideValidator_binderDoesNotThrow() {
        TestTextField field = new TestTextField();
        AtomicBoolean validatorIsExecuted = new AtomicBoolean();
        this.binder.forField((HasValue)field).asRequired().withValidator((Validator & Serializable)(val, context) -> {
            this.nameField.setValue("foo");
            this.ageField.setValue("bar");
            validatorIsExecuted.set(true);
            return ValidationResult.ok();
        }).bind(Person::getEmail, Person::setEmail);
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).bind(Person::getLastName, Person::setLastName);
        this.binder.setBean((Object)new Person());
        field.setValue("baz");
        Assert.assertTrue((boolean)validatorIsExecuted.get());
    }

    @Test
    public void validationShouldNotRunTwice() {
        TestTextField salaryField = new TestTextField();
        AtomicInteger count = new AtomicInteger(0);
        ((Person)this.item).setSalaryDouble(100.0);
        this.binder.forField((HasValue)salaryField).withConverter((Converter)new StringToDoubleConverter("")).bind(Person::getSalaryDouble, Person::setSalaryDouble);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> count.incrementAndGet());
        salaryField.setValue("1000");
        Assert.assertTrue((boolean)this.binder.isValid());
        Assert.assertEquals((long)1L, (long)count.get());
        salaryField.setValue("salary");
        Assert.assertFalse((boolean)this.binder.isValid());
        Assert.assertEquals((long)2L, (long)count.get());
        salaryField.setValue("2000");
        Assert.assertEquals((long)3L, (long)count.get());
        Assert.assertEquals((Object)new Double(2000.0), (Object)((Person)this.item).getSalaryDouble());
    }

    @Test
    public void validationShouldNotRunTwiceWhenWriting() {
        TestTextField nameField = new TestTextField();
        AtomicInteger count = new AtomicInteger(0);
        this.binder.forField((HasValue)nameField).withValidator((Validator & Serializable)(value, context) -> {
            count.incrementAndGet();
            if (value.equals("Mike")) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"value must be Mike");
        }).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)((Person)this.item));
        nameField.setValue("Mike");
        Assert.assertEquals((String)"Validation should be run only once for value change", (long)1L, (long)count.get());
        try {
            this.binder.writeBean((Object)((Person)this.item));
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Validation should be run only once for writing the bean", (long)2L, (long)count.get());
    }

    @Test
    public void setValidationErrorHandler_handlerIsSet_handlerMethodsAreCalled() {
        final TestTextField testField = new TestTextField();
        class TestErrorHandler
        implements BinderValidationErrorHandler {
            private ValidationResult result;
            private boolean clearIsCalled;

            TestErrorHandler() {
            }

            public void handleError(HasValue<?, ?> field, ValidationResult result) {
                Assert.assertSame((Object)((Object)testField), field);
                this.result = result;
                this.clearIsCalled = false;
            }

            public void clearError(HasValue<?, ?> field) {
                Assert.assertSame((Object)((Object)testField), field);
                this.result = null;
                this.clearIsCalled = true;
            }
        }
        TestErrorHandler handler = new TestErrorHandler();
        this.binder.setValidationErrorHandler((BinderValidationErrorHandler)handler);
        this.binder.forField((HasValue)testField).asRequired().withValidator((Validator & Serializable)(val, context) -> {
            if ("bar".equals(val)) {
                return ValidationResult.error((String)"foo");
            }
            return ValidationResult.ok();
        }).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)new Person());
        testField.setValue("bar");
        Assert.assertTrue((boolean)handler.result.isError());
        Assert.assertFalse((boolean)handler.clearIsCalled);
        testField.setValue("foo");
        Assert.assertNull((Object)handler.result);
        Assert.assertTrue((boolean)handler.clearIsCalled);
        Assert.assertSame((Object)handler, (Object)this.binder.getValidationErrorHandler());
    }

    @Test(expected=BindingException.class)
    public void readBean_converterThrows_readBean_exceptionHandlerSet_bindingExceptionIsThrown() {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).withConverter(Converter.from((SerializableFunction & Serializable)name -> Result.ok((Object)name), (SerializableFunction & Serializable)name -> {
            throw new NullPointerException();
        })).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void readBean_getterThrows_exceptionHandlerSet_bindingExceptionIsThrown() {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).bind((ValueProvider & Serializable)person -> {
            throw new NullPointerException();
        }, Person::setFirstName);
        this.binder.readBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void setBean_converterThrows_setBean_exceptionHandlerSet_bindingExceptionIsThrown() {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).withConverter(Converter.from((SerializableFunction & Serializable)name -> {
            throw new NullPointerException();
        }, (SerializableFunction & Serializable)name -> name)).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void setBean_setterThrows_exceptionHandlerSet_bindingExceptionIsThrown() {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).bind(Person::getFirstName, (Setter & Serializable)(person, field) -> {
            throw new NullPointerException();
        });
        this.binder.setBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void setBean_setValueThrows_exceptionHandlerSet_bindingExceptionIsThrown() {
        ThrowingSetter testField = new ThrowingSetter();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void writeBean_converterThrows_exceptionHandlerSet_bindingExceptionIsThrown() throws ValidationException {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).withConverter(Converter.from((SerializableFunction & Serializable)name -> {
            throw new NullPointerException();
        }, (SerializableFunction & Serializable)name -> name)).bind(Person::getFirstName, Person::setFirstName);
        this.binder.writeBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void writeBean_setterThrows_exceptionHandlerSet_bindingExceptionIsThrown() throws ValidationException {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).bind(Person::getFirstName, (Setter & Serializable)(person, field) -> {
            throw new NullPointerException();
        });
        Person person2 = new Person();
        person2.setFirstName("foo");
        this.binder.writeBean((Object)person2);
    }

    @Test(expected=BindingException.class)
    public void writeBean_setValueThrows_exceptionHandlerSet_bindingExceptionIsThrown() throws ValidationException {
        ThrowingSetter testField = new ThrowingSetter();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).withConverter(Converter.from((SerializableFunction & Serializable)name -> Result.ok((Object)name), (SerializableFunction & Serializable)name -> "foo")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.writeBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void writeBean_getValueThrows_exceptionHandlerSet_bindingExceptionIsThrown() throws ValidationException {
        ThrowingGetter testField = new ThrowingGetter();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.writeBean((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void readBean_converterThrows_exceptionHandlerSet_bindingExceptionIsThrown() {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).withConverter(Converter.from((SerializableFunction & Serializable)name -> {
            throw new NullPointerException();
        }, (SerializableFunction & Serializable)name -> name)).bind(Person::getFirstName, Person::setFirstName).read((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void bindingReadBean_setValueThrows_exceptionHandlerSet_bindingExceptionIsThrown() {
        ThrowingSetter testField = new ThrowingSetter();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).bind(Person::getFirstName, Person::setFirstName).read((Object)new Person());
    }

    @Test(expected=BindingException.class)
    public void bindingReadBean_converterThrows_exceptionHandlerSet_bindingExceptionIsThrown() {
        TestTextField testField = new TestTextField();
        this.setExceptionHandler();
        this.binder.forField((HasValue)testField).withConverter(Converter.from((SerializableFunction & Serializable)name -> Result.ok((Object)name), (SerializableFunction & Serializable)name -> {
            throw new NullPointerException();
        })).bind(Person::getFirstName, Person::setFirstName).read((Object)new Person());
    }

    @Test
    public void getBindingExceptionHandler_defaultHandlerIsReturned() {
        BindingExceptionHandler exceptionHandler = this.binder.getBindingExceptionHandler();
        Assert.assertTrue((boolean)(exceptionHandler instanceof DefaultBindingExceptionHandler));
    }

    private void setExceptionHandler() {
        BindingException bindingException = new BindingException("foo");
        this.binder.setBindingExceptionHandler((BindingExceptionHandler & Serializable)(field, exception) -> Optional.of(bindingException));
    }

    @Test
    public void withConverter_hasChangesFalse() {
        TestTextField nameField = new TestTextField();
        nameField.setValue("");
        TestTextField rentField = new TestTextField();
        rentField.setValue("");
        rentField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> nameField.setValue("Name"));
        ((Person)this.item).setRent(BigDecimal.valueOf(10L));
        this.binder.forField((HasValue)nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)rentField).withConverter((Converter)new EuroConverter("")).withNullRepresentation((Object)BigDecimal.valueOf(0.0)).bind(Person::getRent, Person::setRent);
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertFalse((boolean)this.binder.hasChanges());
        Assert.assertEquals((Object)"\u20ac 10.00", (Object)rentField.getValue());
        Assert.assertEquals((Object)"Name", (Object)nameField.getValue());
    }

    private TestTextField createNullRejectingFieldWithEmptyValue(final String emptyValue) {
        return new TestTextField(){

            public void setValue(String value) {
                if (value == null) {
                    throw new NullPointerException("Null value");
                }
                if ("42".equals(value)) {
                    throw new IllegalArgumentException("42 is not allowed");
                }
                super.setValue((Object)value);
            }

            public String getEmptyValue() {
                return emptyValue;
            }
        };
    }

    private Binder<AtomicReference<Integer>> createIntegerConverterBinder(TestTextField field) {
        Binder binder = new Binder();
        binder.forField((HasValue)field).withConverter((Converter)new StringToIntegerConverter("Must have number")).bind(AtomicReference::get, AtomicReference::set);
        return binder;
    }

    private static class ThrowingGetter
    extends TestTextField {
        private ThrowingGetter() {
        }

        public String getValue() {
            throw new NullPointerException();
        }
    }

    private static class ThrowingSetter
    extends TestTextField {
        private ThrowingSetter() {
        }

        public void setValue(String value) {
            throw new NullPointerException();
        }
    }

    public class EuroConverter
    extends StringToBigDecimalConverter {
        public EuroConverter() {
            super("defaultErrorMessage");
        }

        public EuroConverter(String errorMessage) {
            super(errorMessage);
        }

        public Result<BigDecimal> convertToModel(String value, ValueContext context) {
            if (value.isEmpty()) {
                return Result.ok(null);
            }
            if ((value = value.replaceAll("[\u20ac\\s]", "").trim()).isEmpty()) {
                value = "0";
            }
            return super.convertToModel(value, context);
        }

        public String convertToPresentation(BigDecimal value, ValueContext context) {
            if (value == null) {
                return this.convertToPresentation(BigDecimal.ZERO, context);
            }
            return "\u20ac " + super.convertToPresentation((Number)value, context);
        }

        protected NumberFormat getFormat(Locale locale) {
            NumberFormat format = super.getFormat(Locale.ENGLISH);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setMaximumFractionDigits(2);
                ((DecimalFormat)format).setMinimumFractionDigits(2);
            }
            return format;
        }
    }

    public static class TestConverter
    implements Converter<String, SubPropClass> {
        public Result<SubPropClass> convertToModel(String value, ValueContext context) {
            return Result.ok(null);
        }

        public String convertToPresentation(SubPropClass value, ValueContext context) {
            return value != null ? value.toString() : null;
        }
    }

    public static class SubPropClass
    implements Serializable {
        private String val1 = "Val1";

        public String toString() {
            return this.val1;
        }
    }

    public static class ExampleBean
    implements Serializable {
        private SubPropClass vals;

        public SubPropClass getVals() {
            return this.vals;
        }

        public void setVals(SubPropClass vals) {
            this.vals = vals;
        }
    }

    static class MyBindingHandler
    implements BindingValidationStatusHandler {
        boolean expectingError = false;
        int callCount = 0;

        MyBindingHandler() {
        }

        public void statusChange(BindingValidationStatus<?> statusChange) {
            ++this.callCount;
            if (this.expectingError) {
                Assert.assertTrue((String)"Expecting error", (boolean)statusChange.isError());
            } else {
                Assert.assertFalse((String)"Unexpected error", (boolean)statusChange.isError());
            }
        }
    }
}

