/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class ValueContext
implements Serializable {
    private final Component component;
    private final HasValue<?, ?> hasValue;
    private final Locale locale;

    public ValueContext() {
        this.component = null;
        this.hasValue = null;
        this.locale = this.findLocale(this.component);
    }

    public ValueContext(Locale locale) {
        this.component = null;
        this.locale = locale;
        this.hasValue = null;
    }

    public ValueContext(Component component) {
        Objects.requireNonNull(component, "Component can't be null in ValueContext construction");
        this.component = component;
        this.hasValue = component instanceof HasValue ? (HasValue)component : null;
        this.locale = this.findLocale(component);
    }

    public ValueContext(Component component, HasValue<?, ?> hasValue) {
        Objects.requireNonNull(component, "Component can't be null in ValueContext construction");
        this.component = component;
        this.hasValue = hasValue;
        this.locale = this.findLocale(component);
    }

    public ValueContext(Component component, HasValue<?, ?> hasValue, Locale locale) {
        this.component = component;
        this.hasValue = hasValue;
        this.locale = locale;
    }

    private Locale findLocale(Component component) {
        if (component != null && component.getUI().isPresent()) {
            return ((UI)component.getUI().get()).getLocale();
        }
        Locale locale = null;
        if (UI.getCurrent() != null) {
            locale = UI.getCurrent().getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public Optional<Component> getComponent() {
        return Optional.ofNullable(this.component);
    }

    public Optional<Locale> getLocale() {
        return Optional.ofNullable(this.locale);
    }

    public Optional<HasValue<?, ?>> getHasValue() {
        return Optional.ofNullable(this.hasValue);
    }
}

