/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.hierarchy.HierarchyMapper;
import com.vaadin.flow.data.provider.hierarchy.HierarchyMapperWithDataTest;
import com.vaadin.flow.data.provider.hierarchy.Node;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.Range;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HierarchyMapperWithNumerousDataTest {
    private static final int ROOT_COUNT = 1;
    private static final int PARENT_COUNT = 100000;
    private static TreeData<Node> data = new TreeData();
    private TreeDataProvider<Node> provider;
    private HierarchyMapper<Node, SerializablePredicate<Node>> mapper;
    private static List<Node> testData;
    private static List<Node> roots;
    private int mapSize = 1;

    @BeforeClass
    public static void setupData() {
        testData = HierarchyMapperWithDataTest.generateTestData(1, 100000, 0);
        roots = testData.stream().filter(item -> item.getParent() == null).collect(Collectors.toList());
        data.addItems(roots, (ValueProvider & Serializable)parent -> testData.stream().filter(item -> Objects.equals(item.getParent(), parent)).collect(Collectors.toList()));
    }

    @Before
    public void setup() {
        this.provider = new TreeDataProvider(data);
        this.mapper = new HierarchyMapper(this.provider);
    }

    @Test(timeout=1000L)
    public void expandRootNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)1L, (long)this.mapper.getTreeSize());
        this.expand(testData.get(0));
        Assert.assertEquals((String)"Should be root count + once parent count", (long)100001L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    private void expand(Node node) {
        this.insertRows(this.mapper.expand((Object)node, (Integer)this.mapper.getIndexOf((Object)node).orElse(null)));
    }

    public void insertRows(Range range) {
        Assert.assertTrue((String)"Index not in range", (0 <= range.getStart() && range.getStart() <= this.mapSize ? 1 : 0) != 0);
        this.mapSize += range.length();
    }

    private void checkMapSize() {
        Assert.assertEquals((String)"Map size not properly updated", (long)this.mapper.getTreeSize(), (long)this.mapSize);
    }
}

