/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.RendererUtil;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class RendererUtilTest {
    @Test
    public void registerEventHandlers_elementsAreAlreadyAttached_setupEvenHandlers() {
        TestUI ui = new TestUI();
        Element contentTemplate = new Element("div");
        Element templateDataHost = new Element("span");
        this.attachElements(ui, contentTemplate, templateDataHost);
        TestUIInternals internals = (TestUIInternals)ui.getInternals();
        Renderer renderer = new Renderer();
        renderer.setEventHandler("foo", (SerializableConsumer & Serializable)value -> {});
        RendererUtil.registerEventHandlers((Renderer)renderer, (Element)contentTemplate, (Element)templateDataHost, (ValueProvider)ValueProvider.identity());
        this.assertJSExecutions(ui, internals, contentTemplate, templateDataHost);
    }

    @Test
    public void registerEventHandlers_setupEvenHandlersOnAttach() {
        TestUI ui = new TestUI();
        TestUIInternals internals = (TestUIInternals)ui.getInternals();
        Renderer renderer = new Renderer();
        renderer.setEventHandler("foo", (SerializableConsumer & Serializable)value -> {});
        Element contentTemplate = new Element("div");
        Element templateDataHost = new Element("span");
        RendererUtil.registerEventHandlers((Renderer)renderer, (Element)contentTemplate, (Element)templateDataHost, (ValueProvider)ValueProvider.identity());
        this.attachElements(ui, contentTemplate, templateDataHost);
        this.assertJSExecutions(ui, internals, contentTemplate, templateDataHost);
        ui.getElement().removeAllChildren();
        internals.invocations.clear();
        this.attachElements(ui, contentTemplate, templateDataHost);
        this.assertJSExecutions(ui, internals, contentTemplate, templateDataHost);
    }

    @Test
    public void registerEventHandlers_attachMultipleTimes_singleEventListenerRegistered() {
        TestUI ui = new TestUI();
        TestUIInternals internals = (TestUIInternals)ui.getInternals();
        Renderer renderer = new Renderer();
        AtomicInteger eventCounter = new AtomicInteger(0);
        renderer.setEventHandler("foo", (SerializableConsumer & Serializable)value -> eventCounter.getAndIncrement());
        Element contentTemplate = new Element("div");
        Element templateDataHost = new Element("span");
        RendererUtil.registerEventHandlers((Renderer)renderer, (Element)contentTemplate, (Element)templateDataHost, (ValueProvider)ValueProvider.identity());
        this.attachElements(ui, contentTemplate, templateDataHost);
        this.attachElements(ui, contentTemplate, templateDataHost);
        internals.getStateTree().runExecutionsBeforeClientResponse();
        JsonObject eventData = Json.createObject();
        eventData.put("key", "");
        ((ElementListenerMap)templateDataHost.getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(templateDataHost, "foo", eventData));
        Assert.assertEquals((long)1L, (long)eventCounter.get());
    }

    private void attachElements(UI ui, Element contentTemplate, Element templateDataHost) {
        ui.getElement().appendChild(new Element[]{contentTemplate});
        ui.getElement().appendChild(new Element[]{templateDataHost});
    }

    private void assertJSExecutions(UI ui, TestUIInternals internals, Element contentTemplate, Element templateDataHost) {
        internals.getStateTree().runExecutionsBeforeClientResponse();
        Assert.assertEquals((long)2L, (long)internals.invocations.size());
        UIInternals.JavaScriptInvocation invocation = ((PendingJavaScriptInvocation)internals.invocations.get(0)).getInvocation();
        HashSet<String> expressons = new HashSet<String>();
        expressons.add(invocation.getExpression());
        expressons.add(((PendingJavaScriptInvocation)internals.invocations.get(1)).getInvocation().getExpression());
        Assert.assertTrue((String)"The javascript executions don't contain dataHost assignement", (boolean)expressons.remove("$0.__dataHost = $1;"));
        Assert.assertEquals((Object)("$0.foo = function(e) {Vaadin.Flow.clients[$1].sendEventMessage(" + templateDataHost.getNode().getId() + ", 'foo', {key: e.model ? e.model.__data.item.key : e.target.__dataHost.__data.item.key})}"), expressons.iterator().next());
    }

    private static class TestUI
    extends UI {
        private UIInternals internals;

        private TestUI() {
        }

        public UIInternals getInternals() {
            if (this.internals == null) {
                this.internals = new TestUIInternals(this);
            }
            return this.internals;
        }
    }

    private static class TestUIInternals
    extends UIInternals {
        private List<PendingJavaScriptInvocation> invocations = new ArrayList<PendingJavaScriptInvocation>();

        public TestUIInternals(UI ui) {
            super(ui);
        }

        public void addJavaScriptInvocation(PendingJavaScriptInvocation invocation) {
            this.invocations.add(invocation);
        }
    }
}

