/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderTestBase;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.tests.data.bean.Person;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderValueChangeTest
extends BinderTestBase<Binder<Person>, Person> {
    private Map<HasValue<?, ?>, String> componentErrors = new HashMap();
    private AtomicReference<HasValue.ValueChangeEvent<?>> event;

    @Before
    public void setUp() {
        this.binder = new Binder<Person>(){

            protected void handleError(HasValue<?, ?> field, ValidationResult result) {
                BinderValueChangeTest.this.componentErrors.put(field, result.getErrorMessage());
            }

            protected void clearError(HasValue<?, ?> field) {
                super.clearError(field);
                BinderValueChangeTest.this.componentErrors.remove(field);
            }
        };
        this.item = new Person();
        this.event = new AtomicReference();
    }

    @Test
    public void unboundField_noEvents() {
        this.binder.addValueChangeListener(this::statusChanged);
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        this.nameField.setValue("");
        Assert.assertNull(this.event.get());
        binding.bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull(this.event.get());
    }

    @Test
    public void setBean_unbound_noEvents() {
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.binder.setBean(this.item);
        Assert.assertNull(this.event.get());
    }

    @Test
    public void readBean_unbound_noEvents() {
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.binder.readBean(this.item);
        Assert.assertNull(this.event.get());
    }

    @Test
    public void setValue_unbound_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent((HasValue<?, ?>)this.nameField);
    }

    @Test
    public void setValue_bound_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean(this.item);
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent((HasValue<?, ?>)this.nameField);
    }

    @Test
    public void userOriginatedUpdate_unbound_singleEventOnSetValue() {
        TestTextField field = new TestTextField();
        this.binder.forField((HasValue)field).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        ((ElementPropertyMap)field.getElement().getNode().getFeature(ElementPropertyMap.class)).setProperty("value", (Serializable)((Object)"foo"), false);
        this.verifyEvent((HasValue<?, ?>)field, true);
    }

    @Test
    public void addListenerFirst_bound_singleEventOnSetValue() {
        this.binder.addValueChangeListener(this::statusChanged);
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean(this.item);
        Assert.assertNull(this.event.get());
        this.ageField.setValue(String.valueOf(1));
        this.verifyEvent((HasValue<?, ?>)this.ageField);
    }

    private void verifyEvent(HasValue<?, ?> field) {
        this.verifyEvent(field, false);
    }

    private void verifyEvent(HasValue<?, ?> field, boolean isUserOriginated) {
        HasValue.ValueChangeEvent<?> changeEvent = this.event.get();
        Assert.assertNotNull(changeEvent);
        Assert.assertEquals(field, (Object)changeEvent.getHasValue());
        Assert.assertEquals((Object)isUserOriginated, (Object)changeEvent.isFromClient());
    }

    private void statusChanged(HasValue.ValueChangeEvent<?> evt) {
        Assert.assertNull(this.event.get());
        this.event.set(evt);
    }
}

