/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.BeanValidationBinder;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.internal.BeanUtil;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.tests.data.bean.BeanToValidate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.validation.Validation;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class Jsr303Test {
    @Test
    public void beanBinderWithoutJsr303() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, InterruptedException {
        try (TestClassLoader loader = new TestClassLoader();){
            Class<?> clazz = ((ClassLoader)loader).loadClass(Jsr303UnitTest.class.getName());
            UnitTest test = (UnitTest)clazz.newInstance();
            test.execute();
        }
    }

    public static class Jsr303UnitTest
    implements UnitTest {
        private final TestTextField nameField = new TestTextField();

        @Override
        public void execute() {
            Assert.assertFalse((boolean)BeanUtil.checkBeanValidationAvailable());
            Binder binder = new Binder(BeanToValidate.class);
            BeanToValidate item = new BeanToValidate();
            String name = "Johannes";
            item.setFirstname(name);
            item.setAge(32);
            binder.bind((HasValue)this.nameField, "firstname");
            binder.setBean((Object)item);
            Assert.assertEquals((Object)name, (Object)this.nameField.getValue());
            this.nameField.setValue("a");
            Assert.assertEquals((Object)this.nameField.getValue(), (Object)item.getFirstname());
            try {
                BeanValidationBinder beanValidationBinder = new BeanValidationBinder(BeanToValidate.class);
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static interface UnitTest {
        public void execute();
    }

    private static class TestClassLoader
    extends URLClassLoader {
        public TestClassLoader() {
            super(new URL[0], Thread.currentThread().getContextClassLoader());
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            String vaadinPackagePrefix = VaadinServlet.class.getPackage().getName();
            vaadinPackagePrefix = vaadinPackagePrefix.substring(0, vaadinPackagePrefix.lastIndexOf(46));
            if (name.equals(UnitTest.class.getName())) {
                super.loadClass(name);
            } else {
                if (name.startsWith(Validation.class.getPackage().getName())) {
                    throw new ClassNotFoundException();
                }
                if (name.startsWith(vaadinPackagePrefix)) {
                    String path = name.replace('.', '/').concat(".class");
                    URL resource = Thread.currentThread().getContextClassLoader().getResource(path);
                    try {
                        InputStream stream = resource.openStream();
                        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                        return this.defineClass(name, bytes, 0, bytes.length);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return super.loadClass(name);
        }
    }
}

