/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.value;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import java.util.EnumSet;
import org.junit.Assert;
import org.junit.Test;

public class ValueChangeModeTest {
    @Test
    public void field_setMode() {
        ValueChangeModeField field = new ValueChangeModeField();
        field.setValueChangeMode(ValueChangeMode.ON_BLUR);
        this.assertValueSynchronizedWithEvent(field, "blur");
        field.setValueChangeMode(null);
        Assert.assertNull((String)"value should not be a synchronized property", (Object)this.getDisabledUpdateMode(field));
        Assert.assertNull((Object)field.getSynchronizationRegistration());
        field.setValueChangeMode(ValueChangeMode.EAGER);
        this.assertValueSynchronizedWithEvent(field, "value-changed");
        field.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.assertValueSynchronizedWithEvent(field, "change");
        field.setValueChangeMode(ValueChangeMode.LAZY);
        this.assertValueSynchronizedWithEvent(field, "value-changed");
        field.setValueChangeMode(ValueChangeMode.TIMEOUT);
        this.assertValueSynchronizedWithEvent(field, "value-changed");
    }

    @Test
    public void field_setValueChangeTimeout_applied() {
        ValueChangeModeField field = new ValueChangeModeField();
        this.assertDebounceDisabled(field);
        field.setValueChangeMode(ValueChangeMode.LAZY);
        this.assertDebounceDisabled(field);
        field.setValueChangeTimeout(123);
        this.assertDebounceEquals(field, EnumSet.of(DebouncePhase.TRAILING), 123);
        field.setValueChangeMode(ValueChangeMode.TIMEOUT);
        this.assertDebounceEquals(field, EnumSet.of(DebouncePhase.LEADING, DebouncePhase.INTERMEDIATE), 123);
        field.setValueChangeTimeout(456);
        this.assertDebounceEquals(field, EnumSet.of(DebouncePhase.LEADING, DebouncePhase.INTERMEDIATE), 456);
    }

    @Test
    public void field_setValueChangeTimeout_ignored() {
        this.assertNoTimeoutApplied(ValueChangeMode.EAGER);
        this.assertNoTimeoutApplied(ValueChangeMode.ON_CHANGE);
        this.assertNoTimeoutApplied(ValueChangeMode.ON_BLUR);
    }

    private void assertNoTimeoutApplied(ValueChangeMode valueChangeMode) {
        ValueChangeModeField field = new ValueChangeModeField();
        field.setValueChangeMode(valueChangeMode);
        this.assertDebounceDisabled(field);
    }

    private void assertDebounceEquals(ValueChangeModeField field, EnumSet<DebouncePhase> phases, int timeout) {
        DomListenerRegistration reg = field.getSynchronizationRegistration();
        Assert.assertEquals((long)timeout, (long)reg.getDebounceTimeout());
        Assert.assertEquals(phases, (Object)reg.getDebouncePhases());
    }

    private void assertDebounceDisabled(ValueChangeModeField field) {
        Assert.assertEquals((long)0L, (long)field.getSynchronizationRegistration().getDebounceTimeout());
    }

    private void assertValueSynchronizedWithEvent(ValueChangeModeField field, String eventName) {
        Assert.assertNotNull((String)"value should be a synchronized property", (Object)this.getDisabledUpdateMode(field));
        DomListenerRegistration reg = field.getSynchronizationRegistration();
        Assert.assertEquals((String)(eventName + " should be the synchronized property-event"), (Object)eventName, (Object)reg.getEventType());
    }

    private DisabledUpdateMode getDisabledUpdateMode(ValueChangeModeField field) {
        return ((ElementListenerMap)field.getElement().getNode().getFeature(ElementListenerMap.class)).getPropertySynchronizationMode("value");
    }

    @Tag(value="tag")
    private static class ValueChangeModeField
    extends AbstractSinglePropertyField<ValueChangeModeField, String>
    implements HasValueChangeMode {
        private ValueChangeMode valueChangeMode;
        private int valueChangeTimeout;

        public ValueChangeModeField() {
            super("value", (Object)"", false);
        }

        public void setValueChangeMode(ValueChangeMode valueChangeMode) {
            this.valueChangeMode = valueChangeMode;
            this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
            this.setValueChangeTimeout(this.valueChangeTimeout);
        }

        public ValueChangeMode getValueChangeMode() {
            return this.valueChangeMode;
        }

        public void setValueChangeTimeout(int valueChangeTimeout) {
            this.valueChangeTimeout = valueChangeTimeout;
            ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.valueChangeMode, (int)this.valueChangeTimeout, (DomListenerRegistration)this.getSynchronizationRegistration());
        }

        public int getValueChangeTimeout() {
            return this.valueChangeTimeout;
        }

        public DomListenerRegistration getSynchronizationRegistration() {
            return super.getSynchronizationRegistration();
        }
    }
}

