/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProviderTestBase;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.provider.SortOrder;
import com.vaadin.flow.data.provider.StrBean;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BackendDataProviderTest
extends DataProviderTestBase<BackEndDataProvider<StrBean, SerializablePredicate<StrBean>>> {
    private static Map<String, Comparator<StrBean>> propertyToComparatorMap = new HashMap<String, Comparator<StrBean>>();

    private static Comparator<StrBean> getComparator(SortOrder<String> so) {
        Comparator<StrBean> comparator = propertyToComparatorMap.get(so.getSorted());
        if (so.getDirection() == SortDirection.DESCENDING) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    @Override
    protected BackEndDataProvider<StrBean, SerializablePredicate<StrBean>> createDataProvider() {
        this.dataProvider = new StrBeanBackEndDataProvider(this.data);
        return (BackEndDataProvider)this.dataProvider;
    }

    @Override
    protected void setSortOrder(List<QuerySortOrder> sortOrder, Comparator<StrBean> comp) {
        ((BackEndDataProvider)this.getDataProvider()).setSortOrders(sortOrder);
    }

    static {
        propertyToComparatorMap.put("value", Comparator.comparing(StrBean::getValue));
        propertyToComparatorMap.put("id", Comparator.comparing(StrBean::getId));
        propertyToComparatorMap.put("randomNumber", Comparator.comparing(StrBean::getRandomNumber));
    }

    public static class StrBeanBackEndDataProvider
    extends CallbackDataProvider<StrBean, SerializablePredicate<StrBean>> {
        public StrBeanBackEndDataProvider(List<StrBean> data) {
            super((CallbackDataProvider.FetchCallback & Serializable)query -> {
                Stream<StrBean> stream = data.stream().filter(t -> ((SerializablePredicate)query.getFilter().orElse((SerializablePredicate & Serializable)s -> true)).test(t));
                if (!query.getSortOrders().isEmpty()) {
                    Comparator sorting = query.getSortOrders().stream().map(x$0 -> BackendDataProviderTest.getComparator((SortOrder<String>)x$0)).reduce((c1, c2) -> c1.thenComparing(c2)).get();
                    stream = stream.sorted(sorting);
                }
                List list = stream.skip(query.getOffset()).limit(query.getLimit()).collect(Collectors.toList());
                return list.stream();
            }, (CallbackDataProvider.CountCallback & Serializable)query -> (int)data.stream().filter(t -> ((SerializablePredicate)query.getFilter().orElse((SerializablePredicate & Serializable)s -> true)).test(t)).count());
        }
    }
}

