/**
 * Copyright (C) 2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See {@literal <https://vaadin.com/commercial-license-and-service-terms>}  for the full
 * license.
 */
package com.vaadin.flow.data.converter;

import java.io.Serializable;
import java.util.Optional;

/**
 * Creates {@link Converter} instances capable to handle conversion between a
 * model and a presentation type.
 *
 * @author Vaadin Ltd
 * @since
 */
public interface ConverterFactory extends Serializable {

    /**
     * Attempts to create a {@link Converter} instance, capable to handle
     * conversion between the given presentation and model types.
     *
     * An empty {@link Optional} is returned if a conversion cannot be
     * performed.
     *
     * @param presentationType
     *            presentation type, not {@literal null}.
     * @param modelType
     *            model type, not {@literal null}.
     * @param <P>
     *            The presentation type.
     * @param <M>
     *            The model type.
     * @return a {@link Converter} instance wrapped into an {@link Optional}, or
     *         an empty {@link Optional} if no suitable converter is available.
     */
    <P, M> Optional<Converter<P, M>> newInstance(Class<P> presentationType,
            Class<M> modelType);
}
