/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.demo;

import java.io.File;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class ComponentDemoServer {
    private static final String WEB_APP_PATH = "webapp";
    private static final String TEST_CLASSES_PATH = ".*/target/test-classes/";
    private static final String JAR_PATTERN = ".*\\.jar$";

    public Server startServer() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(this.getPort());
        server.setConnectors(new Connector[]{connector});
        WebAppContext context = new WebAppContext();
        File file = new File(WEB_APP_PATH);
        if (!file.exists()) {
            try {
                if (!file.mkdirs()) {
                    throw new RuntimeException("Failed to create the following directory for webapp: webapp");
                }
            }
            catch (SecurityException exception) {
                throw new RuntimeException("Failed to create the following directory for webapp: webapp", exception);
            }
        }
        context.setWar(file.getPath());
        context.setContextPath("/");
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)server);
        classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/target/test-classes/|.*\\.jar$");
        this.configure(context, server);
        server.setHandler((Handler)context);
        server.start();
        return server;
    }

    protected int getPort() {
        return 9998;
    }

    protected void configure(WebAppContext context, Server server) {
    }
}

