/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.demo;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.demo.Card;
import com.vaadin.flow.demo.DemoNavigationBar;
import com.vaadin.flow.demo.SourceCodeExample;
import com.vaadin.flow.demo.SourceContent;
import com.vaadin.flow.demo.SourceContentResolver;
import com.vaadin.flow.demo.WhenDefinedManager;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.lumo.Lumo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Tag(value="div")
@Theme(value=Lumo.class)
@StyleSheet.Container(value={@StyleSheet(value="src/css/demo.css"), @StyleSheet(value="src/css/prism.css")})
public abstract class DemoView
extends Component
implements HasComponents,
HasUrlParameter<String>,
HasStyle {
    static final String VARIANT_TOGGLE_BUTTONS_DIV_ID = "variantToggleButtonsDiv";
    static final String COMPONENT_WITH_VARIANTS_ID = "componentWithVariantsDemo";
    private final DemoNavigationBar navBar = new DemoNavigationBar();
    private final Div container = new Div();
    private final Map<String, Div> tabComponents = new HashMap<String, Div>();
    private final Map<String, List<SourceCodeExample>> sourceCodeExamples = new HashMap<String, List<SourceCodeExample>>();

    protected DemoView() {
        Route annotation = ((Object)((Object)this)).getClass().getAnnotation(Route.class);
        if (annotation == null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " should be annotated with @" + Route.class.getName() + " to be a valid view");
        }
        this.addClassName("demo-view");
        this.navBar.addClassName("demo-nav");
        super.add(new Component[]{this.navBar});
        super.add(new Component[]{this.container});
        this.populateSources();
        this.initView();
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.tabComponents.size() <= 1) {
            this.remove(new Component[]{this.navBar});
        }
    }

    protected abstract void initView();

    public void populateSources() {
        SourceContentResolver.getSourceCodeExamplesForClass(((Object)((Object)this)).getClass()).forEach(this::putSourceCode);
    }

    private void putSourceCode(SourceCodeExample example) {
        String heading = example.getHeading();
        List list = this.sourceCodeExamples.computeIfAbsent(heading, key -> new ArrayList());
        list.add(example);
    }

    public Card addCard(String heading, Component ... components) {
        return this.addCard("Basic usage", "", heading, components);
    }

    public Card addCard(String tabName, String heading, Component ... components) {
        String tabUrl = tabName.toLowerCase().replaceAll("[\\W]", "-");
        return this.addCard(tabName, tabUrl, heading, components);
    }

    private Card addCard(String tabName, String tabUrl, String heading, Component ... components) {
        Div tab = this.tabComponents.computeIfAbsent(tabUrl, url -> {
            this.navBar.addLink(tabName, this.getTabUrl(tabUrl));
            return new Div();
        });
        if (heading != null && !heading.isEmpty()) {
            tab.add(new Component[]{new H3(heading)});
        }
        Card card = new Card();
        card.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> WhenDefinedManager.get(ui).whenDefined(components, (Command & Serializable)() -> {
            List<SourceCodeExample> list;
            if (components != null && components.length > 0) {
                card.add(components);
            }
            if ((list = this.sourceCodeExamples.get(heading)) != null) {
                list.stream().map(this::createSourceContent).forEach(xva$0 -> card.add((Component)xva$0));
            }
        }));
        tab.add(new Component[]{card});
        return card;
    }

    private String getTabUrl(String relativeHref) {
        String href = relativeHref == null || relativeHref.isEmpty() ? "" : "/" + relativeHref;
        return ((Object)((Object)this)).getClass().getAnnotation(Route.class).value() + href;
    }

    private SourceContent createSourceContent(SourceCodeExample sourceCodeExample) {
        SourceContent content = new SourceContent();
        String sourceString = sourceCodeExample.getSourceCode();
        switch (sourceCodeExample.getSourceType()) {
            case CSS: {
                content.addCss(sourceString);
                break;
            }
            case JAVA: {
                content.addCode(sourceString);
                break;
            }
            case HTML: {
                content.addHtml(sourceString);
                break;
            }
            default: {
                content.addCode(sourceString);
            }
        }
        return content;
    }

    private void showTab(String tabUrl) {
        Div tab = this.tabComponents.get(tabUrl);
        if (tab != null) {
            this.container.removeAll();
            this.container.add(new Component[]{tab});
            this.navBar.setActive(this.getTabUrl(tabUrl));
        }
    }

    public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        this.showTab(parameter == null ? "" : parameter);
    }

    protected <T extends Enum<?>, C extends Component> void addVariantsDemo(Supplier<C> componentSupplier, BiConsumer<C, T> addVariant, BiConsumer<C, T> removeVariant, Function<T, String> variantToThemeName, T ... variants) {
        Component component = (Component)componentSupplier.get();
        component.setId(COMPONENT_WITH_VARIANTS_ID);
        Div message = new Div();
        message.setText("Toggle a variant to see how the component's appearance will change.");
        Div variantsToggles = new Div();
        variantsToggles.setId(VARIANT_TOGGLE_BUTTONS_DIV_ID);
        for (Object variant : variants) {
            if (!((Enum)variant).name().startsWith("LUMO_")) continue;
            String variantName = variantToThemeName.apply(variant);
            variantsToggles.add(new Component[]{new NativeButton(this.getButtonText(variantName, ((HasTheme)component).getThemeNames().contains((Object)variantName)), (ComponentEventListener & Serializable)event -> {
                boolean variantPresent = ((HasTheme)component).getThemeNames().contains((Object)variantName);
                if (variantPresent) {
                    removeVariant.accept(component, variant);
                } else {
                    addVariant.accept(component, variant);
                }
                ((NativeButton)event.getSource()).setText(this.getButtonText(variantName, !variantPresent));
            })});
        }
        this.addCard("Theme variants usage", new Component[]{message, component, variantsToggles});
    }

    private String getButtonText(String variantName, boolean variantPresent) {
        return String.format(variantPresent ? "Remove '%s' variant" : "Add '%s' variant", variantName);
    }

    public void add(Component ... components) {
    }
}

