/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.demo;

import com.vaadin.flow.testutil.ChromeBrowserTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class ComponentDemoTest
extends ChromeBrowserTest {
    protected WebElement layout;
    private Function<WebElement, String> DEFAULT_VARIANT_PRODUCER = new DefaultProducer();

    protected int getDeploymentPort() {
        return 9998;
    }

    @Before
    public void openDemoPageAndCheckForErrors() {
        this.open();
        this.waitForElementPresent(By.className((String)"demo-view"));
        this.layout = this.findElement(By.className((String)"demo-view"));
        this.checkLogsForErrors();
    }

    protected void verifyThemeVariantsBeingToggled() {
        this.verifyThemeVariantsBeingToggled(this.DEFAULT_VARIANT_PRODUCER);
    }

    protected void verifyThemeVariantsBeingToggled(Function<WebElement, String> variantProducer) {
        List toggleThemeButtons = this.layout.findElement(By.id((String)"variantToggleButtonsDiv")).findElements(By.tagName((String)"button"));
        Assert.assertFalse((String)"Expected at least one toggle theme button in 'buttonDiv', but got none", (boolean)toggleThemeButtons.isEmpty());
        toggleThemeButtons.forEach(button -> this.toggleVariantAndCheck(this.layout.findElement(By.id((String)"componentWithVariantsDemo")), (WebElement)button, variantProducer));
    }

    private void toggleVariantAndCheck(WebElement component, WebElement button, Function<WebElement, String> variantProducer) {
        List<String> initialButtonThemes = this.getComponentThemes(component);
        String initialButtonText = button.getText();
        button.click();
        this.verifyThemeIsToggled(this.getComponentThemes(component), button.getText(), initialButtonThemes, initialButtonText, variantProducer.apply(button));
        button.click();
        Assert.assertEquals((String)"After two toggle variants button clicks, button text should be the same as before testing", (Object)button.getText(), (Object)initialButtonText);
        List<String> currentThemes = this.getComponentThemes(component);
        String assertionMessage = "After two toggle variants button clicks, component 'theme' attribute should contain the same value as before testing";
        Assert.assertEquals((String)assertionMessage, (long)currentThemes.size(), (long)initialButtonThemes.size());
        currentThemes.forEach(currentTheme -> Assert.assertTrue((String)(assertionMessage + String.format(" but theme variant '%s' is missing", currentTheme)), (boolean)initialButtonThemes.contains(currentTheme)));
    }

    private void verifyThemeIsToggled(List<String> updatedThemes, String updatedButtonText, List<String> previousThemes, String previousButtonText, String variantName) {
        Assert.assertNotEquals((String)"Button should change its text after toggling", (Object)previousButtonText, (Object)updatedButtonText);
        boolean shouldAddTheme = previousButtonText.startsWith("Add");
        if (shouldAddTheme) {
            Assert.assertTrue((String)"When a theme variant got added, toggle button text should start with 'Remove' word", (boolean)updatedButtonText.startsWith("Remove"));
            Assert.assertEquals((String)"When a theme variant got added, component 'theme' attribute should contain one more variant that before", (long)(previousThemes.size() + 1), (long)updatedThemes.size());
            Assert.assertTrue((String)"When a theme variant got added, component 'theme' attribute should contain all previous theme variants", (boolean)updatedThemes.containsAll(previousThemes));
            Assert.assertTrue((String)("The selected theme variant:" + variantName + " should be added to the component 'theme' attribute."), (boolean)updatedThemes.contains(variantName));
        } else {
            Assert.assertTrue((String)"When a theme variant got removed, toggle button text should start with 'Add' word", (boolean)updatedButtonText.startsWith("Add"));
            Assert.assertEquals((String)"When a theme variant got removed, component 'theme' attribute should contain one less variant than before", (long)(previousThemes.size() - 1), (long)updatedThemes.size());
            Assert.assertTrue((String)"When a theme variant got removed, previous theme variants should contain all theme variants from component 'theme' attribute", (boolean)previousThemes.containsAll(updatedThemes));
            Assert.assertFalse((String)("The selected theme variant:" + variantName + " should be removed from the component 'theme' attribute."), (boolean)updatedThemes.contains(variantName));
        }
    }

    private List<String> getComponentThemes(WebElement component) {
        String themeAttributeValue = component.getAttribute("theme");
        if (themeAttributeValue == null || themeAttributeValue.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(themeAttributeValue.split(" "));
    }

    public static class DefaultProducer
    implements Function<WebElement, String> {
        @Override
        public String apply(WebElement button) {
            String[] variant = button.getText().split("'");
            return variant[1];
        }
    }
}

