/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.Platform;
import com.vaadin.flow.server.frontend.installer.NodeInstaller;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;

public class FrontendToolsSettings
implements Serializable {
    private String baseDir;
    private SerializableSupplier<String> alternativeDirGetter;
    private String nodeVersion = "v24.13.0";
    private URI nodeDownloadRoot = URI.create(NodeInstaller.getDownloadRoot(Platform.guess()));
    private boolean ignoreVersionChecks;
    private boolean forceAlternativeNode = false;
    private boolean useGlobalPnpm = false;
    private String nodeFolder = null;

    public FrontendToolsSettings(String baseDir, SerializableSupplier<String> alternativeDirGetter) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.alternativeDirGetter = alternativeDirGetter;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = Objects.requireNonNull(baseDir);
    }

    public void setAlternativeDirGetter(SerializableSupplier<String> alternativeDirGetter) {
        this.alternativeDirGetter = alternativeDirGetter;
    }

    public void setNodeDownloadRoot(URI nodeDownloadRoot) {
        this.nodeDownloadRoot = nodeDownloadRoot;
    }

    public void setNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
    }

    public void setIgnoreVersionChecks(boolean ignoreVersionChecks) {
        String val = System.getProperty("vaadin.ignoreVersionChecks");
        this.ignoreVersionChecks = val == null ? ignoreVersionChecks : Boolean.getBoolean("vaadin.ignoreVersionChecks");
    }

    public void setForceAlternativeNode(boolean forceAlternativeNode) {
        this.forceAlternativeNode = forceAlternativeNode;
    }

    public void setNodeFolder(String nodeFolder) {
        this.nodeFolder = nodeFolder;
    }

    public void setUseGlobalPnpm(boolean useGlobalPnpm) {
        this.useGlobalPnpm = useGlobalPnpm;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public Supplier<String> getAlternativeDirGetter() {
        return this.alternativeDirGetter;
    }

    public String getNodeVersion() {
        return this.nodeVersion;
    }

    public URI getNodeDownloadRoot() {
        return this.nodeDownloadRoot;
    }

    public boolean isIgnoreVersionChecks() {
        return this.ignoreVersionChecks;
    }

    public boolean isForceAlternativeNode() {
        return this.forceAlternativeNode;
    }

    public String getNodeFolder() {
        return this.nodeFolder;
    }

    public boolean isUseGlobalPnpm() {
        return this.useGlobalPnpm;
    }
}

