/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class ImportExtractor
implements Serializable {
    private static final String IMPORT = "import";
    private static final String FROM = "from";
    private final String content;

    ImportExtractor(String polymerCode) {
        this.content = polymerCode;
    }

    List<String> getImportedPaths() {
        String betweenImports;
        int indexFrom;
        ArrayList<String> imports = new ArrayList<String>();
        String strippedContent = this.removeComments();
        int index = 0;
        while (index >= 0 && (index = strippedContent.indexOf(IMPORT, indexFrom = index)) >= 0 && ((betweenImports = strippedContent.substring(indexFrom, index).trim()).isEmpty() || betweenImports.equals(";"))) {
            indexFrom = index + IMPORT.length();
            if ((index = strippedContent.indexOf(";", indexFrom)) < 0) {
                index = strippedContent.indexOf("\n", indexFrom);
            }
            if (index < 0) {
                index = strippedContent.length();
            }
            String importStatement = strippedContent.substring(indexFrom, index).trim();
            int fromIndex = importStatement.indexOf(FROM);
            String path = importStatement;
            if (fromIndex >= 0) {
                path = importStatement.substring(fromIndex + FROM.length(), importStatement.length()).trim();
            }
            imports.add(this.strip(path));
        }
        return imports;
    }

    String removeComments() {
        return StringUtil.removeComments((String)this.content, (boolean)true);
    }

    private String strip(String jsString) {
        if (jsString.startsWith("'")) {
            return jsString.substring(1, jsString.length() - 1).replace("\\'", "'");
        }
        if (jsString.startsWith("\"") && jsString.length() > 2) {
            return jsString.substring(1, jsString.length() - 1).replace("\\\"", "\"");
        }
        return jsString;
    }
}

