/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.internal.CssBundler;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProcessStylesheetCss
implements FallibleCommand {
    private final Options options;

    public TaskProcessStylesheetCss(Options options) {
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (!this.options.isProductionMode()) {
            this.getLogger().debug("Skipping CSS processing in non-production mode");
            return;
        }
        File resourcesDir = this.options.getMetaInfResourcesDirectory();
        if (resourcesDir == null || !resourcesDir.exists()) {
            this.getLogger().debug("META-INF/resources directory not found, skipping CSS processing");
            return;
        }
        Set<String> referencedCssPaths = this.scanStyleSheetAnnotations();
        if (referencedCssPaths.isEmpty()) {
            this.getLogger().debug("No @StyleSheet annotations found");
            return;
        }
        this.getLogger().info("Found {} @StyleSheet reference(s)", (Object)referencedCssPaths.size());
        for (String cssPath : referencedCssPaths) {
            File cssFile = this.resolveCssFile(resourcesDir, cssPath);
            if (cssFile != null && cssFile.exists()) {
                try {
                    this.processCssFile(cssFile);
                }
                catch (IOException e) {
                    this.getLogger().warn("Failed to process CSS file: {}", (Object)cssFile.getName(), (Object)e);
                }
                continue;
            }
            this.getLogger().debug("CSS file not found in META-INF/resources: {}", (Object)cssPath);
        }
    }

    private Set<String> scanStyleSheetAnnotations() {
        HashSet<String> cssPaths = new HashSet<String>();
        ClassFinder classFinder = this.options.getClassFinder();
        if (classFinder == null) {
            this.getLogger().debug("ClassFinder not available, skipping scan");
            return cssPaths;
        }
        try {
            Set<Class<?>> annotatedClasses = classFinder.getAnnotatedClasses(StyleSheet.class);
            for (Class<?> clazz : annotatedClasses) {
                StyleSheet[] annotations;
                for (StyleSheet annotation : annotations = (StyleSheet[])clazz.getAnnotationsByType(StyleSheet.class)) {
                    String value = annotation.value();
                    if (!this.isLocalStylesheet(value)) continue;
                    cssPaths.add(this.normalizeStylesheetPath(value));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Error scanning for @StyleSheet annotations", (Throwable)e);
        }
        return cssPaths;
    }

    private boolean isLocalStylesheet(String path) {
        if (path == null || path.isBlank()) {
            return false;
        }
        String lower = path.toLowerCase();
        return !lower.startsWith("http://") && !lower.startsWith("https://");
    }

    private String normalizeStylesheetPath(String path) {
        if (path.startsWith("./")) {
            return path.substring(2);
        }
        return path;
    }

    private File resolveCssFile(File resourcesDir, String cssPath) {
        if (cssPath == null || cssPath.isBlank()) {
            return null;
        }
        return new File(resourcesDir, cssPath);
    }

    private void processCssFile(File cssFile) throws IOException {
        this.getLogger().debug("Processing CSS file: {}", (Object)cssFile.getName());
        File nodeModulesFolder = this.options.getNodeModulesFolder();
        String content = CssBundler.inlineImports((File)cssFile.getParentFile(), (File)cssFile, null, (File)nodeModulesFolder);
        content = CssBundler.minifyCss((String)content);
        Files.writeString(cssFile.toPath(), (CharSequence)content, new OpenOption[0]);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(TaskProcessStylesheetCss.class);
    }
}

