/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class TaskGenerateTailwindCss
extends AbstractTaskClientGenerator {
    private static final String RELATIVE_SOURCE_PATH_MARKER = "#relativeSourcePath#";
    private static final String CUSTOM_IMPORT_MARKER = "/* #customImport# */";
    private static final String TAILWIND_CUSTOM_CSS = "tailwind-custom.css";
    private String relativeSourcePath;
    private String customImportReplacement;
    private final File tailwindCss;

    TaskGenerateTailwindCss(Options options) {
        this.tailwindCss = new File(options.getFrontendGeneratedFolder(), "tailwind.css");
        this.relativeSourcePath = options.getFrontendGeneratedFolder().toPath().relativize(options.getNpmFolder().toPath().resolve("src")).toString();
        this.relativeSourcePath = this.relativeSourcePath.replace(File.separator, "/");
        File customCssFile = new File(options.getFrontendDirectory(), TAILWIND_CUSTOM_CSS);
        if (customCssFile.exists()) {
            String relativeCustomPath = options.getFrontendGeneratedFolder().toPath().relativize(customCssFile.toPath()).toString();
            relativeCustomPath = relativeCustomPath.replace(File.separator, "/");
            this.customImportReplacement = "@import '" + relativeCustomPath + "';\n";
        } else {
            this.customImportReplacement = "";
        }
    }

    @Override
    protected String getFileContent() throws IOException {
        try (InputStream indexStream = this.getClass().getResourceAsStream("tailwind.css");){
            String template = StringUtil.toUTF8String((InputStream)indexStream);
            template = template.replace(RELATIVE_SOURCE_PATH_MARKER, this.relativeSourcePath);
            String string = template = template.replace(CUSTOM_IMPORT_MARKER, this.customImportReplacement);
            return string;
        }
    }

    @Override
    protected File getGeneratedFile() {
        return this.tailwindCss;
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }
}

