/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.internal.DevBundleUtils;
import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.frontend.ExclusionFilter;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.GenerateMainImports;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ProdBundleUtils;
import com.vaadin.flow.server.frontend.TaskGenerateCommercialBanner;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.ThemeValidationUtil;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.server.webcomponent.WebComponentExporterTagExtractor;
import com.vaadin.flow.server.webcomponent.WebComponentExporterUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public final class BundleValidationUtil {
    private static final String FRONTEND_HASHES_STATS_KEY = "frontendHashes";

    public static boolean needsBuild(Options options, FrontendDependenciesScanner frontendDependencies, Mode mode) {
        BundleValidationUtil.getLogger().info("Checking if a {} mode bundle build is needed", (Object)mode);
        try {
            boolean needsBuild;
            if (mode.isProduction()) {
                if (options.isForceProductionBuild() || FrontendBuildUtils.isHillaUsed(options.getFrontendDirectory(), options.getClassFinder())) {
                    if (options.isForceProductionBuild()) {
                        UsageStatistics.markAsUsed((String)"flow/prod-build-requested", null);
                    }
                    BundleValidationUtil.getLogger().info("Frontend build requested.");
                    BundleValidationUtil.saveResultInFile(true, options);
                    return true;
                }
                needsBuild = BundleValidationUtil.needsBuildProdBundle(options, frontendDependencies);
                BundleValidationUtil.saveResultInFile(needsBuild, options);
            } else if (Mode.DEVELOPMENT_BUNDLE == mode) {
                needsBuild = BundleValidationUtil.needsBuildDevBundle(options, frontendDependencies);
            } else {
                if (Mode.DEVELOPMENT_FRONTEND_LIVERELOAD == mode) {
                    return false;
                }
                throw new IllegalArgumentException("Unexpected mode");
            }
            if (needsBuild) {
                BundleValidationUtil.getLogger().info("A {} mode bundle build is needed", (Object)mode);
            } else {
                BundleValidationUtil.getLogger().info("A {} mode bundle build is not needed", (Object)mode);
            }
            return needsBuild;
        }
        catch (Exception e) {
            BundleValidationUtil.getLogger().error(String.format("Error when checking if a %s bundle build is needed", mode), (Throwable)e);
            return true;
        }
    }

    private static boolean needsBuildDevBundle(Options options, FrontendDependenciesScanner frontendDependencies) throws IOException {
        File npmFolder = options.getNpmFolder();
        File compressedDevBundle = new File(npmFolder, "src/main/bundles/dev.bundle");
        if (!(DevBundleUtils.getDevBundleFolder((File)npmFolder, (String)options.getBuildDirectoryName()).exists() || compressedDevBundle.exists() || BundleValidationUtil.hasJarBundle("vaadin-dev-bundle/", options.getClassFinder()))) {
            BundleValidationUtil.getLogger().info("No dev-bundle found.");
            return true;
        }
        if (!DevBundleUtils.getDevBundleFolder((File)npmFolder, (String)options.getBuildDirectoryName()).exists() && compressedDevBundle.exists()) {
            DevBundleUtils.unpackBundle((File)npmFolder, (File)new File(new File(npmFolder, options.getBuildDirectoryName()), "dev-bundle"));
        }
        if (options.isSkipDevBundle()) {
            BundleValidationUtil.getLogger().info("Skip dev bundle requested. Using existing bundle.");
            return false;
        }
        if (!DevBundleUtils.getDevBundleFolder((File)npmFolder, (String)options.getBuildDirectoryName()).exists() && !options.isReactEnabled()) {
            BundleValidationUtil.getLogger().info("Bundle build required for non default router.");
            return true;
        }
        String statsJsonContent = DevBundleUtils.findBundleStatsJson((File)npmFolder, (String)options.getBuildDirectoryName());
        if (statsJsonContent == null) {
            BundleValidationUtil.getLogger().info("No bundle's stats.json found for dev-bundle validation.");
            return true;
        }
        return BundleValidationUtil.needsBuildInternal(options, frontendDependencies, statsJsonContent);
    }

    private static boolean needsBuildProdBundle(Options options, FrontendDependenciesScanner frontendDependencies) throws IOException {
        if (!options.isReactEnabled() && !ProdBundleUtils.getProdBundle(options.getNpmFolder()).exists()) {
            BundleValidationUtil.getLogger().info("Bundle build required for non default router.");
            return true;
        }
        String statsJsonContent = ProdBundleUtils.findBundleStatsJson(options.getNpmFolder(), options.getClassFinder());
        if (!options.getClassFinder().getAnnotatedClasses(LoadDependenciesOnStartup.class).isEmpty()) {
            BundleValidationUtil.getLogger().info("Custom eager routes defined. Require bundle build.");
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-bundle-custom-loading", null);
            return true;
        }
        if (statsJsonContent == null) {
            BundleValidationUtil.getLogger().info("No bundle's stats.json found for production-bundle validation.");
            return true;
        }
        return BundleValidationUtil.needsBuildInternal(options, frontendDependencies, statsJsonContent);
    }

    private static boolean needsBuildInternal(Options options, FrontendDependenciesScanner frontendDependencies, String statsJsonContent) throws IOException {
        Map<String, String> npmPackages;
        JsonNode packageJson = BundleValidationUtil.getPackageJson(options, frontendDependencies);
        ObjectNode statsJson = JacksonUtils.readTree((String)statsJsonContent);
        if (!BundleValidationUtil.hashAndBundleModulesEqual((JsonNode)statsJson, packageJson, npmPackages = frontendDependencies.getPackages())) {
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-missing-package", null);
            return true;
        }
        if (options.isProductionMode() && BundleValidationUtil.hasCustomIndexHtml(options, (JsonNode)statsJson)) {
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-custom-index-html", null);
            return true;
        }
        ((ObjectNode)statsJson.get(FRONTEND_HASHES_STATS_KEY)).remove("index.html");
        if (BundleValidationUtil.isCommercialBannerConditionChanged(options, (JsonNode)statsJson)) {
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-commercial-banner-condition-changed", null);
            return true;
        }
        ((ObjectNode)statsJson.get(FRONTEND_HASHES_STATS_KEY)).remove("generated/commercial-banner.js");
        if (!BundleValidationUtil.frontendImportsFound((JsonNode)statsJson, options, frontendDependencies)) {
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-missing-frontend-import", null);
            return true;
        }
        if (ThemeValidationUtil.themeConfigurationChanged(options, (JsonNode)statsJson, frontendDependencies)) {
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-changed-theme-config", null);
            return true;
        }
        if (ThemeValidationUtil.themeShadowDOMStylesheetsChanged(options, (JsonNode)statsJson, frontendDependencies)) {
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-changed-shadow-DOM-stylesheets", null);
            return true;
        }
        if (BundleValidationUtil.exportedWebComponents((JsonNode)statsJson, options.getClassFinder())) {
            UsageStatistics.markAsUsed((String)"flow/rebundle-reason-added-exported-component", null);
            return true;
        }
        return false;
    }

    public static boolean hasJarBundle(String jarPath, ClassFinder finder) {
        URL resource = finder.getResource(jarPath + "config/stats.json");
        return resource != null;
    }

    public static JsonNode getPackageJson(Options options, FrontendDependenciesScanner frontendDependencies) {
        File packageJsonFile = new File(options.getNpmFolder(), "package.json");
        if (packageJsonFile.exists()) {
            try {
                ObjectNode packageJson = JacksonUtils.readTree((String)Files.readString(packageJsonFile.toPath()));
                BundleValidationUtil.cleanOldPlatformDependencies((JsonNode)packageJson);
                return BundleValidationUtil.getDefaultPackageJson(options, frontendDependencies, packageJson);
            }
            catch (IOException e) {
                BundleValidationUtil.getLogger().warn("Failed to read package.json", (Throwable)e);
            }
        } else {
            return BundleValidationUtil.getDefaultPackageJson(options, frontendDependencies, null);
        }
        return null;
    }

    public static JsonNode getDefaultPackageJson(Options options, FrontendDependenciesScanner frontendDependencies, ObjectNode packageJson) {
        NodeUpdater nodeUpdater = new NodeUpdater(frontendDependencies, options){

            @Override
            public void execute() {
            }
        };
        try {
            if (packageJson == null) {
                packageJson = nodeUpdater.getPackageJson();
            }
            nodeUpdater.addVaadinDefaultsToJson(packageJson);
            nodeUpdater.updateDefaultDependencies(packageJson);
            Map<String, String> applicationDependencies = frontendDependencies.getPackages();
            Map<String, String> filteredApplicationDependencies = new ExclusionFilter(options.getClassFinder(), options.isReactEnabled() && FrontendBuildUtils.isReactModuleAvailable(options), options.isNpmExcludeWebComponents()).exclude(applicationDependencies);
            for (Map.Entry<String, String> dep : filteredApplicationDependencies.entrySet()) {
                nodeUpdater.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue());
            }
            String hash = TaskUpdatePackages.generatePackageJsonHash((JsonNode)packageJson);
            ((ObjectNode)packageJson.get("vaadin")).put("hash", hash);
            ObjectNode platformPinnedDependencies = nodeUpdater.getPlatformPinnedDependencies();
            for (String key : JacksonUtils.getKeys((JsonNode)platformPinnedDependencies)) {
                if (filteredApplicationDependencies.containsKey(key)) continue;
                TaskUpdatePackages.pinPlatformDependency((JsonNode)packageJson, (JsonNode)platformPinnedDependencies, key);
            }
            return packageJson;
        }
        catch (IOException e) {
            BundleValidationUtil.getLogger().warn("Failed to generate package.json", (Throwable)e);
            return null;
        }
    }

    private static void cleanOldPlatformDependencies(JsonNode packageJson) {
        if (packageJson == null || !BundleValidationUtil.hasFrameworkDependencyObjects(packageJson)) {
            return;
        }
        ObjectNode dependencies = (ObjectNode)packageJson.get("dependencies");
        JsonNode vaadinDependencies = packageJson.get("vaadin").get("dependencies");
        for (String vaadinDependency : JacksonUtils.getKeys((JsonNode)vaadinDependencies)) {
            String version = vaadinDependencies.get(vaadinDependency).textValue();
            if (!dependencies.has(vaadinDependency) || !version.equals(dependencies.get(vaadinDependency).textValue())) continue;
            dependencies.remove(vaadinDependency);
            BundleValidationUtil.getLogger().debug("Old Vaadin provided dependency '{}':'{}' has been removed from package.json", (Object)vaadinDependency, (Object)version);
        }
    }

    public static boolean hashAndBundleModulesEqual(JsonNode statsJson, JsonNode packageJson, Map<String, String> npmPackages) {
        String packageJsonHash = BundleValidationUtil.getPackageJsonHash(packageJson);
        String bundlePackageJsonHash = BundleValidationUtil.getStatsHash(statsJson);
        if (packageJsonHash == null || packageJsonHash.isEmpty()) {
            BundleValidationUtil.getLogger().error("No hash found for 'package.json' even though one should always be generated!");
            return false;
        }
        JsonNode bundleModules = statsJson.get("packageJsonDependencies");
        if (bundleModules == null) {
            BundleValidationUtil.getLogger().error("Bundle did not contain package json dependencies to validate.\nRebuild of bundle needed.");
            return false;
        }
        if (packageJsonHash.equals(bundlePackageJsonHash) && !BundleValidationUtil.dependenciesContainsAllPackages(npmPackages, bundleModules)) {
            return false;
        }
        JsonNode dependencies = packageJson.get("dependencies");
        List dependenciesList = JacksonUtils.getKeys((JsonNode)dependencies).stream().filter(pkg -> !"@vaadin/flow-frontend".equals(pkg)).collect(Collectors.toList());
        List missingFromBundle = dependenciesList.stream().filter(pkg -> !bundleModules.has(pkg)).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String dependency : missingFromBundle) {
                BundleValidationUtil.getLogger().info("Dependency " + dependency + " is missing from the bundle");
            }
            return false;
        }
        missingFromBundle = dependenciesList.stream().filter(pkg -> !BundleValidationUtil.versionAccepted(dependencies.get(pkg).textValue(), bundleModules.get(pkg).textValue())).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String pkg2 : missingFromBundle) {
                BundleValidationUtil.getLogger().info("Dependency {}:{} has the wrong version {} in the bundle", new Object[]{pkg2, dependencies.get(pkg2).textValue(), bundleModules.get(pkg2).textValue()});
            }
            return false;
        }
        return true;
    }

    private static boolean versionAccepted(String expected, String actual) {
        FrontendVersion actualVersion;
        FrontendVersion expectedVersion;
        try {
            expectedVersion = new FrontendVersion(expected);
        }
        catch (NumberFormatException ex) {
            expectedVersion = null;
        }
        try {
            actualVersion = new FrontendVersion(actual);
        }
        catch (NumberFormatException ex) {
            actualVersion = null;
        }
        if (expectedVersion == null && actualVersion == null) {
            return Objects.equals(expected, actual);
        }
        if (expectedVersion == null || actualVersion == null) {
            BundleValidationUtil.getLogger().debug("Version '{}' cannot be parsed and compared to '{}'", (Object)(expectedVersion == null ? expected : actual), (Object)(expectedVersion == null ? actual : expected));
            return false;
        }
        if (expected.startsWith("~")) {
            boolean correctRange = expectedVersion.getMajorVersion() == actualVersion.getMajorVersion() && expectedVersion.getMinorVersion() == actualVersion.getMinorVersion();
            return (expectedVersion.isEqualTo(actualVersion) || expectedVersion.isOlderThan(actualVersion)) && correctRange;
        }
        if (expected.startsWith("^")) {
            boolean correctRange = expectedVersion.getMajorVersion() == actualVersion.getMajorVersion();
            return (expectedVersion.isEqualTo(actualVersion) || expectedVersion.isOlderThan(actualVersion)) && correctRange;
        }
        return expectedVersion.isEqualTo(actualVersion);
    }

    private static boolean dependenciesContainsAllPackages(Map<String, String> npmPackages, JsonNode dependencies) {
        List<String> collect = npmPackages.keySet().stream().filter(pkg -> !dependencies.has(pkg) || !BundleValidationUtil.versionAccepted(dependencies.get(pkg).textValue(), (String)npmPackages.get(pkg))).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            collect.forEach(dependency -> BundleValidationUtil.getLogger().info("Dependency " + dependency + " is missing from the bundle"));
            return false;
        }
        return true;
    }

    public static boolean exportedWebComponents(JsonNode statsJson, ClassFinder finder) {
        try {
            HashSet exporterRelatedClasses = new HashSet();
            finder.getSubTypesOf(WebComponentExporter.class.getName()).forEach(exporterRelatedClasses::add);
            finder.getSubTypesOf(WebComponentExporterFactory.class.getName()).forEach(exporterRelatedClasses::add);
            Set webComponents = WebComponentExporterUtils.getFactories(exporterRelatedClasses).stream().map(BundleValidationUtil::getTag).collect(Collectors.toSet());
            ArrayNode webComponentsInStats = (ArrayNode)statsJson.get("webComponents");
            if (webComponentsInStats == null) {
                if (!webComponents.isEmpty()) {
                    BundleValidationUtil.getLogger().info("Found embedded web components not yet included into the bundle: {}", (Object)String.join((CharSequence)", ", webComponents));
                    return true;
                }
                return false;
            }
            for (int index = 0; index < webComponentsInStats.size(); ++index) {
                String webComponentInStats = webComponentsInStats.get(index).textValue();
                webComponents.remove(webComponentInStats);
            }
            if (!webComponents.isEmpty()) {
                BundleValidationUtil.getLogger().info("Found newly added embedded web components not yet included into the bundle: {}", (Object)String.join((CharSequence)", ", webComponents));
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            BundleValidationUtil.getLogger().error("Unable to locate embedded web component classes.");
            return false;
        }
    }

    private static String getTag(WebComponentExporterFactory<? extends Component> factory) {
        WebComponentExporterTagExtractor exporterTagExtractor = new WebComponentExporterTagExtractor();
        return exporterTagExtractor.apply(factory);
    }

    public static boolean frontendImportsFound(JsonNode statsJson, Options options, FrontendDependenciesScanner frontendDependencies) throws IOException {
        GenerateMainImports generateMainImports = new GenerateMainImports(frontendDependencies, options, statsJson);
        generateMainImports.run();
        List imports = generateMainImports.getLines().stream().filter(line -> line.startsWith("import")).map(line -> line.substring(line.indexOf(39) + 1, line.lastIndexOf(39))).map(importString -> importString.contains("?") ? importString.substring(0, importString.lastIndexOf("?")) : importString).collect(Collectors.toList());
        LinkedHashSet uniqueImports = new LinkedHashSet(imports);
        ArrayNode statsBundle = statsJson.has("bundleImports") ? (ArrayNode)statsJson.get("bundleImports") : JacksonUtils.createArrayNode();
        List missingFromBundle = uniqueImports.stream().filter(importString -> !BundleValidationUtil.arrayContainsString(statsBundle, importString)).collect(Collectors.toList());
        if (!missingFromBundle.isEmpty()) {
            for (String dependency : missingFromBundle) {
                BundleValidationUtil.getLogger().info("Frontend import " + dependency + " is missing from the bundle");
            }
            return false;
        }
        String resourcePath = "generated/jar-resources/";
        List<String> jarImports = uniqueImports.stream().filter(importString -> importString.contains(resourcePath)).map(importString -> importString.substring(importString.indexOf(resourcePath) + resourcePath.length())).collect(Collectors.toList());
        List<String> projectImports = uniqueImports.stream().filter(importString -> importString.startsWith("Frontend/") && !importString.contains(resourcePath)).map(importString -> importString.substring("Frontend/".length())).collect(Collectors.toList());
        JsonNode frontendHashes = statsJson.get(FRONTEND_HASHES_STATS_KEY);
        ArrayList<String> faultyContent = new ArrayList<String>();
        for (String jarImport : jarImports) {
            String jarResourceString = FrontendBuildUtils.getJarResourceString(jarImport, options.getClassFinder());
            if (jarResourceString == null) {
                BundleValidationUtil.getLogger().info("No file found for '{}'", (Object)jarImport);
                return false;
            }
            BundleValidationUtil.compareFrontendHashes(frontendHashes, faultyContent, jarImport, jarResourceString);
        }
        for (String projectImport : projectImports) {
            File frontendFile = new File(options.getFrontendDirectory(), projectImport);
            if (!frontendFile.exists()) {
                BundleValidationUtil.getLogger().info("No file found for '{}'", (Object)projectImport);
                return false;
            }
            if (frontendFile.isDirectory()) continue;
            String frontendFileContent = Files.readString(frontendFile.toPath());
            BundleValidationUtil.compareFrontendHashes(frontendHashes, faultyContent, projectImport, frontendFileContent);
        }
        if (!faultyContent.isEmpty()) {
            BundleValidationUtil.logChangedFiles(faultyContent, "Detected changed content for frontend files:");
            return false;
        }
        if (BundleValidationUtil.indexFileAddedOrDeleted(options, frontendHashes)) {
            return false;
        }
        Map<String, String> remainingImports = BundleValidationUtil.getRemainingImports(jarImports, projectImports, frontendHashes);
        return !BundleValidationUtil.importedFrontendFilesChanged(options.getFrontendDirectory(), remainingImports);
    }

    private static boolean hasCustomIndexHtml(Options options, JsonNode statsJson) throws IOException {
        File indexHtml = new File(options.getFrontendDirectory(), "index.html");
        if (indexHtml.exists()) {
            JsonNode frontendHashes = statsJson.get(FRONTEND_HASHES_STATS_KEY);
            String frontendFileContent = Files.readString(indexHtml.toPath());
            ArrayList<String> faultyContent = new ArrayList<String>();
            String frontendFileContentHash = BundleValidationUtil.compareFrontendHashes(frontendHashes, faultyContent, "index.html", frontendFileContent);
            if (!faultyContent.isEmpty()) {
                BundleValidationUtil.logChangedFiles(faultyContent, "Detected changed content for frontend files:");
                BundleValidationUtil.logOldIndexHtmlWarning(frontendFileContentHash);
                return true;
            }
        }
        return false;
    }

    private static void logOldIndexHtmlWarning(String frontendFileContentHash) {
        if (List.of("49a6fa3fd70a6c36f32cd5389611b54611413fd6f8c430745bd3e0dd8c5a86c9", "9134a82f3ebcc72d303b78b843ba17b973fb5a7f5cfcd8868566a4d234cc7782", "c939e4dd2e34a02be02d8682215130119a8666ee3ed2f8f78de527464bffcfaf", "fa38cdf6d106b713195d7c56537443f8fa282607e4636a8e6c1da56f675135b1", "59ab33ffe4cdd1aa96ee4e03da8d99248ca89b9ea70d84cf2016787f29687472").contains(frontendFileContentHash)) {
            BundleValidationUtil.getLogger().warn("index.html matches the old Vaadin default. Update it to the latest by removing old and rebuild.");
        }
    }

    private static boolean indexFileAddedOrDeleted(Options options, JsonNode frontendHashes) {
        List<String> indexFiles = Arrays.asList("index.ts", "index.js", "index.tsx");
        for (String indexFile : indexFiles) {
            File file = new File(options.getFrontendDirectory(), indexFile);
            if (file.exists() && !frontendHashes.has(indexFile)) {
                BundleValidationUtil.getLogger().info("Detected added {} file", (Object)indexFile);
                return true;
            }
            if (file.exists() || !frontendHashes.has(indexFile)) continue;
            BundleValidationUtil.getLogger().info("Detected deleted {} file", (Object)indexFile);
            return true;
        }
        return false;
    }

    private static boolean isCommercialBannerConditionChanged(Options options, JsonNode statsJson) throws IOException {
        JsonNode frontendHashes = statsJson.get(FRONTEND_HASHES_STATS_KEY);
        boolean commercialBannerRequested = options.isCommercialBannerEnabled();
        String commercialBannerPath = "generated/commercial-banner.js";
        boolean hasCommercialBannerHash = frontendHashes.has(commercialBannerPath);
        if (!commercialBannerRequested && hasCommercialBannerHash) {
            BundleValidationUtil.getLogger().info("Detected commercial banner file but commercial banner is not enabled");
            return true;
        }
        if (!options.isProductionMode() && hasCommercialBannerHash) {
            BundleValidationUtil.getLogger().info("Detected commercial banner file but commercial banner is not applied in development bundle");
            return true;
        }
        if (commercialBannerRequested && options.isProductionMode()) {
            if (!hasCommercialBannerHash) {
                BundleValidationUtil.getLogger().info("Detected missing commercial banner file");
                return true;
            }
            ArrayList<String> faultyContent = new ArrayList<String>();
            BundleValidationUtil.compareFrontendHashes(frontendHashes, faultyContent, commercialBannerPath, new TaskGenerateCommercialBanner(options).getFileContent());
            if (!faultyContent.isEmpty()) {
                BundleValidationUtil.getLogger().info("Detected changed content for commercial banner file");
                return true;
            }
        }
        return false;
    }

    private static Map<String, String> getRemainingImports(List<String> jarImports, List<String> projectImports, JsonNode frontendHashes) {
        HashMap<String, String> remainingImportEntries = new HashMap<String, String>();
        List remainingKeys = JacksonUtils.getKeys((JsonNode)frontendHashes);
        remainingKeys.removeAll(jarImports);
        remainingKeys.removeAll(projectImports);
        if (!remainingKeys.isEmpty()) {
            for (String key : remainingKeys) {
                remainingImportEntries.put(key, frontendHashes.get(key).textValue());
            }
            return remainingImportEntries;
        }
        return Collections.emptyMap();
    }

    private static boolean importedFrontendFilesChanged(File frontendDirectory, Map<String, String> remainingImports) throws IOException {
        if (!remainingImports.isEmpty()) {
            ArrayList<String> changed = new ArrayList<String>();
            for (Map.Entry<String, String> importEntry : remainingImports.entrySet()) {
                String hash;
                String filePath = importEntry.getKey();
                String expectedHash = importEntry.getValue();
                File frontendFile = new File(frontendDirectory, filePath);
                if (!frontendFile.exists() || expectedHash.equals(hash = BundleValidationUtil.calculateHash(Files.readString(frontendFile.toPath())))) continue;
                changed.add(filePath);
            }
            if (!changed.isEmpty()) {
                BundleValidationUtil.logChangedFiles(changed, "Detected changed frontend files:");
                return true;
            }
        }
        return false;
    }

    private static String compareFrontendHashes(JsonNode frontendHashes, List<String> faultyContent, String frontendFilePath, String frontendFileContent) {
        String contentHash = BundleValidationUtil.calculateHash(frontendFileContent);
        if (frontendHashes.has(frontendFilePath) && !frontendHashes.get(frontendFilePath).textValue().equals(contentHash)) {
            faultyContent.add(frontendFilePath);
        } else if (!frontendHashes.has(frontendFilePath)) {
            BundleValidationUtil.getLogger().info("No hash info for '{}'", (Object)frontendFilePath);
            faultyContent.add(frontendFilePath);
        }
        return contentHash;
    }

    public static String calculateHash(String fileContent) {
        String content = fileContent.replaceAll("\\r\\n", "\n");
        return StringUtil.getHash((String)content, (Charset)StandardCharsets.UTF_8);
    }

    private static boolean arrayContainsString(ArrayNode array, String string) {
        string = string.replace("Frontend/", "./");
        for (int i = 0; i < array.size(); ++i) {
            if (!string.equals(array.get(i).textValue().replace("Frontend/", "./"))) continue;
            return true;
        }
        return false;
    }

    public static String getStatsHash(JsonNode statsJson) {
        if (statsJson.has("packageJsonHash")) {
            return statsJson.get("packageJsonHash").textValue();
        }
        return null;
    }

    public static String getPackageJsonHash(JsonNode packageJson) {
        if (packageJson != null && packageJson.has("vaadin") && packageJson.get("vaadin").has("hash")) {
            return packageJson.get("vaadin").get("hash").textValue();
        }
        return null;
    }

    private static boolean hasFrameworkDependencyObjects(JsonNode packageJson) {
        return packageJson.has("vaadin") && packageJson.get("vaadin").has("dependencies") && packageJson.has("dependencies");
    }

    public static void logChangedFiles(List<String> frontendFiles, String message) {
        if (message == null || ((String)message).isEmpty()) {
            throw new IllegalArgumentException("Changed files message cannot be empty");
        }
        if (((String)message).contains("{}")) {
            throw new IllegalArgumentException("Changed files message shouldn't include '{}' placeholder");
        }
        message = (String)message + "\n{}";
        StringBuilder handledFiles = new StringBuilder();
        for (String file : frontendFiles) {
            handledFiles.append(" - ").append(file).append("\n");
        }
        BundleValidationUtil.getLogger().info((String)message, (Object)handledFiles);
    }

    public static URL getProdBundleResource(String filename, ClassFinder finder) {
        return finder.getResource("vaadin-prod-bundle/" + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needsBundleBuild(File resourceOutputFolder) {
        File needsBuildFile = new File(resourceOutputFolder, "config/needs-build");
        if (!needsBuildFile.exists()) {
            BundleValidationUtil.getLogger().error("Require bundle build due to missing '{}' file.", (Object)"config/needs-build");
            return true;
        }
        try {
            String content = Files.readString(needsBuildFile.toPath());
            boolean bl = Boolean.parseBoolean(content);
            return bl;
        }
        catch (IOException e) {
            BundleValidationUtil.getLogger().error("Failed to read re-bundle checker result from file", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            FileIOUtils.deleteFileQuietly((File)needsBuildFile);
        }
    }

    private static void saveResultInFile(boolean needsBundle, Options options) throws IOException {
        File needsBuildFile = new File(options.getResourceOutputDirectory(), "config/needs-build");
        File targetDir = needsBuildFile.getParentFile();
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        Files.writeString(needsBuildFile.toPath(), (CharSequence)Boolean.toString(needsBundle), new OpenOption[0]);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BundleValidationUtil.class);
    }
}

