/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.frontendtools.installer;

import com.vaadin.frontendtools.installer.ArchiveExtractionException;
import com.vaadin.frontendtools.installer.ArchiveExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;

public final class DefaultArchiveExtractor
implements ArchiveExtractor {
    @Override
    public void extract(File archiveFile, File destinationDirectory) throws ArchiveExtractionException {
        try {
            if (archiveFile.getAbsolutePath().endsWith("msi")) {
                this.extractMSIArchive(archiveFile, destinationDirectory);
            } else if (archiveFile.getAbsolutePath().endsWith("zip")) {
                this.extractZipArchive(archiveFile, destinationDirectory);
            } else {
                this.extractGzipTarArchive(archiveFile, destinationDirectory);
            }
        }
        catch (IOException e) {
            throw new ArchiveExtractionException("Could not extract archive: '" + String.valueOf(archiveFile) + "'", e);
        }
    }

    private void extractMSIArchive(File archiveFile, File destinationDirectory) throws IOException, ArchiveExtractionException {
        String command = "msiexec /a " + archiveFile.getAbsolutePath() + " /qn TARGETDIR=\"" + String.valueOf(destinationDirectory) + "\"";
        Process child = Runtime.getRuntime().exec(command);
        try {
            int result = child.waitFor();
            if (result != 0) {
                throw new ArchiveExtractionException("Could not extract " + archiveFile.getAbsolutePath() + "; return code " + result);
            }
        }
        catch (InterruptedException e) {
            throw new ArchiveExtractionException("Unexpected interruption of while waiting for extraction process", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZipArchive(File archiveFile, File destinationDirectory) throws IOException {
        try (ZipFile zipFile = new ZipFile(archiveFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File destPath = new File(String.valueOf(destinationDirectory) + File.separator + entry.getName());
                this.prepDestination(destPath, entry.isDirectory());
                this.copyZipFileContents(zipFile, entry, destPath);
            }
        }
    }

    private void copyZipFileContents(ZipFile zipFile, ZipEntry entry, File destinationFile) throws IOException {
        if (entry.isDirectory()) {
            return;
        }
        try (InputStream in = zipFile.getInputStream(entry);
             FileOutputStream out = new FileOutputStream(destinationFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private void extractGzipTarArchive(File archive, File destinationDirectory) throws IOException {
        try (FileInputStream fis = new FileInputStream(archive);
             GzipCompressorInputStream gis = new GzipCompressorInputStream((InputStream)fis);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gis);){
            TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
            String canonicalDestinationDirectory = destinationDirectory.getCanonicalPath();
            while (tarEntry != null) {
                File destPath = new File(String.valueOf(destinationDirectory) + File.separator + tarEntry.getName());
                this.prepDestination(destPath, tarEntry.isDirectory());
                if (!this.startsWithPath(destPath.getCanonicalPath(), canonicalDestinationDirectory)) {
                    throw new IOException("Expanding " + tarEntry.getName() + " would create file outside of " + canonicalDestinationDirectory);
                }
                this.copyTarFileContents(tarIn, tarEntry, destPath);
                tarEntry = tarIn.getNextTarEntry();
            }
        }
    }

    private void copyTarFileContents(TarArchiveInputStream tarIn, TarArchiveEntry tarEntry, File destinationFile) throws IOException {
        if (tarEntry.isDirectory()) {
            return;
        }
        destinationFile.createNewFile();
        boolean isExecutable = (tarEntry.getMode() & 0x40) > 0;
        destinationFile.setExecutable(isExecutable);
        try (FileOutputStream out = new FileOutputStream(destinationFile);){
            IOUtils.copy((InputStream)tarIn, (OutputStream)out);
        }
    }

    private void prepDestination(File path, boolean directory) throws IOException {
        if (directory) {
            path.mkdirs();
        } else {
            if (!path.getParentFile().exists()) {
                path.getParentFile().mkdirs();
            }
            if (!path.getParentFile().canWrite()) {
                throw new AccessDeniedException(String.format("Could not get write permissions for '%s'", path.getParentFile().getAbsolutePath()));
            }
        }
    }

    private boolean startsWithPath(String destPath, String destDir) {
        if (destPath.startsWith(destDir)) {
            return true;
        }
        if (destDir.length() > destPath.length()) {
            return false;
        }
        if (new File(destPath).exists() && !new File(destPath.toLowerCase()).exists()) {
            return false;
        }
        return destPath.toLowerCase().startsWith(destDir.toLowerCase());
    }
}

