/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.exampledata;

import com.vaadin.exampledata.DataType;
import com.vaadin.exampledata.RandomFutureDate;
import com.vaadin.exampledata.RandomTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Random;

public class RandomFutureDateTime
extends DataType<LocalDateTime> {
    private DataType<LocalDate> dateGenerator;
    private DataType<LocalTime> timeGenerator;

    public RandomFutureDateTime(int maxDaysForward, boolean onlyHours) {
        this.dateGenerator = new RandomFutureDate(maxDaysForward);
        this.timeGenerator = new RandomTime(onlyHours);
    }

    @Override
    public LocalDateTime getValue(Random random, int seed, LocalDateTime referenceTime) {
        LocalDate date = this.dateGenerator.getValue(random, seed, referenceTime);
        LocalTime time = this.timeGenerator.getValue(random, seed + date.getDayOfYear(), referenceTime);
        return LocalDateTime.of(date, time);
    }
}

