/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.exampledata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class FileCache {
    private static HashMap<String, String[]> fileCache = new HashMap();
    private static HashMap<String, byte[]> fileDataCache = new HashMap();

    public static String[] get(String resourceName) {
        return fileCache.computeIfAbsent(resourceName, name -> {
            String[] stringArray;
            block9: {
                InputStream res = FileCache.class.getResourceAsStream((String)name);
                try {
                    if (res == null) {
                        throw new IOException("Resource with name " + FileCache.class.getPackage().getName().replace(".", "/") + "/" + name + " not found");
                    }
                    stringArray = (String[])Stream.of(IOUtils.toString((InputStream)res, (Charset)StandardCharsets.UTF_8).split("\n")).filter(value -> !value.trim().isEmpty()).toArray(String[]::new);
                    if (res == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (res != null) {
                            try {
                                res.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(FileCache.class).error("Unable to load options from " + name, (Throwable)e);
                        return new String[0];
                    }
                }
                res.close();
            }
            return stringArray;
        });
    }

    public static byte[] getFileData(String fileName) {
        return fileDataCache.computeIfAbsent(fileName, name -> {
            byte[] byArray;
            block9: {
                InputStream res = FileCache.class.getResourceAsStream((String)name);
                try {
                    if (res == null) {
                        throw new IOException("Resource with name " + FileCache.class.getPackage().getName().replace(".", "/") + "/" + name + " not found");
                    }
                    byArray = IOUtils.toByteArray((InputStream)res);
                    if (res == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (res != null) {
                            try {
                                res.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(FileCache.class).error("Unable to load binary data from " + name, (Throwable)e);
                        return new byte[0];
                    }
                }
                res.close();
            }
            return byArray;
        });
    }
}

