import { al as u, ag as i, w as g, x as n, E as h, ak as s, r as f, q as x } from "./copilot-C9fs7imY.js";
import { r as c } from "./state-DX1Hshs6.js";
import { i as e } from "./icons-DSuqz_Pk.js";
import { c as y } from "./copilot-tree-w_0cNQLz.js";
import { B as m } from "./base-panel-BzptayPc.js";
var $ = Object.defineProperty, S = Object.getOwnPropertyDescriptor, o = (t, a, p, r) => {
  for (var l = r > 1 ? void 0 : r ? S(a, p) : a, v = t.length - 1, b; v >= 0; v--)
    (b = t[v]) && (l = (r ? b(a, p, l) : b(l)) || l);
  return r && l && $(a, p, l), l;
};
let d = class extends m {
  constructor() {
    super(...arguments), this.selectedTab = 0, this.activationShortcutEnabled = i.isActivationShortcut(), this.aiUsage = i.isAIUsageAllowed(), this.aiProvider = i.getAIProvider(), this.themeItems = [
      { label: "System", value: "system" },
      { label: "Light", value: "light" },
      { label: "Dark", value: "dark" }
    ], this.aiUsageItems = [
      { label: "Ask each time", value: "ask" },
      { label: "Allow", value: "yes" },
      { label: "Deny", value: "no" }
    ], this.aiProviderItems = [
      { label: "Any region", value: "ANY" },
      { label: "EU only", value: "EU_ONLY" }
    ], this.toggleActivationShortcut = () => {
      this.activationShortcutEnabled = !this.activationShortcutEnabled, i.setActivationShortcut(this.activationShortcutEnabled);
    };
  }
  renderKbd(t) {
    const a = t.replace(/<kbd([^>]*)class="([^"]*)"/, '<kbd$1class="$2 font-sans ms-auto"').replace(/<kbd(?![^>]*class=)/, '<kbd class="font-sans ms-auto"');
    return g(a);
  }
  render() {
    return n`
      <vaadin-tabs>
        <vaadin-tab ?selected=${this.selectedTab === 0} @click=${() => this.selectedTab = 0}>General</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 1} @click=${() => this.selectedTab = 1}>Shortcuts</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 2} @click=${() => this.selectedTab = 2}>AI</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 3} @click=${() => this.selectedTab = 3}>Features</vaadin-tab>
      </vaadin-tabs>
      ${this.selectedTab === 0 ? this.renderGeneralTab() : null}
      ${this.selectedTab === 1 ? this.renderShortcutsTab() : null} ${this.selectedTab === 2 ? this.renderAiTab() : null}
      ${this.selectedTab === 3 ? this.renderFeaturesTab() : null}
    `;
  }
  renderGeneralTab() {
    const t = i.getSelectedTheme();
    return n`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <label class="py-1.5" id="theme">Theme</label>
        <vaadin-select
          accessible-name-ref="theme"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.themeItems}"
          .value="${t}"
          @change="${(a) => {
      i.setSelectedTheme(
        a.target.value
      );
    }}"></vaadin-select>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="reduce-motion-label">Reduce motion</label>
          <span id="reduce-motion-desc" class="text-secondary text-xs">Disables animations</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="reduce-motion-label"
          aria-describedby="reduce-motion-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="error-reports-label">Send error reports</label>
          <span id="error-reports-desc" class="text-secondary text-xs">Helps us improve the user experience</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="error-reports-label"
          aria-describedby="error-reports-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
    </div>`;
  }
  renderShortcutsTab() {
    const t = y.hasFlowComponents();
    return n`<div class="flex flex-col gap-4 pb-2 pt-4 px-4">
      <div class="flex justify-between">
        <div class="flex flex-col">
          <label id="enable-shortcuts-label">Enable keyboard shortcut</label>
          <span id="enable-shortcuts-desc" class="text-secondary text-xs"
            >Open Copilot with ${this.renderKbd(s.toggleCopilot)}</span
          >
        </div>
        <button
          aria-checked="${this.activationShortcutEnabled}"
          aria-labelledby="enable-shortcuts-label"
          aria-describedby="enable-shortcuts-desc"
          class="my-px"
          role="switch"
          type="button"
          @click=${() => this.toggleActivationShortcut()}>
          <span></span>
        </button>
      </div>
      <vaadin-text-field accessible-name="Search" placeholder="Search...">
        <vaadin-icon class="text-secondary" slot="prefix" .svg="${e.search}"></vaadin-icon>
      </vaadin-text-field>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Global</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.vaadin}"></vaadin-icon>
            <span>Copilot</span>
            ${this.renderKbd(s.toggleCopilot)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.undo}"></vaadin-icon>
            <span>Undo</span>
            ${this.renderKbd(s.undo)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.redo}"></vaadin-icon>
            <span>Redo</span>
            ${this.renderKbd(s.redo)}
          </li>
        </ul>
      </div>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Component Selection</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.sparkles}"></vaadin-icon>
            <span>Open AI prompt</span>
            ${this.renderKbd(s.openAiPopover)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.code}"></vaadin-icon>
            <span>Go to source</span>
            ${this.renderKbd(s.goToSource)}
          </li>
          ${t ? n`<li class="flex gap-2 py-2">
                <vaadin-icon .svg="${e.code}"></vaadin-icon>
                <span>Go to attach source</span>
                ${this.renderKbd(s.goToAttachSource)}
              </li>` : h}
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.contentCopy}"></vaadin-icon>
            <span>Copy</span>
            ${this.renderKbd(s.copy)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.contentPaste}"></vaadin-icon>
            <span>Paste</span>
            ${this.renderKbd(s.paste)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.fileCopy}"></vaadin-icon>
            <span>Duplicate</span>
            ${this.renderKbd(s.duplicate)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.turnLeft}"></vaadin-icon>
            <span>Select parent</span>
            ${this.renderKbd(s.selectParent)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.north}"></vaadin-icon>
            <span>Select previous sibling</span>
            ${this.renderKbd(s.selectPreviousSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.south}"></vaadin-icon>
            <span>Select first child / next sibling</span>
            ${this.renderKbd(s.selectNextSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.delete}"></vaadin-icon>
            <span>Delete</span>
            ${this.renderKbd(s.delete)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${e.dashboardCustomize}"></vaadin-icon>
            <span>Add component</span>
            <kbd class="font-sans ms-auto">A – Z</kbd>
          </li>
        </ul>
      </div>
    </div>`;
  }
  renderAiTab() {
    const t = f.userInfo?.vaadiner;
    return n`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <div class="flex flex-col py-1.5">
          <label id="ai-usage">AI usage</label>
          <span class="text-secondary text-xs">All AI features are clearly labelled </span>
        </div>
        <vaadin-select
          accessible-name-ref="ai-usage"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.aiUsageItems}"
          .value="${this.aiUsage}"
          @value-changed="${(a) => {
      this.aiUsage = a.detail.value, i.setAIUsageAllowed(a.detail.value);
    }}"></vaadin-select>
      </div>
      ${t ? n`<div class="flex gap-2 items-start justify-between py-2">
            <label class="py-1.5" id="ai-provider">AI provider</label>
            <vaadin-select
              accessible-name-ref="ai-provider"
              class="flex-shrink-0"
              theme="auto-width no-border"
              .items="${this.aiProviderItems}"
              .value="${this.aiProvider}"
              @value-changed="${(a) => {
      this.aiProvider = a.detail.value, i.setAIProvider(a.detail.value);
    }}"></vaadin-select>
          </div>` : h}
    </div>`;
  }
  renderFeaturesTab() {
    return n`<copilot-features-panel></copilot-features-panel>`;
  }
};
o([
  c()
], d.prototype, "selectedTab", 2);
o([
  c()
], d.prototype, "activationShortcutEnabled", 2);
o([
  c()
], d.prototype, "aiUsage", 2);
o([
  c()
], d.prototype, "aiProvider", 2);
d = o([
  x("copilot-settings-panel")
], d);
const T = {
  header: "Settings",
  tag: u.SETTINGS
}, A = {
  init(t) {
    t.addPanel(T);
  }
};
window.Vaadin.copilot.plugins.push(A);
export {
  d as CopilotSettingsPanel,
  T as panelConfig
};
