import { an as u, ai as i, D as f, x as n, E as h, am as s, w as g, v as m } from "./copilot-DD4yUMjH.js";
import { r as c } from "./state-CdTHPgfy.js";
import { i as a } from "./icons-Dg6-OnOj.js";
import { c as x } from "./copilot-tree-LIsXUVHb.js";
import { B as y } from "./base-panel-Bo7cTT-C.js";
var $ = Object.defineProperty, T = Object.getOwnPropertyDescriptor, d = (t, e, p, r) => {
  for (var l = r > 1 ? void 0 : r ? T(e, p) : e, v = t.length - 1, b; v >= 0; v--)
    (b = t[v]) && (l = (r ? b(e, p, l) : b(l)) || l);
  return r && l && $(e, p, l), l;
};
let o = class extends y {
  constructor() {
    super(...arguments), this.selectedTab = 0, this.selectedNotificationPosition = "Top right", this.activationShortcutEnabled = i.isActivationShortcut(), this.aiUsage = i.isAIUsageAllowed(), this.aiProvider = i.getAIProvider(), this.themeItems = [
      { label: "System", value: "system" },
      { label: "Light", value: "light" },
      { label: "Dark", value: "dark" }
    ], this.notificationPositionItems = [
      { label: "Top right", value: "Top right" },
      { label: "Bottom right", value: "Bottom right" },
      { label: "Bottom left", value: "Bottom left" },
      { label: "Top left", value: "Top left" }
    ], this.aiUsageItems = [
      { label: "Ask each time", value: "ask" },
      { label: "Allow", value: "yes" },
      { label: "Deny", value: "no" }
    ], this.aiProviderItems = [
      { label: "Any region", value: "ANY" },
      { label: "EU only", value: "EU_ONLY" }
    ], this.toggleActivationShortcut = () => {
      this.activationShortcutEnabled = !this.activationShortcutEnabled, i.setActivationShortcut(this.activationShortcutEnabled);
    };
  }
  renderKbd(t) {
    const e = t.replace(/<kbd([^>]*)class="([^"]*)"/, '<kbd$1class="$2 font-sans ms-auto"').replace(/<kbd(?![^>]*class=)/, '<kbd class="font-sans ms-auto"');
    return f(e);
  }
  render() {
    return n`
      <vaadin-tabs>
        <vaadin-tab ?selected=${this.selectedTab === 0} @click=${() => this.selectedTab = 0}>General</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 1} @click=${() => this.selectedTab = 1}>Shortcuts</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 2} @click=${() => this.selectedTab = 2}>AI</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 3} @click=${() => this.selectedTab = 3}>Features</vaadin-tab>
      </vaadin-tabs>
      ${this.selectedTab === 0 ? this.renderGeneralTab() : null}
      ${this.selectedTab === 1 ? this.renderShortcutsTab() : null} ${this.selectedTab === 2 ? this.renderAiTab() : null}
      ${this.selectedTab === 3 ? this.renderFeaturesTab() : null}
    `;
  }
  renderGeneralTab() {
    const t = i.getSelectedTheme();
    return n`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <label class="py-1.5" id="theme">Theme</label>
        <vaadin-select
          accessible-name-ref="theme"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.themeItems}"
          .value="${t}"
          @change="${(e) => {
      i.setSelectedTheme(
        e.target.value
      );
    }}"></vaadin-select>
      </div>
      <div class="flex gap-2 items-start justify-between py-2">
        <label class="py-1.5" id="notification-position">Notifications</label>
        <vaadin-select
          accessible-name-ref="notification-position"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.notificationPositionItems}"
          .value="${this.selectedNotificationPosition}"
          @value-changed="${(e) => {
      this.selectedNotificationPosition = e.detail.value;
    }}"></vaadin-select>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="reduce-motion-label">Reduce motion</label>
          <span id="reduce-motion-desc" class="text-secondary text-xs">Disables animations</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="reduce-motion-label"
          aria-describedby="reduce-motion-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="error-reports-label">Send error reports</label>
          <span id="error-reports-desc" class="text-secondary text-xs">Helps us improve the user experience</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="error-reports-label"
          aria-describedby="error-reports-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
    </div>`;
  }
  renderShortcutsTab() {
    const t = x.hasFlowComponents();
    return n`<div class="flex flex-col gap-4 pb-2 pt-4 px-4">
      <div class="flex justify-between">
        <div class="flex flex-col">
          <label id="enable-shortcuts-label">Enable keyboard shortcut</label>
          <span id="enable-shortcuts-desc" class="text-secondary text-xs"
            >Open DevTools with ${this.renderKbd(s.toggleCopilot)}</span
          >
        </div>
        <button
          aria-checked="${this.activationShortcutEnabled}"
          aria-labelledby="enable-shortcuts-label"
          aria-describedby="enable-shortcuts-desc"
          class="my-px"
          role="switch"
          type="button"
          @click=${() => this.toggleActivationShortcut()}>
          <span></span>
        </button>
      </div>
      <vaadin-text-field accessible-name="Search" placeholder="Search...">
        <vaadin-icon class="text-secondary" slot="prefix" .svg="${a.search}"></vaadin-icon>
      </vaadin-text-field>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Global</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.vaadin}"></vaadin-icon>
            <span>Copilot</span>
            ${this.renderKbd(s.toggleCopilot)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.undo}"></vaadin-icon>
            <span>Undo</span>
            ${this.renderKbd(s.undo)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.redo}"></vaadin-icon>
            <span>Redo</span>
            ${this.renderKbd(s.redo)}
          </li>
        </ul>
      </div>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Component Selection</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.sparkles}"></vaadin-icon>
            <span>Open AI prompt</span>
            ${this.renderKbd(s.openAiPopover)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.code}"></vaadin-icon>
            <span>Go to source</span>
            ${this.renderKbd(s.goToSource)}
          </li>
          ${t ? n`<li class="flex gap-2 py-2">
                <vaadin-icon .svg="${a.code}"></vaadin-icon>
                <span>Go to attach source</span>
                ${this.renderKbd(s.goToAttachSource)}
              </li>` : h}
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.contentCopy}"></vaadin-icon>
            <span>Copy</span>
            ${this.renderKbd(s.copy)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.contentPaste}"></vaadin-icon>
            <span>Paste</span>
            ${this.renderKbd(s.paste)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.fileCopy}"></vaadin-icon>
            <span>Duplicate</span>
            ${this.renderKbd(s.duplicate)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.turnLeft}"></vaadin-icon>
            <span>Select parent</span>
            ${this.renderKbd(s.selectParent)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.north}"></vaadin-icon>
            <span>Select previous sibling</span>
            ${this.renderKbd(s.selectPreviousSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.south}"></vaadin-icon>
            <span>Select first child / next sibling</span>
            ${this.renderKbd(s.selectNextSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.delete}"></vaadin-icon>
            <span>Delete</span>
            ${this.renderKbd(s.delete)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${a.dashboardCustomize}"></vaadin-icon>
            <span>Add component</span>
            <kbd class="font-sans ms-auto">A – Z</kbd>
          </li>
        </ul>
      </div>
    </div>`;
  }
  renderAiTab() {
    const t = g.userInfo?.vaadiner;
    return n`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <div class="flex flex-col py-1.5">
          <label id="ai-usage">AI usage</label>
          <span class="text-secondary text-xs">All AI features are clearly labelled </span>
        </div>
        <vaadin-select
          accessible-name-ref="ai-usage"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.aiUsageItems}"
          .value="${this.aiUsage}"
          @value-changed="${(e) => {
      this.aiUsage = e.detail.value, i.setAIUsageAllowed(e.detail.value);
    }}"></vaadin-select>
      </div>
      ${t ? n`<div class="flex gap-2 items-start justify-between py-2">
            <label class="py-1.5" id="ai-provider">AI provider</label>
            <vaadin-select
              accessible-name-ref="ai-provider"
              class="flex-shrink-0"
              theme="auto-width no-border"
              .items="${this.aiProviderItems}"
              .value="${this.aiProvider}"
              @value-changed="${(e) => {
      this.aiProvider = e.detail.value, i.setAIProvider(e.detail.value);
    }}"></vaadin-select>
          </div>` : h}
    </div>`;
  }
  renderFeaturesTab() {
    return n`<copilot-features-panel></copilot-features-panel>`;
  }
};
d([
  c()
], o.prototype, "selectedTab", 2);
d([
  c()
], o.prototype, "selectedNotificationPosition", 2);
d([
  c()
], o.prototype, "activationShortcutEnabled", 2);
d([
  c()
], o.prototype, "aiUsage", 2);
d([
  c()
], o.prototype, "aiProvider", 2);
o = d([
  m("copilot-settings-panel")
], o);
const S = {
  header: "Settings",
  tag: u.SETTINGS
}, P = {
  init(t) {
    t.addPanel(S);
  }
};
window.Vaadin.copilot.plugins.push(P);
export {
  o as CopilotSettingsPanel,
  S as panelConfig
};
