import { v as m, M as f, E as u, U as h, x as l, w as n, V as y, av as C, H as x, y as i, ap as I, an as c } from "./copilot-DD4yUMjH.js";
import { i as t } from "./icons-Dg6-OnOj.js";
var k = Object.getOwnPropertyDescriptor, w = (e, r, a, d) => {
  for (var s = d > 1 ? void 0 : d ? k(r, a) : r, o = e.length - 1, p; o >= 0; o--)
    (p = e[o]) && (s = p(s) || s);
  return s;
};
const S = "bg-[linear-gradient(to_right,var(--amber-3),var(--amber-5),var(--amber-3),var(--amber-6))] dark:bg-[linear-gradient(to_right,var(--amber-5),var(--amber-7),var(--amber-5),var(--amber-8))]", $ = "bg-[linear-gradient(to_right,var(--blue-3),var(--blue-5),var(--blue-3),var(--blue-6))] dark:bg-[linear-gradient(to_right,var(--blue-4),var(--blue-6),var(--blue-4),var(--blue-7))]", E = "bg-[linear-gradient(to_right,var(--ruby-3),var(--ruby-5),var(--ruby-3),var(--ruby-6))] dark:bg-[linear-gradient(to_right,var(--ruby-4),var(--ruby-6),var(--ruby-4),var(--ruby-7))]", P = "bg-[linear-gradient(to_right,var(--teal-3),var(--teal-5),var(--teal-3),var(--teal-6))] dark:bg-[linear-gradient(to_right,var(--teal-4),var(--teal-6),var(--teal-4),var(--teal-7))]";
let v = class extends f {
  createRenderRoot() {
    return this;
  }
  connectedCallback() {
    super.connectedCallback(), this.classList.add("flex", "flex-col");
  }
  render() {
    return l`
      <header class="flex items-center pe-2 ps-4 py-2">
        <h2 class="font-bold gap-1 me-auto my-0 text-xs uppercase">Vaadin DevTools</h2>
        <vaadin-button
          aria-label="Close"
          theme="icon tertiary"
          @click=${() => {
      this.closePopover();
    }}>
          <vaadin-icon .svg="${t.close}"></vaadin-icon>
          <vaadin-tooltip slot="tooltip" text="Close"></vaadin-tooltip>
        </vaadin-button>
      </header>
      <div class="flex flex-col gap-4 pb-4 px-4">
        ${this.renderUserButton()} ${this.renderDevelopmentWorkflow()}
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button
            @click="${this.handleAppInfoClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.info}"></vaadin-icon>
            App Info
          </vaadin-button>
          <vaadin-button @click="${this.handleAppLogClick}" class="border-0 h-auto justify-start py-2" theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.terminal}"></vaadin-icon>
            App Log
          </vaadin-button>
          ${h.springSecurityEnabled ? l`
                <vaadin-button
                  @click="${this.handleImpersonateAppUserClick}"
                  class="border-0 h-auto justify-start py-2"
                  theme="tertiary">
                  <vaadin-icon slot="prefix" .svg="${t.accountCircle}"></vaadin-icon>
                  Impersonate App User
                </vaadin-button>
              ` : u}
        </div>
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button
            @click="${this.handleHelpAndSupportClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.help}"></vaadin-icon>
            Help & Support
          </vaadin-button>
          <vaadin-button
            @click="${this.handleSettingsClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.settings}"></vaadin-icon>
            Settings
          </vaadin-button>
        </div>
      </div>
    `;
  }
  renderUserButton() {
    const e = n.userInfo?.validLicense, r = e ? S : $, a = e ? "text-amber-12 dark:text-amber-11" : "text-blue-12 dark:text-blue-11";
    return l`
      <vaadin-button
        class="animate-gradient ${r} border-0 gap-3 border-0 h-auto justify-start px-3 py-2 text-start">
        ${this.renderUserImage()}
        <span class="flex flex-col">
          <span>${this.getUserName()}</span>
          <span class="${a} text-xs">${this.getLicenseType()}</span>
        </span>
        <vaadin-icon class="ms-auto" slot="suffix" .svg="${t.moreVert}"></vaadin-icon>
      </vaadin-button>
    `;
  }
  renderUserImage() {
    return n.userInfo?.portraitUrl ? l`<img
        alt="${this.getUserName()}"
        class="rounded-full size-8 object-cover"
        slot="prefix"
        src="https://vaadin.com${n.userInfo.portraitUrl}" />` : u;
  }
  renderDevelopmentWorkflow() {
    const e = y(), r = C(), a = this.getDevelopmentWorkflowConfig(e, r), d = a?.bgClass ?? "", s = a?.colorClass ?? "", o = this.resolveIcon(a), p = a?.rotateIcon ? `rotate-180 ${s}` : s, g = this.resolveTitle(a), b = a?.displayMessage ?? "";
    return l`
      <vaadin-button
        data-test-id="development-workflow-btn"
        @click="${this.handleDevelopmentWorkflowClick}"
        class="animation-delay-4000 animate-gradient ${d} border-0 h-auto items-start justify-start py-2 text-start">
        <vaadin-icon class="${p}" slot="prefix" .svg="${o}"></vaadin-icon>
        <span class="flex flex-col">
          <span>${g}</span>
          <span class="text-xs ${s}">${b}</span>
        </span>
      </vaadin-button>
    `;
  }
  getDevelopmentWorkflowConfig(e, r) {
    const a = {
      bgClass: P,
      colorClass: "text-teal-11"
    };
    if (e === "warning" && r === "warning")
      return {
        ...a,
        icon: t.wbIncandescent,
        rotateIcon: !0,
        title: "IDE plugin & Hotswap recommended",
        combinedTitle: !0,
        displayMessage: "Enable both for optimal development workflow"
      };
    if (e === "warning")
      return {
        ...a,
        icon: t.wbIncandescent,
        rotateIcon: !0,
        title: "Hotswap recommended",
        displayMessage: "Applies changes without restarting"
      };
    if (r === "warning")
      return {
        ...a,
        icon: t.code,
        getIcon: !0,
        title: "IDE plugin recommended",
        getTitle: !0,
        displayMessage: "Simplifies Hotswap setup & config"
      };
    if (e === "error")
      return {
        bgClass: E,
        colorClass: "text-ruby-11",
        icon: t.error,
        title: "Hotswap partially enabled",
        displayMessage: "View details"
      };
  }
  resolveIcon(e) {
    return e ? e.getIcon ? this.getIdeIcon() : e.icon : t.bolt;
  }
  resolveTitle(e) {
    return e ? e.combinedTitle ? this.getCombinedTitle() : e.getTitle ? this.getIdePluginName() : e.title : "Development Workflow";
  }
  getUserName() {
    return [n.userInfo?.firstName, n.userInfo?.lastName].filter(Boolean).join(" ") || "User";
  }
  getLicenseType() {
    return n.userInfo?.validLicense ? "Commercial License" : "Free";
  }
  getIdeIcon() {
    switch (n.idePluginState?.ide) {
      case "intellij":
        return t.intelliJ;
      case "vscode":
        return t.vsCode;
      case "eclipse":
        return t.eclipse;
      default:
        return t.code;
    }
  }
  getIdePluginName() {
    switch (n.idePluginState?.ide) {
      case "intellij":
        return "Vaadin plugin for IntelliJ";
      case "vscode":
        return "Vaadin extension for VS Code";
      case "eclipse":
        return "Vaadin plugin for Eclipse";
      default:
        return "IDE plugin";
    }
  }
  getCombinedTitle() {
    switch (n.idePluginState?.ide) {
      case "intellij":
        return "IntelliJ plugin & Hotswap recommended";
      case "vscode":
        return "VS Code extension & Hotswap recommended";
      case "eclipse":
        return "Eclipse plugin & Hotswap recommended";
      default:
        return "IDE plugin & Hotswap recommended";
    }
  }
  closePopover() {
    const e = this.closest("vaadin-popover");
    e && (e.opened = !1);
  }
  handleDevelopmentWorkflowClick() {
    x("use-dev-workflow-guide"), i.openPanel(I), this.closePopover();
  }
  handleAppInfoClick() {
    i.openPanel(c.INFO), this.closePopover();
  }
  handleAppLogClick() {
    i.openPanel(c.LOG), this.closePopover();
  }
  handleImpersonateAppUserClick() {
    i.openPanel(c.IMPERSONATOR), this.closePopover();
  }
  handleSettingsClick() {
    i.openPanel(c.SETTINGS), this.closePopover();
  }
  handleHelpAndSupportClick() {
    i.openPanel(c.FEEDBACK), this.closePopover();
  }
};
v = w([
  m("copilot-devtools")
], v);
export {
  v as CopilotDevTools
};
