package com.vaadin.copilot.plugins.themeeditor.messages;

import java.util.List;

/**
 * Class name request is requested when Hilla+React component is selected to
 * find the existing class name or suggested one
 */
public class ClassNameRequest extends BaseRequest {
    private String fileName;
    private String componentName;
    private String componentDisplayName;
    private String id;
    private List<String> classList;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getClassList() {
        return List.copyOf(classList);
    }

    public void setClassList(List<String> classList) {
        this.classList = List.copyOf(classList);
    }

    public String getComponentDisplayName() {
        return componentDisplayName;
    }

    public void setComponentDisplayName(String componentDisplayName) {
        this.componentDisplayName = componentDisplayName;
    }
}
