package com.vaadin.copilot.plugins.themeeditor.utils;

import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.CompactConstructorDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.ReceiverParameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.comments.TraditionalJavadocComment;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.RecordPatternExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.SwitchExpr;
import com.github.javaparser.ast.expr.TextBlockLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.TypePatternExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.modules.ModuleExportsDirective;
import com.github.javaparser.ast.modules.ModuleOpensDirective;
import com.github.javaparser.ast.modules.ModuleProvidesDirective;
import com.github.javaparser.ast.modules.ModuleRequiresDirective;
import com.github.javaparser.ast.modules.ModuleUsesDirective;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.LocalClassDeclarationStmt;
import com.github.javaparser.ast.stmt.LocalRecordDeclarationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.UnparsableStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.stmt.YieldStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.IntersectionType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.type.VarType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitorAdapter;

/**
 * Implementation of {@link com.github.javaparser.ast.visitor.GenericVisitor}
 * that finds {@link Node} at given line of source code file.
 */
public class LineNumberVisitor extends GenericVisitorAdapter<Node, Integer> {

    @Override
    public Node visit(AnnotationDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(AnnotationMemberDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ArrayAccessExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ArrayCreationExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ArrayInitializerExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(AssertStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(AssignExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(BinaryExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(BlockStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(BooleanLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(BreakStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(CastExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(CatchClause n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(CharLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ClassExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ClassOrInterfaceDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ClassOrInterfaceType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(CompilationUnit n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ConditionalExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ConstructorDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ContinueStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(DoStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(DoubleLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(EmptyStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(EnclosedExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(EnumConstantDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(EnumDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ExplicitConstructorInvocationStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(FieldAccessExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(FieldDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ForEachStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ForStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(IfStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(InitializerDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(InstanceOfExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(IntegerLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(TraditionalJavadocComment n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(LabeledStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(LongLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(MarkerAnnotationExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(MemberValuePair n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(MethodCallExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(MethodDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(NameExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(NormalAnnotationExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(NullLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ObjectCreationExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(PackageDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(Parameter n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(PrimitiveType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(Name n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(SimpleName n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ArrayType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ArrayCreationLevel n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(IntersectionType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(UnionType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ReturnStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(SingleMemberAnnotationExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(StringLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(SuperExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(SwitchEntry n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(SwitchStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(SynchronizedStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ThisExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ThrowStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(TryStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(LocalClassDeclarationStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(LocalRecordDeclarationStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(TypeParameter n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(UnaryExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(UnknownType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(VariableDeclarationExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(VariableDeclarator n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(VoidType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(WhileStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(WildcardType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(LambdaExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(MethodReferenceExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(TypeExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ImportDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(BlockComment n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(LineComment n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ModuleDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ModuleRequiresDirective n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ModuleExportsDirective n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ModuleProvidesDirective n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ModuleUsesDirective n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ModuleOpensDirective n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(UnparsableStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ReceiverParameter n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(VarType n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(Modifier n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(SwitchExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(YieldStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(TextBlockLiteralExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(TypePatternExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(RecordPatternExpr n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(RecordDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(CompactConstructorDeclaration n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    @Override
    public Node visit(ExpressionStmt n, Integer arg) {
        return lineCheck(n, arg) ? n : super.visit(n, arg);
    }

    private boolean lineCheck(Node n, Integer arg) {
        return n.getRange().filter(r -> r.begin.line == arg).isPresent();
    }
}
