package com.vaadin.copilot.plugins.themeeditor;

public enum ThemeEditorCommand {
    CODE_OK("ok"), //
    CODE_ERROR("error"), //
    // in requests "copilot-" is removed by Copilot
    // in responses, it must be added manually
    RESPONSE("copilot-theme-editor-response"), //
    COMPONENT_METADATA("theme-editor-metadata"), //
    INIT("theme-editor-init"), //
    LOCAL_CLASS_NAME("theme-editor-local-class-name"), //
    RULES("theme-editor-rules"), //
    LOAD_RULES("theme-editor-load-rules"), //
    LOAD_PREVIEW("theme-editor-load-preview"), //
    SET_FONT("theme-editor-set-font"), //
    OPEN_CSS("theme-editor-open-css"),
    GET_CLASS_NAME("theme-editor-get-class-name");

    private final String value;

    ThemeEditorCommand(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}
