package com.vaadin.copilot.plugins.accessibilitychecker;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.flow.internal.JacksonUtils;

import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

/** @author jcgueriaud */
public class AccessibilityCheckerMessageHandler extends CopilotCommand {

    public static final String ACCESSIBILITY_CHECKER = "a11y-checker";
    public static final String UI_ID = "uiId";

    private final AccessibilityJavaSourceModifier accessibilityJavaSourceModifier;

    public AccessibilityCheckerMessageHandler() {
        accessibilityJavaSourceModifier = new AccessibilityJavaSourceModifier(getVaadinSession(),
                (devToolsInterface, errorMessage) -> {
                    ObjectNode object = JacksonUtils.createObjectNode();
                    object.put("message", errorMessage);
                    devToolsInterface.send(ACCESSIBILITY_CHECKER + "-error", object);
                }, (devToolsInterface) -> {
                    ObjectNode object = JacksonUtils.createObjectNode();
                    devToolsInterface.send(ACCESSIBILITY_CHECKER + "-success", object);
                });

    }

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        if (command.equals(ACCESSIBILITY_CHECKER + "-update-page-title")) {
            int uiId = data.get(UI_ID).asInt();
            String label = data.get("label").asString();
            accessibilityJavaSourceModifier.setPageTitle(devToolsInterface, uiId, label);
            return true;
        }
        return false;
    }
}
