package com.vaadin.copilot.theme;

/**
 * A singleton holder that manages and stores the currently detected application
 * theme.
 * <p>
 * This class provides a global access point to the application's theme,
 * allowing other components to get or set the detected theme at runtime.
 * </p>
 *
 * <p>
 * Example usage:
 * 
 * <pre>
 * ApplicationDetectedThemeHolder holder = ApplicationDetectedThemeHolder.getInstance();
 * holder.setTheme(ApplicationTheme.LUMO);
 * ApplicationTheme current = holder.getTheme();
 * </pre>
 * </p>
 *
 *
 * @see ApplicationTheme
 */
public class ApplicationDetectedThemeHolder {
    private static ApplicationDetectedThemeHolder instance;

    public static synchronized ApplicationDetectedThemeHolder getInstance() {
        if (instance == null) {
            instance = new ApplicationDetectedThemeHolder();
        }
        return instance;
    }

    private ApplicationDetectedThemeHolder() {
        applicationTheme = ApplicationTheme.NONE;
    }

    private ApplicationTheme applicationTheme;

    public void setTheme(ApplicationTheme applicationTheme) {
        this.applicationTheme = applicationTheme;
    }

    public ApplicationTheme getTheme() {
        return applicationTheme;
    }

}
