import { q as h, M as f, E as u, R as m, x as l, u as r, S as y, aw as C, D as I, r as o, am as k, al as c } from "./copilot-BXl55dy7.js";
import { i as t } from "./icons-BRoTuR1_.js";
var x = Object.getOwnPropertyDescriptor, w = (e, n, a, d) => {
  for (var i = d > 1 ? void 0 : d ? x(n, a) : n, s = e.length - 1, p; s >= 0; s--)
    (p = e[s]) && (i = p(i) || i);
  return i;
};
const S = "bg-[linear-gradient(to_right,var(--amber-3),var(--amber-5),var(--amber-3),var(--amber-6))] dark:bg-[linear-gradient(to_right,var(--amber-5),var(--amber-7),var(--amber-5),var(--amber-8))]", $ = "bg-[linear-gradient(to_right,var(--blue-3),var(--blue-5),var(--blue-3),var(--blue-6))] dark:bg-[linear-gradient(to_right,var(--blue-4),var(--blue-6),var(--blue-4),var(--blue-7))]", E = "bg-[linear-gradient(to_right,var(--ruby-3),var(--ruby-5),var(--ruby-3),var(--ruby-6))] dark:bg-[linear-gradient(to_right,var(--ruby-4),var(--ruby-6),var(--ruby-4),var(--ruby-7))]", P = "bg-[linear-gradient(to_right,var(--teal-3),var(--teal-5),var(--teal-3),var(--teal-6))] dark:bg-[linear-gradient(to_right,var(--teal-4),var(--teal-6),var(--teal-4),var(--teal-7))]";
let v = class extends f {
  createRenderRoot() {
    return this;
  }
  connectedCallback() {
    super.connectedCallback(), this.classList.add("flex", "flex-col");
  }
  render() {
    return l`
      <header class="flex items-center pe-2 ps-4 py-2">
        <h2 class="font-bold gap-1 me-auto my-0 text-xs uppercase">Vaadin Copilot</h2>
        <vaadin-button
          aria-label="Close"
          theme="icon tertiary"
          @click=${() => {
      this.closePopover();
    }}>
          <vaadin-icon .svg="${t.close}"></vaadin-icon>
          <vaadin-tooltip slot="tooltip" text="Close"></vaadin-tooltip>
        </vaadin-button>
      </header>
      <div class="flex flex-col gap-4 pb-4 px-4">
        ${this.renderUserButton()} ${this.renderDevelopmentWorkflow()}
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button
            @click="${this.handleAppInfoClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.info}"></vaadin-icon>
            App Info
          </vaadin-button>
          <vaadin-button @click="${this.handleAppLogClick}" class="border-0 h-auto justify-start py-2" theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.terminal}"></vaadin-icon>
            App Log
          </vaadin-button>
          ${m.springSecurityEnabled ? l`
                <vaadin-button
                  @click="${this.handleImpersonateAppUserClick}"
                  class="border-0 h-auto justify-start py-2"
                  theme="tertiary">
                  <vaadin-icon slot="prefix" .svg="${t.accountCircle}"></vaadin-icon>
                  Impersonate App User
                </vaadin-button>
              ` : u}
        </div>
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button
            @click="${this.handleHelpAndSupportClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.help}"></vaadin-icon>
            Help & Support
          </vaadin-button>
          <vaadin-button
            @click="${this.handleSettingsClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${t.settings}"></vaadin-icon>
            Settings
          </vaadin-button>
        </div>
      </div>
    `;
  }
  renderUserButton() {
    const e = r.userInfo?.validLicense, n = e ? S : $, a = e ? "text-amber-12 dark:text-amber-11" : "text-blue-12 dark:text-blue-11";
    return l`
      <vaadin-button
        @click=${this.handleUserLoginClick}
        class="animate-gradient ${n} border-0 gap-3 border-0 h-auto justify-start px-3 py-2 text-start">
        ${this.renderUserImage()}
        <span class="flex flex-col">
          <span>${this.getUserName()}</span>
          <span class="${a} text-xs">${this.getLicenseType()}</span>
        </span>
      </vaadin-button>
    `;
  }
  renderUserImage() {
    return r.userInfo?.portraitUrl ? l`<img
        alt="${this.getUserName()}"
        class="rounded-full size-8 object-cover"
        slot="prefix"
        src="https://vaadin.com${r.userInfo.portraitUrl}" />` : u;
  }
  renderDevelopmentWorkflow() {
    const e = y(), n = C(), a = this.getDevelopmentWorkflowConfig(e, n), d = a?.bgClass ?? "", i = a?.colorClass ?? "", s = this.resolveIcon(a), p = a?.rotateIcon ? `rotate-180 ${i}` : i, g = this.resolveTitle(a), b = a?.displayMessage ?? "";
    return l`
      <vaadin-button
        data-test-id="development-workflow-btn"
        @click="${this.handleDevelopmentWorkflowClick}"
        class="animation-delay-4000 animate-gradient ${d} border-0 h-auto items-start justify-start py-2 text-start">
        <vaadin-icon class="${p}" slot="prefix" .svg="${s}"></vaadin-icon>
        <span class="flex flex-col">
          <span>${g}</span>
          <span class="text-xs ${i}">${b}</span>
        </span>
      </vaadin-button>
    `;
  }
  getDevelopmentWorkflowConfig(e, n) {
    const a = {
      bgClass: P,
      colorClass: "text-teal-11"
    };
    if (e === "warning" && n === "warning")
      return {
        ...a,
        icon: t.wbIncandescent,
        rotateIcon: !0,
        title: "IDE plugin & Hotswap recommended",
        combinedTitle: !0,
        displayMessage: "Enable both for optimal development workflow"
      };
    if (e === "warning")
      return {
        ...a,
        icon: t.wbIncandescent,
        rotateIcon: !0,
        title: "Hotswap recommended",
        displayMessage: "Applies changes without restarting"
      };
    if (n === "warning")
      return {
        ...a,
        icon: t.code,
        getIcon: !0,
        title: "IDE plugin recommended",
        getTitle: !0,
        displayMessage: "Simplifies Hotswap setup & config"
      };
    if (e === "error")
      return {
        bgClass: E,
        colorClass: "text-ruby-11",
        icon: t.error,
        title: "Hotswap partially enabled",
        displayMessage: "View details"
      };
  }
  resolveIcon(e) {
    return e ? e.getIcon ? this.getIdeIcon() : e.icon : t.bolt;
  }
  resolveTitle(e) {
    return e ? e.combinedTitle ? this.getCombinedTitle() : e.getTitle ? this.getIdePluginName() : e.title : "Development Workflow";
  }
  getUserName() {
    return [r.userInfo?.firstName, r.userInfo?.lastName].filter(Boolean).join(" ") || "Not logged in";
  }
  getLicenseType() {
    return r.userInfo?.validLicense ? "" : "Unlock all Copilot features (includes AI features)";
  }
  getIdeIcon() {
    switch (r.idePluginState?.ide) {
      case "intellij":
        return t.intelliJ;
      case "vscode":
        return t.vsCode;
      case "eclipse":
        return t.eclipse;
      default:
        return t.code;
    }
  }
  getIdePluginName() {
    switch (r.idePluginState?.ide) {
      case "intellij":
        return "Vaadin plugin for IntelliJ";
      case "vscode":
        return "Vaadin extension for VS Code";
      case "eclipse":
        return "Vaadin plugin for Eclipse";
      default:
        return "IDE plugin";
    }
  }
  getCombinedTitle() {
    switch (r.idePluginState?.ide) {
      case "intellij":
        return "IntelliJ plugin & Hotswap recommended";
      case "vscode":
        return "VS Code extension & Hotswap recommended";
      case "eclipse":
        return "Eclipse plugin & Hotswap recommended";
      default:
        return "IDE plugin & Hotswap recommended";
    }
  }
  closePopover() {
    const e = this.closest("vaadin-popover");
    e && (e.opened = !1);
  }
  handleUserLoginClick() {
    if (r.userInfo?.validLicense) {
      window.open("https://vaadin.com/myaccount", "_blank", "noopener");
      return;
    }
    r.setLoginCheckActive(!0);
  }
  handleDevelopmentWorkflowClick() {
    I("use-dev-workflow-guide"), o.openPanel(k), this.closePopover();
  }
  handleAppInfoClick() {
    o.openPanel(c.INFO), this.closePopover();
  }
  handleAppLogClick() {
    o.openPanel(c.LOG), this.closePopover();
  }
  handleImpersonateAppUserClick() {
    o.openPanel(c.IMPERSONATOR), this.closePopover();
  }
  handleSettingsClick() {
    o.openPanel(c.SETTINGS), this.closePopover();
  }
  handleHelpAndSupportClick() {
    o.openPanel(c.FEEDBACK), this.closePopover();
  }
};
v = w([
  h("copilot-devtools")
], v);
export {
  v as CopilotDevTools
};
