package com.vaadin.copilot.exception;

/**
 * Generic exception for Copilot which exists mainly to make it easy to see that
 * an exception originated inside Copilot.
 */
public class CopilotException extends RuntimeException {

    /**
     * Creates a new exception with the given message.
     *
     * @param message
     *            the message of the exception
     */
    public CopilotException(String message) {
        super(message);
    }

    /**
     * Creates a new exception with the given cause.
     *
     * @param cause
     *            the cause of the exception
     */
    public CopilotException(Throwable cause) {
        super(cause);
    }

    /**
     * Creates a new exception with the given message and cause.
     *
     * @param message
     *            the message of the exception
     * @param cause
     *            the cause of the exception
     */
    public CopilotException(String message, Throwable cause) {
        super(message, cause);
    }
}
