package VIEW_PACKAGE;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.card.Card;
import com.vaadin.flow.component.card.CardVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Main;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import java.util.Arrays;
import java.util.List;

public class StubView extends Main implements AfterNavigationObserver {

    Grid<Person> grid = new Grid<>();

    public StubView() {
        setSizeFull();
        grid.setHeight("100%");
        grid.addThemeVariants(GridVariant.LUMO_NO_BORDER, GridVariant.LUMO_NO_ROW_BORDERS);
        grid.addComponentColumn(this::createCard);
        add(grid);
    }

    private Component createCard(Person person) {
        Card card = new Card();
        card.setTitle(person.name());
        card.addThemeVariants(CardVariant.LUMO_OUTLINED, CardVariant.LUMO_HORIZONTAL);

        Image image = new Image();
        image.setSrc(person.image());
        image.getStyle().setWidth("4rem").setHeight("4rem").setMarginRight("calc(var(--vaadin-padding-s) * 1.5)").setBorderRadius("50%");
        card.setMedia(image);

        Span post = new Span(person.post());
        post.getStyle().setWhiteSpace(Style.WhiteSpace.NORMAL);
        card.add(post);

        HorizontalLayout actions = new HorizontalLayout();
        actions.setSpacing(true);
        actions.getStyle().setMarginTop("1rem");
        Icon likeIcon = VaadinIcon.HEART.create();
        Span likes = new Span(person.likes());
        Icon commentIcon = VaadinIcon.COMMENT.create();
        Span comments = new Span(person.comments());
        Icon shareIcon = VaadinIcon.CONNECT.create();
        Span shares = new Span(person.shares());
        actions.add(likeIcon, likes, commentIcon, comments, shareIcon, shares);
        card.add(actions);

        return card;
    }

    @Override
    public void afterNavigation(AfterNavigationEvent event) {
        // Set some data when this view is displayed.
        List<Person> persons = Arrays.asList(
            new Person("https://randomuser.me/api/portraits/men/42.jpg", "John Smith", "May 8", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/women/42.jpg", "Abagail Libbie", "May 3", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/men/24.jpg", "Alberto Raya", "May 3", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/women/24.jpg", "Emmy Elsner", "Apr 22", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/men/76.jpg", "Alf Huncoot", "Apr 21", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/women/76.jpg", "Lidmila Vilensky", "Apr 17", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/men/94.jpg", "Jarrett Cawsey", "Apr 17", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/women/94.jpg", "Tania Perfilyeva", "Mar 8", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/men/16.jpg", "Ivan Polo", "Mar 5", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/women/16.jpg", "Emelda Scandroot", "Mar 5", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/men/67.jpg", "Marcos Sá", "Mar 4", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20"),
            new Person("https://randomuser.me/api/portraits/women/67.jpg", "Jacqueline Asong", "Mar 2", "In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate the visual form of a document without relying on meaningful content (also called greeking).", "1K", "500", "20")
        );
        grid.setItems(persons);
    }

    public record Person(String image, String name, String date, String post, String likes, String comments, String shares) { }

}
