package com.vaadin.copilot.ai;

import java.util.Base64;
import java.util.function.Consumer;

import com.vaadin.copilot.CopilotServerClient;

public class UIFromImage {

    public record UIFromImageData(byte[] imageData, String mimeType, boolean flow) {

    }

    public record UIFromImageRequest(UIFromImageData data, CopilotServerClient.AccessControlData accessControlData) {
    }

    public record UIFromImageResponse(String code) {
    }

    public static void convertImageToCode(String imageBase64Data, String imageMimeType, boolean flow,
            Consumer<String> codeConsumer, Consumer<Throwable> errorHandler) {
        byte[] imageData = Base64.getDecoder().decode(imageBase64Data);
        UIFromImageRequest request = new UIFromImageRequest(new UIFromImageData(imageData, imageMimeType, flow),
                CopilotServerClient.AccessControlData.create());

        new CopilotServerClient().sendCopilotRequest("ui-from-image", request, UIFromImageResponse.class, response -> {
            codeConsumer.accept(response.code());
        }, errorHandler);

    }

}
