package com.vaadin.copilot.customcomponent;

/**
 * Contains information about custom component instance.
 */
public class CustomComponentInstanceInfo extends ComponentInfoForCustomComponentSupport {
    private CustomComponent.Type type;
    private String activeLevel;
    private boolean defaultConstructorPresence;
    private final String javaClassName;
    private final String customComponentFilePath;
    private final boolean litTemplate;

    public CustomComponentInstanceInfo(CustomComponent.Type type, String activeLevel, String javaClassName,
            String customComponentFilePath, boolean litTemplate) {
        this.type = type;
        this.activeLevel = activeLevel;
        this.javaClassName = javaClassName;
        this.customComponentFilePath = customComponentFilePath;
        this.litTemplate = litTemplate;
    }

    public CustomComponent.Type getType() {
        return type;
    }

    public void setType(CustomComponent.Type type) {
        this.type = type;
    }

    public String getActiveLevel() {
        return activeLevel;
    }

    public void setActiveLevel(String activeLevel) {
        this.activeLevel = activeLevel;
    }

    public String getJavaClassName() {
        return javaClassName;
    }

    public String getCustomComponentFilePath() {
        return customComponentFilePath;
    }

    public boolean isLitTemplate() {
        return litTemplate;
    }

    public boolean isDefaultConstructorPresence() {
        return defaultConstructorPresence;
    }

    public void setDefaultConstructorPresence(boolean defaultConstructorPresence) {
        this.defaultConstructorPresence = defaultConstructorPresence;
    }
}
